/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.tx;

import com.atlassian.fecru.tx.TxHelperStylePlatformTransactionManager;
import com.cenqua.crucible.hibernate.DBType;
import com.cenqua.crucible.hibernate.DatabaseConfig;
import com.cenqua.crucible.hibernate.HibernateUtil;
import com.cenqua.fisheye.config1.DriverSource;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.transaction.TransactionStatus;

public class TxHelperStylePlatformTransactionManagerTest {
    private TxHelperStylePlatformTransactionManager txHelperStylePlatformTransactionManager;

    @Before
    public void setUp() throws Exception {
        this.txHelperStylePlatformTransactionManager = new TxHelperStylePlatformTransactionManager();
        DatabaseConfig databaseConfig = new DatabaseConfig(DBType.HSQL, "jdbc:hsqldb:mem:test", "sa", "", DriverSource.BUNDLED, 5, 20);
        HibernateUtil.setUp((DatabaseConfig)databaseConfig);
        HibernateUtil.commitAllTransactions();
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testGetTransactionWithTransactionDefinitionNull() throws Exception {
        Assert.assertThat((Object)this.txHelperStylePlatformTransactionManager.getTransaction(null), (Matcher)Matchers.notNullValue());
    }

    @Test
    public void testGetTransactionStartsTransaction() throws Exception {
        Assert.assertThat((Object)HibernateUtil.isCurrentTransaction(), (Matcher)Matchers.is((Object)false));
        this.txHelperStylePlatformTransactionManager.getTransaction(null);
        Assert.assertThat((Object)HibernateUtil.isCurrentTransaction(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void testCommitTransactionClosesTransaction() throws Exception {
        Assert.assertThat((Object)HibernateUtil.isCurrentTransaction(), (Matcher)Matchers.is((Object)false));
        TransactionStatus transactionStatus = this.txHelperStylePlatformTransactionManager.getTransaction(null);
        Assert.assertThat((Object)HibernateUtil.isCurrentTransaction(), (Matcher)Matchers.is((Object)true));
        this.txHelperStylePlatformTransactionManager.commit(transactionStatus);
        Assert.assertThat((Object)HibernateUtil.isCurrentTransaction(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testCommitTransactionClosesTransactionWithNestedTransaction() throws Exception {
        Assert.assertThat((Object)HibernateUtil.isCurrentTransaction(), (Matcher)Matchers.is((Object)false));
        TransactionStatus transactionStatusOuter = this.txHelperStylePlatformTransactionManager.getTransaction(null);
        Assert.assertThat((Object)HibernateUtil.isCurrentTransaction(), (Matcher)Matchers.is((Object)true));
        TransactionStatus transactionStatusInner = this.txHelperStylePlatformTransactionManager.getTransaction(null);
        Assert.assertThat((Object)HibernateUtil.isCurrentTransaction(), (Matcher)Matchers.is((Object)true));
        this.txHelperStylePlatformTransactionManager.commit(transactionStatusInner);
        Assert.assertThat((Object)HibernateUtil.isCurrentTransaction(), (Matcher)Matchers.is((Object)true));
        this.txHelperStylePlatformTransactionManager.commit(transactionStatusOuter);
        Assert.assertThat((Object)HibernateUtil.isCurrentTransaction(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testRollbackTransactionClosesTransaction() throws Exception {
        Assert.assertThat((Object)HibernateUtil.isCurrentTransaction(), (Matcher)Matchers.is((Object)false));
        TransactionStatus transactionStatus = this.txHelperStylePlatformTransactionManager.getTransaction(null);
        Assert.assertThat((Object)HibernateUtil.isCurrentTransaction(), (Matcher)Matchers.is((Object)true));
        this.txHelperStylePlatformTransactionManager.rollback(transactionStatus);
        Assert.assertThat((Object)HibernateUtil.isCurrentTransaction(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testRollbackTransactionClosesTransactionWithNestedTransaction() throws Exception {
        Assert.assertThat((Object)HibernateUtil.isCurrentTransaction(), (Matcher)Matchers.is((Object)false));
        TransactionStatus transactionStatusOuter = this.txHelperStylePlatformTransactionManager.getTransaction(null);
        Assert.assertThat((Object)HibernateUtil.isCurrentTransaction(), (Matcher)Matchers.is((Object)true));
        TransactionStatus transactionStatusInner = this.txHelperStylePlatformTransactionManager.getTransaction(null);
        Assert.assertThat((Object)HibernateUtil.isCurrentTransaction(), (Matcher)Matchers.is((Object)true));
        this.txHelperStylePlatformTransactionManager.rollback(transactionStatusInner);
        Assert.assertThat((Object)HibernateUtil.isCurrentTransaction(), (Matcher)Matchers.is((Object)false));
    }
}

