/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.testutil;

import com.atlassian.fecru.testutil.Result;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;

public class RunResults<T> {
    private final Iterable<Result<T>> results;
    private final Predicate<? super Throwable> isExpectedException;

    public RunResults(Iterable<Result<T>> results, Predicate<? super Throwable> isExpectedException) {
        this.results = results;
        this.isExpectedException = isExpectedException;
    }

    public Iterable<T> getSuccesses() {
        return Iterables.transform((Iterable)Iterables.filter(this.results, Result.isSuccessPredicate()), Result.toSuccess());
    }

    public Iterable<Throwable> getExpectedErrors() {
        return Iterables.filter(this.getErrors(), this.isExpectedException);
    }

    public Iterable<Throwable> getUnexpectedErrors() {
        return Iterables.filter(this.getErrors(), (Predicate)Predicates.not(this.isExpectedException));
    }

    public Iterable<Throwable> getErrors() {
        return Iterables.transform((Iterable)Iterables.filter(this.results, (Predicate)Predicates.not(Result.isSuccessPredicate())), Result.toError());
    }
}

