/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.testutil;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import java.util.NoSuchElementException;

public abstract class Result<T> {
    private static final Predicate<Result<?>> IS_SUCCESS = Result::isSuccess;
    private static final Function<? super Result<?>, ?> TO_SUCCESS = Result::get;
    private static final Function<? super Result<?>, Throwable> TO_ERROR = Result::getError;

    public abstract boolean isSuccess();

    public abstract T get();

    public abstract Throwable getError();

    public static <T> Result<T> success(T value) {
        return new Success(value);
    }

    public static <T> Result<T> error(Throwable error) {
        return new Error(error);
    }

    public static <T> Predicate<? super Result<T>> isSuccessPredicate() {
        return IS_SUCCESS;
    }

    public static <T> Function<? super Result<T>, ? extends T> toSuccess() {
        return TO_SUCCESS;
    }

    public static <T> Function<? super Result<T>, Throwable> toError() {
        return TO_ERROR;
    }

    private static class Error<T>
    extends Result<T> {
        private final Throwable error;

        private Error(Throwable error) {
            this.error = error;
        }

        @Override
        public boolean isSuccess() {
            return false;
        }

        @Override
        public T get() {
            throw new NoSuchElementException();
        }

        @Override
        public Throwable getError() {
            return this.error;
        }
    }

    private static class Success<T>
    extends Result<T> {
        private final T value;

        private Success(T value) {
            this.value = value;
        }

        @Override
        public boolean isSuccess() {
            return true;
        }

        @Override
        public T get() {
            return this.value;
        }

        @Override
        public Throwable getError() {
            throw new NoSuchElementException();
        }
    }
}

