/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.testutil;

import com.atlassian.fecru.testutil.AggregatedException;
import com.atlassian.fecru.testutil.Result;
import com.atlassian.fecru.testutil.RunResults;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public class ConcurrentRuns {
    private static final Function<Class<?>, Predicate<Object>> CLASS_TO_INSTANCEOF_PREDICATE = Predicates::instanceOf;

    public static <T> RunResults<T> run(Callable<T> operation, int numThreads, int numExecutions, Class<? extends Throwable> ... expectedExceptionClasses) throws Exception {
        return ConcurrentRuns.run(operation, numThreads, numExecutions, ConcurrentRuns.createIsExpectedException(expectedExceptionClasses));
    }

    private static Predicate<? super Throwable> createIsExpectedException(Class<? extends Throwable> ... expectedExceptionClasses) {
        return Predicates.or((Iterable)Iterables.transform(Arrays.asList(expectedExceptionClasses), CLASS_TO_INSTANCEOF_PREDICATE));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> RunResults<T> run(Callable<T> operation, int numThreads, int numExecutions, Predicate<? super Throwable> isExpectedException) throws Exception {
        ExecutorService executorService = Executors.newFixedThreadPool(numThreads);
        try {
            ArrayList futureResults = Lists.newArrayListWithCapacity((int)numExecutions);
            CountDownLatch latch = new CountDownLatch(1);
            for (int i = 0; i < numExecutions; ++i) {
                Future<Object> futureResult2 = executorService.submit(() -> {
                    latch.await();
                    return operation.call();
                });
                futureResults.add(futureResult2);
            }
            latch.countDown();
            ImmutableList results = ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)futureResults, futureResult -> {
                try {
                    return Result.success(futureResult.get(30L, TimeUnit.SECONDS));
                }
                catch (ExecutionException e) {
                    return Result.error(e.getCause());
                }
                catch (Exception e) {
                    return Result.error(e);
                }
            }));
            RunResults runResults = new RunResults(results, (Predicate<? super Throwable>)((Predicate<Throwable>)isExpectedException));
            Iterable<Throwable> unexpectedExceptions = runResults.getUnexpectedErrors();
            if (!Iterables.isEmpty(unexpectedExceptions)) {
                throw new AggregatedException("", unexpectedExceptions);
            }
            RunResults runResults2 = runResults;
            return runResults2;
        }
        finally {
            executorService.shutdownNow();
        }
    }
}

