/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.template;

import com.atlassian.fecru.template.DefaultTemplateManager;
import com.atlassian.fecru.template.TemplateManager;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.FisheyeTestUtil;
import com.cenqua.fisheye.io.IOHelper;
import com.google.common.base.Charsets;
import freemarker.template.Template;
import java.io.File;
import java.nio.charset.Charset;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TemplateManagerTest {
    private String filename = "fish.ftl";
    private TemplateManager templateManager;
    private File oldFishEyeHome;
    private File oldFishEyeInst;
    private File fishEyeInst;
    private File fishEyeHome;

    @Before
    public void setUp() throws Exception {
        this.fishEyeInst = FisheyeTestUtil.createTempDir("fecru-test-fe.inst");
        this.fishEyeHome = FisheyeTestUtil.createTempDir("fecru-test-fe.home");
        new File(this.fishEyeInst, "template").mkdir();
        new File(this.fishEyeHome, "template").mkdir();
        this.oldFishEyeHome = AppConfig.getAppHome();
        this.oldFishEyeInst = AppConfig.getInstanceDir();
        AppConfig.overrideAppHome((File)this.fishEyeHome, (File)this.fishEyeInst);
        this.templateManager = new DefaultTemplateManager();
    }

    @After
    public void tearDown() throws Exception {
        AppConfig.overrideAppHome((File)this.oldFishEyeHome, (File)this.oldFishEyeInst);
        this.fishEyeHome.delete();
        this.fishEyeInst.delete();
    }

    @Test
    public void testLoadingFromHome() throws Exception {
        File file = new File(AppConfig.getAppHome(), "/template/" + this.filename);
        file.deleteOnExit();
        IOHelper.copyStringToFile((String)"[#ftl]\nHomeonly", (Charset)Charsets.UTF_8, (File)file);
        Template fileTemplate = this.templateManager.getTemplate(this.filename);
        Assert.assertEquals((Object)"Homeonly", (Object)fileTemplate.toString());
    }

    @Test
    public void testLoadingFromInst() throws Exception {
        File file = new File(AppConfig.getInstanceDir(), "/template/" + this.filename);
        file.deleteOnExit();
        IOHelper.copyStringToFile((String)"[#ftl]\nInstonly", (Charset)Charsets.UTF_8, (File)file);
        Template fileTemplate = this.templateManager.getTemplate(this.filename);
        Assert.assertEquals((Object)"Instonly", (Object)fileTemplate.toString());
    }

    @Test
    public void testLoadingOrder() throws Exception {
        File homeFile = new File(AppConfig.getAppHome(), "/template/" + this.filename);
        File instFile = new File(AppConfig.getInstanceDir(), "/template/" + this.filename);
        homeFile.deleteOnExit();
        instFile.deleteOnExit();
        IOHelper.copyStringToFile((String)"[#ftl]\nhome", (Charset)Charsets.UTF_8, (File)homeFile);
        IOHelper.copyStringToFile((String)"[#ftl]\ninst", (Charset)Charsets.UTF_8, (File)instFile);
        Template fileTemplate = this.templateManager.getTemplate(this.filename);
        Assert.assertEquals((Object)"inst", (Object)fileTemplate.toString());
    }
}

