/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.security;

import com.atlassian.core.util.StringUtils;
import com.atlassian.fecru.security.SshKeySupplierImpl;
import com.cenqua.fisheye.FishEyeSysProps;
import com.cenqua.fisheye.io.IOHelper;
import com.google.common.base.Charsets;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.KeyPair;
import java.io.File;
import java.nio.charset.Charset;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class SshKeySupplierImplTest {
    private int oldSshKeySize;
    private int oldSshKeypoolSize;
    private SshKeySupplierImpl keySupplier;

    @Before
    public void setUp() throws Exception {
        this.oldSshKeySize = FishEyeSysProps.SSH_KEYSIZE;
        this.oldSshKeypoolSize = FishEyeSysProps.SSH_KEYPOOL_SIZE;
        this.keySupplier = new SshKeySupplierImpl();
    }

    @After
    public void tearDown() throws Exception {
        System.setProperty("fisheye.ssh.keysize", String.valueOf(this.oldSshKeySize));
        System.setProperty("fisheye.ssh.keypool.size", String.valueOf(this.oldSshKeypoolSize));
        FishEyeSysProps.reloadProperties();
    }

    @Test
    public void testGenerateKeyWithSizeFromSysProperty() throws Exception {
        System.setProperty("fisheye.ssh.keysize", String.valueOf(2048));
        FishEyeSysProps.reloadProperties();
        com.atlassian.fisheye.spi.admin.data.KeyPair key = this.keySupplier.get();
        MatcherAssert.assertThat((Object)StringUtils.normalise((String)key.getPrivateKey()).length(), (Matcher)Matchers.is((Matcher)Matchers.closeTo((double)1679.0, (double)10.0)));
    }

    @Test
    public void testGenerateKeyWithDefaultSize() throws Exception {
        com.atlassian.fisheye.spi.admin.data.KeyPair key = this.keySupplier.get();
        MatcherAssert.assertThat((Object)StringUtils.normalise((String)key.getPrivateKey()).length(), (Matcher)Matchers.is((Matcher)Matchers.closeTo((double)3243.0, (double)10.0)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGeneratedKeyIsUnEncrypted() throws Exception {
        com.atlassian.fisheye.spi.admin.data.KeyPair key = this.keySupplier.get();
        File privFile = null;
        File pubFile = null;
        try {
            pubFile = File.createTempFile("ssh", ".pub");
            IOHelper.copyStringToFile((String)key.getPublicKey(), (Charset)Charsets.UTF_8, (File)pubFile);
            privFile = File.createTempFile("ssh", ".priv");
            IOHelper.copyStringToFile((String)key.getPrivateKey(), (Charset)Charsets.UTF_8, (File)privFile);
            JSch jsch = new JSch();
            KeyPair kpair = KeyPair.load((JSch)jsch, (String)privFile.getAbsolutePath(), (String)pubFile.getAbsolutePath());
            MatcherAssert.assertThat((String)"key should be unencrypted", (Object)kpair.isEncrypted(), (Matcher)Matchers.is((Object)false));
            kpair.dispose();
        }
        catch (Throwable throwable) {
            IOHelper.deleteFile((File)pubFile);
            IOHelper.deleteFile(privFile);
            throw throwable;
        }
        IOHelper.deleteFile((File)pubFile);
        IOHelper.deleteFile((File)privFile);
    }
}

