/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.security;

import com.atlassian.fecru.security.SshKey;
import com.atlassian.fecru.security.SshKeyManager;
import com.atlassian.fecru.security.SshKeyManagerImpl;
import com.atlassian.fecru.security.SshKeySupplier;
import com.atlassian.fisheye.spi.admin.data.KeyPair;
import com.cenqua.fisheye.config.RootConfig;
import com.cenqua.fisheye.util.FileSystemUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.contrib.java.lang.system.RestoreSystemProperties;
import org.mockito.Mockito;

public class SshKeyManagerTest {
    private SshKeyManager sshKeyManager;
    private List<String> keyNamesToCleanUp;
    private FileSystemUtils fileSystemUtils;
    @Rule
    public final RestoreSystemProperties restoreSystemProperties = new RestoreSystemProperties();
    private String PRIVATE_KEY_PASSPHRASELESS = "-----BEGIN RSA PRIVATE KEY-----\nMIICXAIBAAKBgQC8oTng/CoycR9iQ8lhWC8NjHk41bHQa5EL+sPwvp7U405RzG+z\ns4YsMRF5+8PyMIgTCEOx0gKHhuFNn0rqVYB3XV/jcvX19pIIqamZ7leHndi+yZDO\nbgDKmUnwlkpNNV7EzomD0aK/kMf8IVPYnVdp8Vpezxb8JiROIO9W2hdmvwIDAQAB\nAoGAawywtT9Gj1PltLW1rtoF8hF7pkaYYCj7qynIU3NK3pSVmRSFfB1xEtlSCsFY\nBbWHNA3npR4DM3jXml7BfFXDzn+xYeqYa7DKzKcHOfqKGE1PJUAXt2wOu9vlA7xC\n8dz8iulsrQRjScE1DzHfHWPYTUE7LHAGSVvmsDyE7e6hk+kCQQDwW/vQv6NLCV9i\nSpsrAviA6eXhJLeJpT/Owu3y6LDL57YLTIS6txAfI+7eZc3AVsOQBkjw4IUtRmS7\nmFPEaRpDAkEAyOeCGHXISRp0R9/Wmitbv8n4nAObzDfARJBqQNNaGfoqgiC2CiaK\nf9W7C1cqOPt+bXCKxlEbMxjJvw8RUmDv1QJBAMcS6FXU42JauO2n7SyKoVfkYck/\np+QRQe/18y6lGwlHOLfTAHvE801XbZg1qVwMgJzhF7ipvKPrEbNuTrL2ehECQESU\nGimFUxf5KsY6F0RLFqeSJwYCiVUdlskQzuRQAQqrBYWj6t/uJgrbB10opOYMmyx6\nZTSrDPDVPlC0sQIAyv0CQFO6W7/0OFIXBaCTcdd6CbspUE7fwHC3oGbd1txDlpmv\niXNVh6CK4AOJ+ypPZPgc3qZNTSTQfIDyIkiNzIpa9xY=\n-----END RSA PRIVATE KEY-----";
    private String PRIVATE_KEY_PASSPHRASE = "-----BEGIN RSA PRIVATE KEY-----\nProc-Type: 4,ENCRYPTED\nDEK-Info: DES-EDE3-CBC,62A347EA9F8BD161\n\nB5PCQb6ee5DynkO4UVR6lmaNFJdgZjYYA4KmAGJjMVtCCOQ1Eu1WGOx/QqR8yfBw\n+iLbUk+I9EIfetZuF8Y/85iO+IKqUYhFjmmtbXfY5z54DwBOp/hTeYwkuOkbSX8y\nrLcOKpCy6Cm6m8SObaMTlb9AAuELzO2NF3w1wOCXurW8Ll6wyNw/abdF80MoX+z7\nyRBfv1kdMsLjBR+uW89HMkYmFdSDJ/9tYJU+0tyCU4QZcNjwTtOPZyfWuKKClmsa\nNGfqxL7VIxOFuzyQcFuEIKEpTL5vA/TAjIFQnvSyf1lF/dPFmkORrjuWZ6EE9oWr\ndGqqTAmoOn1viRJJMV2hgZVbZqDBhDMS5MIsjNc3gK5nXfyuHeA7Waz1vDjd93Om\nkRH5ky7T/AxBx1yyuBQ2bae6+EvlxgaP3f5Gr4wAlfHW6Zw/fq9htBgYMEtPZL/H\nvLDJGAogErWq9zwWJuLjngabyNROdJG0IRa4hgGC4o+DAolCNcNimQ6zDxzmXzIc\nfJNyO1FyUEb9PAiW6kUOoxLZNqayBkZwNgDGMXrAg/H+oRIBCJR1mNyWc/xR7s6u\nl3f/dy9UCDJDoG9Fb6T4BaVG4JhU34e1Hbmo7L+Wvqxj4foUdDPVFZknVE/1/tQE\nfJzKf5esVa0ZxxX4gH1CWa/FotmgWPDt6+s0DJm6DrfBiAgW5KUD/B7fGKwli2sf\nWTJad/wCdDEQU0Do4FxYSBVHGOrxdWzrDKmCNnfaUFWZHyvROPZWqYZ3gRHjUerD\nrtz+c5h4TjyAxX+rs5tRkySajjvCaAOuOOroVxllu0lFtdy/kLkiK/vXQQ9tmGt/\npCpStbeZTTuWLu9gStmqolYicHkf7JlxB1qQJfd64LHiBEgQjFhlemKjXY6gtzBs\nRcevp8R0TKG5Q6Z1SESbZ3raQ2b8xO1ZbcjZGNhN+EDeXHZUr9jR547IwN/G5TCc\nyiZy9QzDK2L3D7p63/RU4ZSmZQmiNLOVt2P+82HrHVNvnTilOARxpZeR1cgNXU+0\nJX81FrVinjxpaVTHn2BaPAM9WopL9/FhKNA8xik4KpulEvcPX/F1KsnTcILKrpJd\nMqpR3QOceKHyGmzmIzsyNsNBDjJW5peAFpuNCAqKWMqCBei4uBuvN57pe4Lb7UJF\nQ7s4T+bOkbZkWMfHkkjHdJHxvNhzgKjJmZqKzLq+t/vzsDQVwq6o59RYi8ZxWcLM\nyYr4V7kUvbkNP0dpKTjoOKhwRPmTH3l+aWItdxzVvjnd4lX5HbGIy6Q+c0WfG4ea\nHe9U3BV+EbS0copTjCZpQHAQs1se0ClpQgxb8kFExiMHa/wj5P7oqB5Ktel9Klu1\nYSWhixpoYZaXt0z9PuR6F1WAP4NxqfOiDIi8i3YJLOyuLqUFZt2rynDHo+x4U0B7\nithDPwzyF7HixsqeQy7fToghPC6kZiO4AJ9UH8sChqS1Pw9u3kCMhgseKl8OTzR0\nLZ9eZ2BAO566c9vff90jEBWlaYh6qOozAMzJprNr13co+PgnQMDRo+aCz4BWUNUX\nllc7C4Z0a650vqTgPienmvJPaOcD5m7mV0FjkErzfcV5WI1qfTUNHg==\n-----END RSA PRIVATE KEY-----";
    private String PUBLIC_KEY_PASSPHRASE = "ssh-rsa AAAAB3NzaC1yc2EAAAABIwAAAQEAxRvrW937nXW8LG6zQ0wMIdYuzrA6DnOcG9p4WvFDWGs9HqsxK1yATTp/ec8sOyqUAb17u5P8pA7ImGJd56MaTFvN5qU8fogc6sNjTSgIID/DAPhwxUgKro6ce3sbpb+u1jwY5erIcY1SoiBT2h23/nOm+pkNlJ0+TCXT9zV3mum/eBwbqXzzejDQPE1zc+ZDFjKaBZA96Xxjx57Rbd/Vk8SpqNbK158ZNOP2CiSAVkdELkH5MZVjB6XPTlnNyccNbf/9zKjQvtApENzH7oChU3HZTpHM8EDc5GAvGw5B+qjIsHT60v+pTOXtIzUlr2qAYaFZ8Qz8zfwkSga+/I42UQ==";

    @Before
    public void setUp() throws Exception {
        this.keyNamesToCleanUp = new ArrayList<String>();
        this.sshKeyManager = this.createSshKeyManager();
    }

    @After
    public void tearDown() throws Exception {
        for (String keyName : this.keyNamesToCleanUp) {
            this.sshKeyManager.removeKey(keyName);
        }
    }

    @Test
    public void testGenerateAndSave() throws Exception {
        String keyName = "test1";
        SshKey key = this.sshKeyManager.generateAndSaveKeyPair(keyName);
        MatcherAssert.assertThat((String)"key should have been generated", (Object)key, (Matcher)Matchers.notNullValue());
        this.keyNamesToCleanUp.add(keyName);
        MatcherAssert.assertThat((String)"public key should have contents", (Object)key.getContents(), (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((String)"returned contents are not equal to what the manager says", (Object)this.sshKeyManager.getPublicKeyContents(keyName), (Matcher)Matchers.is((Object)key.getContents()));
        MatcherAssert.assertThat((String)("the name '" + keyName + "' should have been available"), (Object)key.getName(), (Matcher)Matchers.is((Object)keyName));
        boolean removed = this.sshKeyManager.removeKey(keyName);
        MatcherAssert.assertThat((String)"key should have been removed", (Object)removed, (Matcher)Matchers.is((Object)true));
        this.keyNamesToCleanUp.remove(keyName);
    }

    @Test
    public void testUploadPassphraseless() throws Exception {
        String keyName = "test2";
        String privateContents = this.PRIVATE_KEY_PASSPHRASELESS;
        SshKey key = this.sshKeyManager.saveKeyPair(keyName, null, privateContents);
        MatcherAssert.assertThat((String)"key should have been generated", (Object)key, (Matcher)Matchers.notNullValue());
        this.keyNamesToCleanUp.add(keyName);
        MatcherAssert.assertThat((String)"public key should not have contents", (Object)key.getContents(), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((String)("the name '" + keyName + "' should have been available"), (Object)key.getName(), (Matcher)Matchers.is((Object)keyName));
        boolean removed = this.sshKeyManager.removeKey(keyName);
        MatcherAssert.assertThat((String)"key should have been removed", (Object)removed, (Matcher)Matchers.is((Object)true));
        this.keyNamesToCleanUp.remove(keyName);
    }

    @Test
    public void testUploadPassphrase() throws Exception {
        String keyName = "test3";
        String privateContents = this.PRIVATE_KEY_PASSPHRASE;
        SshKey key = this.sshKeyManager.saveKeyPair(keyName, null, privateContents);
        MatcherAssert.assertThat((String)"key should have been generated", (Object)key, (Matcher)Matchers.notNullValue());
        this.keyNamesToCleanUp.add(keyName);
        MatcherAssert.assertThat((String)"public key should not have contents", (Object)key.getContents(), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((String)("the name '" + keyName + "' should have been available"), (Object)key.getName(), (Matcher)Matchers.is((Object)keyName));
        boolean removed = this.sshKeyManager.removeKey(keyName);
        MatcherAssert.assertThat((String)"key should have been removed", (Object)removed, (Matcher)Matchers.is((Object)true));
        this.keyNamesToCleanUp.remove(keyName);
    }

    private SshKeyManagerImpl createSshKeyManager() {
        SshKeySupplier keySupplier = (SshKeySupplier)Mockito.mock(SshKeySupplier.class);
        Mockito.when((Object)keySupplier.get()).thenReturn((Object)new KeyPair(this.PUBLIC_KEY_PASSPHRASE, this.PRIVATE_KEY_PASSPHRASELESS));
        RootConfig rootConfig = (RootConfig)Mockito.mock(RootConfig.class);
        Mockito.when((Object)rootConfig.getSiteURL()).thenReturn((Object)"http://site.com/url");
        this.fileSystemUtils = (FileSystemUtils)Mockito.mock(FileSystemUtils.class);
        return new SshKeyManagerImpl(rootConfig, this.fileSystemUtils, keySupplier);
    }

    @Test
    public void testGenerateKeyPairShouldContainLabel() throws Exception {
        String keyName = "test1";
        KeyPair keyPair = this.sshKeyManager.generateKeyPair(keyName);
        MatcherAssert.assertThat((String)"public key should contain label", (Object)keyPair.getPublicKey(), (Matcher)Matchers.containsString((String)keyName));
    }

    @Test
    public void testGetPathToSshExecutable_shouldUseSshExePropertyIfSet() {
        System.setProperty("ssh.exe", "/path/to/ssh");
        String pathToSshExecutable = this.sshKeyManager.getPathToSshExecutable();
        MatcherAssert.assertThat((Object)pathToSshExecutable, (Matcher)Matchers.is((Object)"/path/to/ssh"));
    }

    @Test
    public void testGetPathToSshExecutable_shouldSearchPathIfSshExePropertyNotSet() throws IOException {
        System.clearProperty("ssh.exe");
        File sshExe = new File("/path/to/ssh");
        Mockito.when((Object)this.fileSystemUtils.searchPath(new String[]{"ssh", "ssh.exe"})).thenReturn((Object)sshExe);
        String pathToSshExecutable = this.sshKeyManager.getPathToSshExecutable();
        MatcherAssert.assertThat((Object)pathToSshExecutable, (Matcher)Matchers.is((Object)sshExe.getAbsolutePath()));
    }

    @Test
    public void testGetPathToSshExecutable_shouldSearchPathIfSshExePropertyIsEmpty() throws IOException {
        System.setProperty("ssh.exe", "");
        File sshExe = new File("/path/to/ssh");
        Mockito.when((Object)this.fileSystemUtils.searchPath(new String[]{"ssh", "ssh.exe"})).thenReturn((Object)sshExe);
        String pathToSshExecutable = this.sshKeyManager.getPathToSshExecutable();
        MatcherAssert.assertThat((Object)pathToSshExecutable, (Matcher)Matchers.is((Object)sshExe.getAbsolutePath()));
    }
}

