/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.security;

import com.atlassian.fecru.security.DefaultCurrentUserPermissions;
import com.atlassian.fecru.user.EffectiveUserProvider;
import com.atlassian.fecru.user.FecruUser;
import com.cenqua.crucible.model.Principal;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.managers.PermissionManager;
import com.cenqua.crucible.model.managers.UserActionManager;
import java.util.function.Supplier;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Answers;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class DefaultCurrentUserPermissionsTest {
    @Mock
    private EffectiveUserProvider effectiveUserProvider;
    @Mock
    private PermissionManager permissionManager;
    @InjectMocks
    private DefaultCurrentUserPermissions defaultCurrentUserPermissions;
    @Mock
    private Principal principal;
    @Mock
    private FecruUser user;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private Review review;

    @Before
    public void setUp() throws Exception {
        Mockito.when((Object)this.effectiveUserProvider.getEffectivePrincipal()).thenReturn((Object)this.principal);
        Mockito.when((Object)this.effectiveUserProvider.getEffectiveUser()).thenReturn((Object)this.user);
    }

    @Test
    public void testShouldNotCheckPermissionsIfReviewClosed() throws Exception {
        Mockito.when((Object)this.review.isNotClosed()).thenReturn((Object)false);
        boolean canComment = this.defaultCurrentUserPermissions.canCommentReview(this.review);
        boolean canModify = this.defaultCurrentUserPermissions.canModifyReview(this.review);
        boolean canView = this.defaultCurrentUserPermissions.canViewReview(this.review);
        Assert.assertFalse((boolean)canComment);
        Assert.assertFalse((boolean)canModify);
        Assert.assertFalse((boolean)canView);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.permissionManager});
    }

    @Test
    public void testCanComment() throws Exception {
        Mockito.when((Object)this.review.isNotClosed()).thenReturn((Object)true);
        this.mockCanPrincipalDoAction(UserActionManager.ACTION_COMMENT, true);
        boolean canComment = this.defaultCurrentUserPermissions.canCommentReview(this.review);
        Assert.assertTrue((boolean)canComment);
    }

    @Test
    public void testCanModify() throws Exception {
        Mockito.when((Object)this.review.isNotClosed()).thenReturn((Object)true);
        this.mockCanPrincipalDoAction(UserActionManager.ACTION_MOD_FILES, true);
        boolean canModify = this.defaultCurrentUserPermissions.canModifyReview(this.review);
        Assert.assertTrue((boolean)canModify);
    }

    @Test
    public void testCanView() throws Exception {
        Mockito.when((Object)this.review.isNotClosed()).thenReturn((Object)true);
        this.mockCanPrincipalDoAction(UserActionManager.ACTION_VIEW, true);
        boolean canView = this.defaultCurrentUserPermissions.canViewReview(this.review);
        Assert.assertTrue((boolean)canView);
    }

    @Test
    public void shouldCacheCanModify() throws Exception {
        Mockito.when((Object)this.review.isNotClosed()).thenReturn((Object)true);
        this.mockCanPrincipalDoAction(UserActionManager.ACTION_MOD_FILES, true);
        boolean canModify = this.defaultCurrentUserPermissions.canModifyReview(this.review) & this.defaultCurrentUserPermissions.canModifyReview(this.review);
        Assert.assertTrue((boolean)canModify);
        ((PermissionManager)Mockito.verify((Object)this.permissionManager, (VerificationMode)Mockito.times((int)1))).canPrincipalDoAction(this.review.getProject().getPermissionScheme(), this.principal, this.user, UserActionManager.ACTION_MOD_FILES, this.review);
    }

    @Test
    public void shouldCacheCanComment() throws Exception {
        Mockito.when((Object)this.review.isNotClosed()).thenReturn((Object)true);
        this.mockCanPrincipalDoAction(UserActionManager.ACTION_COMMENT, true);
        boolean canComment = this.defaultCurrentUserPermissions.canCommentReview(this.review) & this.defaultCurrentUserPermissions.canCommentReview(this.review);
        Assert.assertTrue((boolean)canComment);
        ((PermissionManager)Mockito.verify((Object)this.permissionManager, (VerificationMode)Mockito.times((int)1))).canPrincipalDoAction(this.review.getProject().getPermissionScheme(), this.principal, this.user, UserActionManager.ACTION_COMMENT, this.review);
    }

    @Test
    public void shouldCacheCanView() throws Exception {
        Mockito.when((Object)this.review.isNotClosed()).thenReturn((Object)true);
        this.mockCanPrincipalDoAction(UserActionManager.ACTION_VIEW, true);
        boolean canView = this.defaultCurrentUserPermissions.canViewReview(this.review) & this.defaultCurrentUserPermissions.canViewReview(this.review);
        Assert.assertTrue((boolean)canView);
        ((PermissionManager)Mockito.verify((Object)this.permissionManager, (VerificationMode)Mockito.times((int)1))).canPrincipalDoAction(this.review.getProject().getPermissionScheme(), this.principal, this.user, UserActionManager.ACTION_VIEW, this.review);
    }

    @Test
    public void shouldNotCacheCanCommentAcrossUserChanges() throws Exception {
        this.checkDoesntCacheAcrossUserChanges(() -> this.defaultCurrentUserPermissions.canCommentReview(this.review), UserActionManager.ACTION_COMMENT);
    }

    @Test
    public void shouldNotCacheCanModifyAcrossUserChanges() throws Exception {
        this.checkDoesntCacheAcrossUserChanges(() -> this.defaultCurrentUserPermissions.canModifyReview(this.review), UserActionManager.ACTION_MOD_FILES);
    }

    @Test
    public void shouldNotCacheCanViewAcrossUserChanges() throws Exception {
        this.checkDoesntCacheAcrossUserChanges(() -> this.defaultCurrentUserPermissions.canViewReview(this.review), UserActionManager.ACTION_VIEW);
    }

    private void checkDoesntCacheAcrossUserChanges(Supplier<Boolean> cached, String action) {
        Mockito.when((Object)this.review.isNotClosed()).thenReturn((Object)true);
        Mockito.when((Object)this.permissionManager.canPrincipalDoAction(this.review.getProject().getPermissionScheme(), this.principal, this.user, action, this.review)).thenReturn((Object)false);
        Mockito.when((Object)this.permissionManager.canPrincipalDoAction(this.review.getProject().getPermissionScheme(), (Principal)Principal.SuperUser.INSTANCE, this.user, action, this.review)).thenReturn((Object)true);
        Mockito.when((Object)this.permissionManager.canPrincipalDoAction(this.review.getProject().getPermissionScheme(), (Principal)Principal.Anonymous.ANON, this.user, action, this.review)).thenReturn((Object)false);
        Mockito.when((Object)this.effectiveUserProvider.getEffectivePrincipal()).thenReturn((Object)this.principal);
        boolean userCanComment = cached.get();
        Mockito.when((Object)this.effectiveUserProvider.getEffectivePrincipal()).thenReturn((Object)Principal.SuperUser.INSTANCE);
        boolean superCanComment = cached.get();
        Mockito.when((Object)this.effectiveUserProvider.getEffectivePrincipal()).thenReturn((Object)Principal.Anonymous.ANON);
        boolean anonCanComment = cached.get();
        Assert.assertFalse((boolean)userCanComment);
        Assert.assertTrue((boolean)superCanComment);
        Assert.assertFalse((boolean)anonCanComment);
    }

    private void mockCanPrincipalDoAction(String action, boolean result) {
        Mockito.when((Object)this.permissionManager.canPrincipalDoAction(this.review.getProject().getPermissionScheme(), this.principal, this.user, action, this.review)).thenReturn((Object)result);
    }
}

