/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.search.users;

import com.atlassian.fecru.search.common.api.SearchResults;
import com.atlassian.fecru.search.common.api.SearchScope;
import com.atlassian.fecru.search.common.api.SearchType;
import com.atlassian.fecru.search.common.lucene.CrossRepoSearcherState;
import com.atlassian.fecru.search.common.lucene.FishEyeQuickSearcherTestCase;
import com.atlassian.fecru.search.index.model.DocInfo;
import com.atlassian.fecru.search.index.service.DocInfoManager;
import com.atlassian.fecru.search.users.CommitterSearchResult;
import com.atlassian.fecru.search.users.CommitterSearcher;
import com.cenqua.fisheye.config.RepositoryManager;
import com.cenqua.fisheye.crossrepo.AuthorDocInfo;
import com.cenqua.fisheye.lucene.CrossRepLuceneIndex;
import com.cenqua.fisheye.lucene.CrossRepLuceneIndexes;
import com.cenqua.fisheye.lucene.searcher.PayloadIndexSearcher;
import com.cenqua.fisheye.lucene.writer.DefaultIndexWriterFactory;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.KeywordAnalyzer;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.store.Directory;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class CommitterSearcherTest
extends FishEyeQuickSearcherTestCase {
    private static final String COMMITTER = "committer ";
    private TestCommitterSearcher searcher;
    private SearchScope searchScope;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.searchScope = SearchScope.builder().withTo(100).withRepositories(new RepositoryHandle[]{this.repositoryHandle}).build();
        RepositoryManager repositoryManager = (RepositoryManager)Mockito.mock(RepositoryManager.class);
        HashMap<String, RepositoryHandle> allRepos = new HashMap<String, RepositoryHandle>(){
            {
                this.put("repoName", null);
            }
        };
        Mockito.when((Object)repositoryManager.getHandleMap()).thenReturn((Object)allRepos);
        this.searcher = new TestCommitterSearcher(repositoryManager, null){

            protected IndexReader getIndexReader() {
                try {
                    return IndexReader.open((Directory)CommitterSearcherTest.this.indexRamDir);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    throw new AssertionError((Object)("Failed to obtain indexReader: " + e.getMessage()));
                }
            }
        };
    }

    @Override
    protected void createDocuments() throws IOException {
        IndexWriter writer = new DefaultIndexWriterFactory().create(this.indexRamDir, (Analyzer)new KeywordAnalyzer(), true);
        DocInfoManager dao = new DocInfoManager(writer, null);
        for (int i = 0; i < 25; ++i) {
            this.addCommitter((DocInfoManager<AuthorDocInfo>)dao, COMMITTER + this.random.nextInt());
        }
        writer.close();
    }

    private void addCommitter(DocInfoManager<AuthorDocInfo> dao, String committer) throws IOException {
        dao.addDoc((DocInfo)new AuthorDocInfo(committer, "repoName"));
    }

    @Test
    public void testBuildSearchResults() throws Exception {
        PayloadIndexSearcher<CrossRepoSearcherState> payloadIndexSearcher = this.searcher.getSearcher(this.searchScope);
        Query query = this.searcher.generateQuery("committer", payloadIndexSearcher, null);
        SearchResults results = this.searcher.buildSearchResults(this.topDocs, this.searchScope, payloadIndexSearcher, "committer", query);
        junit.framework.Assert.assertEquals((int)25, (int)results.getTotalCount());
        int resultCount = 0;
        for (CommitterSearchResult result : results) {
            junit.framework.Assert.assertEquals((String)"repoName", (String)result.getRepository());
            junit.framework.Assert.assertTrue((boolean)result.getAuthorName().startsWith(COMMITTER));
            junit.framework.Assert.assertNotNull((Object)result.getHighlightedName());
            ++resultCount;
        }
        junit.framework.Assert.assertEquals((int)25, (int)resultCount);
    }

    @Test
    public void testProperties() throws Exception {
        junit.framework.Assert.assertEquals((Object)SearchType.COMMITTERS, (Object)this.searcher.getType());
        junit.framework.Assert.assertEquals((Object)CrossRepLuceneIndexes.METADATA, (Object)this.searcher.getIndex());
    }

    @Test
    public void testQuery() throws Exception {
        PayloadIndexSearcher<CrossRepoSearcherState> payloadIndexSearcher = this.searcher.getSearcher(this.searchScope);
        Query query = this.searcher.generateQuery("test", payloadIndexSearcher, null);
        HashSet terms = new HashSet();
        query.extractTerms(terms);
        Assert.assertThat((Object)Iterables.transform(terms, Term::field), (Matcher)Matchers.hasItems((Object[])new String[]{"author", "doctype"}));
    }

    @Test
    public void testEmptyQuery() throws Exception {
        SearchResults results = this.searcher.search("", this.searchScope);
        Assert.assertThat((Object)results.getTotalCount(), (Matcher)Matchers.equalTo((Object)25));
    }

    private static class TestCommitterSearcher
    extends CommitterSearcher {
        private TestCommitterSearcher(RepositoryManager repositoryManager, CrossRepLuceneIndex crossRepLuceneIndex) {
            super(repositoryManager, crossRepLuceneIndex);
        }

        protected PayloadIndexSearcher<CrossRepoSearcherState> getSearcher(SearchScope scope) throws IOException {
            return super.getSearcher(scope);
        }

        protected Query generateQuery(String userQuery, PayloadIndexSearcher<CrossRepoSearcherState> searcher, SearchScope scope) {
            return super.generateQuery(userQuery, searcher, scope);
        }
    }
}

