/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.search.reviews;

import com.atlassian.crucible.activity.lucene.ReviewItemIndexer;
import com.atlassian.fecru.search.common.api.QuickSearchTimeBucket;
import com.atlassian.fecru.search.common.api.SearchResults;
import com.atlassian.fecru.search.common.api.SearchScope;
import com.atlassian.fecru.search.reviews.ProjectSearcherTestBase;
import com.atlassian.fecru.search.reviews.ReviewDetailsResult;
import com.atlassian.fecru.search.reviews.ReviewDetailsSearcher;
import com.cenqua.fisheye.lucene.LuceneConnection;
import com.cenqua.fisheye.lucene.LuceneHelper;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.joda.time.DateTime;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ReviewDetailsSearcherTest
extends ProjectSearcherTestBase {
    private ReviewDetailsSearcher searcher;

    @Before
    public void setUp() throws Exception {
        this.searcher = new ReviewDetailsSearcher(null, null, null){

            protected SearchResults<ReviewDetailsResult> withIndexSearcher(LuceneConnection.IndexSearcherAction<SearchResults<ReviewDetailsResult>> action) {
                return ReviewDetailsSearcherTest.this.withIndexSearcher(action);
            }
        };
        this.searcher.setReviewItemIndexer((ReviewItemIndexer)new ProjectSearcherTestBase.MockProjectSearcherReviewItemIndexer());
    }

    private Document makeReviewDoc(String title, DateTime modifiedDate, String author) {
        Document document = new Document();
        document.add((Fieldable)LuceneHelper.Keyword((String)"type", (String)ReviewItemIndexer.DocumentType.REVIEW.name()));
        document.add((Fieldable)LuceneHelper.Text((String)"reviewTitle", (String)title));
        document.add((Fieldable)LuceneHelper.Text((String)"reviewAuthor", (String)author));
        document.add((Fieldable)new Field("dTimeMillis", LuceneHelper.getTimestampFormat().format(modifiedDate.toDate()), Field.Store.YES, Field.Index.NOT_ANALYZED_NO_NORMS));
        return document;
    }

    @Test
    public void testTimeBuckets() throws Exception {
        DateTime now = new DateTime();
        this.writeDocs(this.makeReviewDoc("test", now, ""), this.makeReviewDoc("test", now.minusHours(12), ""), this.makeReviewDoc("test", now.minusDays(3), ""), this.makeReviewDoc("test", now.minusDays(15), ""), this.makeReviewDoc("test", now.minusMonths(6), ""), this.makeReviewDoc("test", now.minusMonths(18), ""));
        SearchResults any = this.searcher.search("test", SearchScope.builder().withTimeBucket(QuickSearchTimeBucket.ANY_DATE).withCountOnly(true).build());
        SearchResults year = this.searcher.search("test", SearchScope.builder().withTimeBucket(QuickSearchTimeBucket.LAST_YEAR).withCountOnly(true).build());
        SearchResults month = this.searcher.search("test", SearchScope.builder().withTimeBucket(QuickSearchTimeBucket.LAST_MONTH).withCountOnly(true).build());
        SearchResults week = this.searcher.search("test", SearchScope.builder().withTimeBucket(QuickSearchTimeBucket.LAST_WEEK).withCountOnly(true).build());
        SearchResults day = this.searcher.search("test", SearchScope.builder().withTimeBucket(QuickSearchTimeBucket.YESTERDAY).withCountOnly(true).build());
        Assert.assertThat((Object)any.getTotalCount(), (Matcher)Matchers.equalTo((Object)6));
        Assert.assertThat((Object)year.getTotalCount(), (Matcher)Matchers.equalTo((Object)5));
        Assert.assertThat((Object)month.getTotalCount(), (Matcher)Matchers.equalTo((Object)4));
        Assert.assertThat((Object)week.getTotalCount(), (Matcher)Matchers.equalTo((Object)3));
        Assert.assertThat((Object)day.getTotalCount(), (Matcher)Matchers.equalTo((Object)2));
    }

    @Test
    public void testUserFilter() throws Exception {
        this.writeDocs(this.makeReviewDoc("test", new DateTime(), "user1"), this.makeReviewDoc("test", new DateTime(), "user2"));
        SearchResults userFilter = this.searcher.search("test", SearchScope.builder().withUser("user1").withCountOnly(true).build());
        Assert.assertThat((Object)userFilter.getTotalCount(), (Matcher)Matchers.equalTo((Object)1));
    }

    @Test
    public void testEmptyQuery() throws Exception {
        this.writeDocs(this.makeReviewDoc("test", new DateTime(), "user1"));
        SearchResults results = this.searcher.search("", SearchScope.builder().withCountOnly(true).build());
        Assert.assertThat((Object)results.getTotalCount(), (Matcher)Matchers.equalTo((Object)1));
    }
}

