/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.search.reviews;

import com.atlassian.crucible.activity.lucene.ReviewItemIndexer;
import com.atlassian.fecru.search.common.api.QuickSearchTimeBucket;
import com.atlassian.fecru.search.common.api.SearchResults;
import com.atlassian.fecru.search.common.api.SearchScope;
import com.atlassian.fecru.search.reviews.ProjectSearcherTestBase;
import com.atlassian.fecru.search.reviews.ReviewCommentResult;
import com.atlassian.fecru.search.reviews.ReviewCommentsSearcher;
import com.atlassian.fecru.user.EffectiveUserProvider;
import com.cenqua.crucible.model.managers.ProjectManager;
import com.cenqua.fisheye.lucene.LuceneConnection;
import com.cenqua.fisheye.lucene.LuceneHelper;
import java.util.Date;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Fieldable;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.joda.time.DateTime;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class ReviewCommentsSearcherTest
extends ProjectSearcherTestBase {
    private ReviewCommentsSearcher searcher;
    @Mock
    private EffectiveUserProvider effectiveUserProvider;
    @Mock
    private ProjectManager projectManager;

    @Before
    public void setUp() throws Exception {
        this.searcher = new ReviewCommentsSearcher(null, null, this.projectManager){

            protected SearchResults<ReviewCommentResult> withIndexSearcher(LuceneConnection.IndexSearcherAction<SearchResults<ReviewCommentResult>> action) {
                return ReviewCommentsSearcherTest.this.withIndexSearcher(action);
            }
        };
        this.searcher.setReviewItemIndexer((ReviewItemIndexer)new ProjectSearcherTestBase.MockProjectSearcherReviewItemIndexer(this.effectiveUserProvider));
    }

    private Document makeCommentDoc(String title, DateTime modifiedDate, String user) {
        Document document = new Document();
        document.add((Fieldable)LuceneHelper.Keyword((String)"type", (String)ReviewItemIndexer.DocumentType.COMMENT.name()));
        document.add((Fieldable)LuceneHelper.Text((String)"commentText", (String)title));
        document.add((Fieldable)LuceneHelper.lastModifiedField((Date)modifiedDate.toDate()));
        document.add((Fieldable)LuceneHelper.Keyword((String)"commentAuthor", (String)user));
        document.add((Fieldable)LuceneHelper.Keyword((String)"commentDraft", (String)Boolean.toString(false)));
        return document;
    }

    @Test
    public void testTimeBuckets() throws Exception {
        DateTime now = new DateTime();
        this.writeDocs(this.makeCommentDoc("test", now, ""), this.makeCommentDoc("test", now.minusHours(12), ""), this.makeCommentDoc("test", now.minusDays(3), ""), this.makeCommentDoc("test", now.minusDays(15), ""), this.makeCommentDoc("test", now.minusMonths(6), ""), this.makeCommentDoc("test", now.minusMonths(18), ""));
        SearchResults any = this.searcher.search("test", SearchScope.builder().withTimeBucket(QuickSearchTimeBucket.ANY_DATE).withCountOnly(true).build());
        SearchResults year = this.searcher.search("test", SearchScope.builder().withTimeBucket(QuickSearchTimeBucket.LAST_YEAR).withCountOnly(true).build());
        SearchResults month = this.searcher.search("test", SearchScope.builder().withTimeBucket(QuickSearchTimeBucket.LAST_MONTH).withCountOnly(true).build());
        SearchResults week = this.searcher.search("test", SearchScope.builder().withTimeBucket(QuickSearchTimeBucket.LAST_WEEK).withCountOnly(true).build());
        SearchResults day = this.searcher.search("test", SearchScope.builder().withTimeBucket(QuickSearchTimeBucket.YESTERDAY).withCountOnly(true).build());
        Assert.assertThat((Object)any.getTotalCount(), (Matcher)Matchers.equalTo((Object)6));
        Assert.assertThat((Object)year.getTotalCount(), (Matcher)Matchers.equalTo((Object)5));
        Assert.assertThat((Object)month.getTotalCount(), (Matcher)Matchers.equalTo((Object)4));
        Assert.assertThat((Object)week.getTotalCount(), (Matcher)Matchers.equalTo((Object)3));
        Assert.assertThat((Object)day.getTotalCount(), (Matcher)Matchers.equalTo((Object)2));
    }

    @Test
    public void testUserFilter() throws Exception {
        this.writeDocs(this.makeCommentDoc("test", new DateTime(), "user1"), this.makeCommentDoc("test", new DateTime(), "user2"));
        SearchResults userFilter = this.searcher.search("test", SearchScope.builder().withUser("user1").withCountOnly(true).build());
        Assert.assertThat((Object)userFilter.getTotalCount(), (Matcher)Matchers.equalTo((Object)1));
    }

    public void testSearchWithNonExistantProject() throws Exception {
        String projectKey = "ppp";
        Mockito.when((Object)this.projectManager.getProjectByKey(projectKey)).thenReturn(null);
        this.writeDocs(this.makeCommentDoc("test", new DateTime(), "user1"));
        SearchResults nonExistantProejct = this.searcher.search("test", SearchScope.builder().withProjectKey(projectKey).withCountOnly(true).build());
        SearchResults nullProject = this.searcher.search("test", SearchScope.builder().withProjectKey(null).withCountOnly(true).build());
        Assert.assertThat((Object)nonExistantProejct.getTotalCount(), (Matcher)Matchers.equalTo((Object)1));
        Assert.assertThat((Object)nullProject.getTotalCount(), (Matcher)Matchers.equalTo((Object)1));
    }

    @Test
    public void testEmptyQuery() throws Exception {
        this.writeDocs(this.makeCommentDoc("test", new DateTime(), "user1"));
        SearchResults results = this.searcher.search("", SearchScope.builder().withCountOnly(true).build());
        Assert.assertThat((Object)results.getTotalCount(), (Matcher)Matchers.equalTo((Object)1));
    }
}

