/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.search.reviews;

import com.atlassian.crucible.activity.lucene.DefaultReviewItemIndexer;
import com.atlassian.fecru.search.LuceneTestUtils;
import com.atlassian.fecru.user.EffectiveUserProvider;
import com.cenqua.fisheye.lucene.FreeTextAnalyzer;
import com.cenqua.fisheye.lucene.LuceneConnection;
import com.cenqua.fisheye.lucene.writer.DefaultIndexWriterFactory;
import java.io.Closeable;
import java.io.IOException;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.RAMDirectory;
import org.junit.Assert;

public abstract class ProjectSearcherTestBase {
    protected Directory indexDirectory = new RAMDirectory();

    protected void writeDocs(Document ... documents) throws IOException {
        IndexWriter writer = new DefaultIndexWriterFactory().create(this.indexDirectory, (Analyzer)new FreeTextAnalyzer(), true);
        for (Document doc : documents) {
            writer.addDocument(doc);
        }
        writer.commit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected <T> T withIndexSearcher(LuceneConnection.IndexSearcherAction<T> action) {
        Object object;
        IndexSearcher indexSearcher = null;
        try {
            indexSearcher = new IndexSearcher(IndexReader.open((Directory)this.indexDirectory));
            object = action.perform(indexSearcher);
        }
        catch (IOException e) {
            try {
                Assert.fail((String)e.getMessage());
            }
            catch (Throwable throwable) {
                LuceneTestUtils.close(new Closeable[]{indexSearcher});
                throw throwable;
            }
            LuceneTestUtils.close(new Closeable[]{indexSearcher});
            return null;
        }
        LuceneTestUtils.close(new Closeable[]{indexSearcher});
        return (T)object;
    }

    protected static class MockProjectSearcherReviewItemIndexer
    extends DefaultReviewItemIndexer {
        protected MockProjectSearcherReviewItemIndexer() {
            this(null);
        }

        protected MockProjectSearcherReviewItemIndexer(EffectiveUserProvider effectiveUserProvider) {
            super(null, null, null, effectiveUserProvider, null, null, null, null, null);
        }

        public Query queryForSecurityConstraint() {
            return new MatchAllDocsQuery();
        }
    }
}

