/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.search.quicknav;

import com.atlassian.fecru.page.Page;
import com.atlassian.fecru.page.PageRequest;
import com.atlassian.fecru.search.common.api.SearchResults;
import com.atlassian.fecru.search.common.api.SearchScope;
import com.atlassian.fecru.search.quicknav.UserSearchResult;
import com.atlassian.fecru.search.quicknav.UserSearcher;
import com.atlassian.fecru.user.EffectiveUserProvider;
import com.atlassian.fecru.user.FecruUser;
import com.cenqua.fisheye.config.RootConfig;
import com.cenqua.fisheye.user.UserManager;
import com.cenqua.fisheye.user.UserSearchCriteria;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class UserSearcherTest {
    private static final ImmutableList<FecruUser> USERS = ImmutableList.of((Object)new FecruUser("joe"), (Object)new FecruUser("doe"));
    @Mock
    private UserManager userManager;
    @Mock
    private RootConfig rootConfig;
    @Mock
    private EffectiveUserProvider effectiveUserProvider;
    private UserSearcher searcher;

    @Before
    public void setUp() throws Exception {
        this.searcher = new UserSearcher(this.userManager, this.rootConfig, this.effectiveUserProvider);
        Mockito.when((Object)this.userManager.searchUsers((UserSearchCriteria)org.mockito.Matchers.any(UserSearchCriteria.class), (PageRequest)org.mockito.Matchers.any(PageRequest.class))).thenReturn((Object)new Page.Builder().values(USERS).start(0).limit(USERS.size()).lastPage(true).size(USERS.size()).build());
    }

    @Test
    public void testSearch_anonymousNotAllowed() throws Exception {
        Mockito.when((Object)this.effectiveUserProvider.isAnonymous()).thenReturn((Object)true);
        Mockito.when((Object)this.rootConfig.isAnonAccessAllowed()).thenReturn((Object)false);
        Mockito.when((Object)this.rootConfig.isCruAnonAccessAllowed()).thenReturn((Object)false);
        SearchResults anonymousDisallowedResult = this.searcher.search("anonymousDisallowedResult", SearchScope.builder().build());
        Assert.assertThat((Object)anonymousDisallowedResult.getTotalCount(), (Matcher)Matchers.equalTo((Object)0));
        Assert.assertThat((Object)ImmutableList.copyOf((Iterable)anonymousDisallowedResult), (Matcher)Matchers.empty());
    }

    @Test
    public void testSearch_anonymousAllowed() throws Exception {
        Mockito.when((Object)this.effectiveUserProvider.isAnonymous()).thenReturn((Object)true);
        Mockito.when((Object)this.rootConfig.isAnonAccessAllowed()).thenReturn((Object)true);
        SearchResults anonymousAllowedResult = this.searcher.search("anonymousAllowedResult", SearchScope.builder().build());
        this.assertAllUsersReturned((SearchResults<UserSearchResult>)anonymousAllowedResult);
    }

    private void assertAllUsersReturned(SearchResults<UserSearchResult> anonymousAllowedResult) {
        Assert.assertThat((Object)anonymousAllowedResult.getTotalCount(), (Matcher)Matchers.equalTo((Object)2));
        Assert.assertThat((Object)((UserSearchResult)Iterables.get(anonymousAllowedResult, (int)0)).getUsername(), (Matcher)Matchers.equalTo((Object)((FecruUser)USERS.get(0)).getUsername()));
        Assert.assertThat((Object)((UserSearchResult)Iterables.get(anonymousAllowedResult, (int)1)).getUsername(), (Matcher)Matchers.equalTo((Object)((FecruUser)USERS.get(1)).getUsername()));
    }

    @Test
    public void testSearch_nonAnonymous() throws Exception {
        Mockito.when((Object)this.effectiveUserProvider.isAnonymous()).thenReturn((Object)false);
        Mockito.when((Object)this.rootConfig.isAnonAccessAllowed()).thenReturn((Object)false);
        Mockito.when((Object)this.rootConfig.isCruAnonAccessAllowed()).thenReturn((Object)false);
        SearchResults nonAnonymousResult = this.searcher.search("nonAnonymousResult", SearchScope.builder().build());
        this.assertAllUsersReturned((SearchResults<UserSearchResult>)nonAnonymousResult);
    }
}

