/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.search.index.service;

import com.atlassian.fecru.search.index.model.DocInfo;
import com.atlassian.fecru.search.index.service.TestDocInfoManager;
import com.cenqua.fisheye.lucene.CrossRepLuceneIndexes;
import com.cenqua.fisheye.lucene.LuceneConnection;
import com.cenqua.fisheye.lucene.writer.DefaultIndexWriterFactory;
import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.RAMDirectory;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class LuceneTestUtil {
    public static <D extends DocInfo> TestDocInfoManager<D> newRAMDocInfoManager() throws IOException {
        return LuceneTestUtil.newRAMDocInfoManager((Directory)new RAMDirectory());
    }

    public static <D extends DocInfo> TestDocInfoManager<D> newRAMDocInfoManager(Directory dir) throws IOException {
        IndexWriter writer = new DefaultIndexWriterFactory().create(dir, null, true);
        writer.commit();
        return new TestDocInfoManager(writer, IndexReader.open((Directory)dir));
    }

    public static void indexDocs(TestDocInfoManager docInfoManager, Iterable<? extends DocInfo> infoDocs) throws IOException {
        for (DocInfo docInfo : infoDocs) {
            docInfoManager.addDoc(docInfo);
        }
        docInfoManager.commit();
        docInfoManager.closeReader();
    }

    public static LuceneConnection mockLuceneConnection(Directory directory) throws IOException {
        LuceneConnection luceneConnection = (LuceneConnection)Mockito.mock(LuceneConnection.class);
        Mockito.when((Object)luceneConnection.withIndexSearcher((LuceneConnection.IndexConfig)Matchers.any(CrossRepLuceneIndexes.class), (LuceneConnection.IndexSearcherAction)Matchers.any(LuceneConnection.IndexSearcherAction.class))).thenAnswer(invocation -> {
            LuceneConnection.IndexSearcherAction action = (LuceneConnection.IndexSearcherAction)invocation.getArguments()[1];
            return action.perform(new IndexSearcher(IndexReader.open((Directory)directory)));
        });
        return luceneConnection;
    }
}

