/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.search.index.service;

import com.atlassian.fecru.search.index.model.DocInfo;
import com.atlassian.fecru.search.index.model.FieldInfo;
import com.atlassian.fecru.search.index.service.DocInfoManager;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.KeywordAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeMatcher;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class DocInfoManagerTest {
    private final Field id = new Field("id", "1", Field.Store.YES, Field.Index.NOT_ANALYZED_NO_NORMS);
    private final List<Field> valueFields = ImmutableList.of((Object)new Field("values", "value1", Field.Store.NO, Field.Index.ANALYZED), (Object)new Field("values", "value2", Field.Store.NO, Field.Index.ANALYZED));
    private DocInfoManager<DocInfo> docManager;
    @Mock
    private IndexWriter writer;
    @Mock
    private IndexReader reader;

    @Before
    public void setUp() throws Exception {
        this.docManager = new DocInfoManager(this.writer, this.reader);
    }

    @Test
    public void testConvertToDocument() throws Exception {
        TestDocInfo docInfo = new TestDocInfo(this.id, this.valueFields);
        this.docManager.addDoc((DocInfo)docInfo);
        ((IndexWriter)Mockito.verify((Object)this.writer)).addDocument((Document)Matchers.argThat(this.documentWithFields(Iterables.concat(Collections.singleton(this.id), this.valueFields))), (Analyzer)Matchers.any(KeywordAnalyzer.class));
    }

    @Test
    public void testConvertToDocument_includesParentClassFields() throws Exception {
        Field childField = new Field("childField", "childValue", Field.Store.NO, Field.Index.NOT_ANALYZED_NO_NORMS);
        ChildChildTestDocInfo docInfo = new ChildChildTestDocInfo(this.id, this.valueFields, childField);
        this.docManager.addDoc((DocInfo)docInfo);
        ((IndexWriter)Mockito.verify((Object)this.writer)).addDocument((Document)Matchers.argThat(this.documentWithFields(Iterables.concat((Iterable)ImmutableList.of((Object)this.id, (Object)childField), this.valueFields))), (Analyzer)Matchers.any(KeywordAnalyzer.class));
    }

    @Test(expected=IllegalStateException.class)
    public void testConvertToDocument_failsOnUnknownFieldInfoTypes() throws Exception {
        TestDocInfo docInfo = new TestDocInfo(this.id, this.valueFields){
            @FieldInfo
            private String notAField;
            {
                this.notAField = "foobar";
            }
        };
        this.docManager.addDoc((DocInfo)docInfo);
    }

    private TypeSafeMatcher<Document> documentWithFields(final Iterable<Field> fields) {
        return new TypeSafeMatcher<Document>(){

            protected boolean matchesSafely(Document item) {
                return ImmutableSet.copyOf((Collection)item.getFields()).equals((Object)ImmutableSet.copyOf((Iterable)fields));
            }

            public void describeTo(Description description) {
                description.appendValueList("Lucene doc with values", ",", "", fields);
            }
        };
    }

    static class ChildChildTestDocInfo
    extends ChildTestDocInfo {
        ChildChildTestDocInfo(Field id, List<Field> multiValue, Field childField) {
            super(id, multiValue, childField);
        }
    }

    static class ChildTestDocInfo
    extends TestDocInfo {
        @FieldInfo
        private Field childField;

        ChildTestDocInfo(Field id, List<Field> multiValue, Field childField) {
            super(id, multiValue);
            this.childField = childField;
        }
    }

    static class TestDocInfo
    implements DocInfo {
        @FieldInfo
        private Field id;
        @FieldInfo
        private Iterable<Field> multiValue;
        private Field notAfield = new Field("nothere", "novalue", Field.Store.YES, Field.Index.NOT_ANALYZED_NO_NORMS);

        TestDocInfo(Field id, List<Field> multiValue) {
            this.id = id;
            this.multiValue = multiValue;
        }

        public Term getKeyTerm() {
            return new Term(this.id.name(), this.id.stringValue());
        }

        public Analyzer getAnalyzer() {
            return new KeywordAnalyzer();
        }
    }
}

