/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.search.index.model;

import com.atlassian.fecru.search.common.api.QuickSearchTimeBucket;
import com.atlassian.fecru.search.common.api.SearchScope;
import com.atlassian.fecru.search.common.lucene.LuceneHighlighter;
import com.atlassian.fecru.search.index.model.DiffDocInfo;
import com.atlassian.fecru.search.index.model.DocInfo;
import com.atlassian.fecru.search.index.service.LuceneTestUtil;
import com.atlassian.fecru.search.index.service.TestDocInfoManager;
import com.atlassian.fisheye.bucket.TimeZoneVariables;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.rep.RepositoryHandle;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Iterator;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DiffDocInfoTest {
    TestDocInfoManager<DiffDocInfo> dao;

    @Before
    public void setUp() throws Exception {
        this.dao = LuceneTestUtil.newRAMDocInfoManager();
        this.dao.addDoc((DocInfo)this.makeDiffDoc("1 line of added text", null, "path/to/a/file1.txt", "1234", 1234, 1L));
        this.dao.addDoc((DocInfo)this.makeDiffDoc("Another line of added text", "1 line of added text", "path/to/a/file1.txt", "1235", 1235, 2L));
        this.dao.addDoc((DocInfo)this.makeDiffDoc(null, "1 line of added text", "path/to/a/file1.txt", "1236", 1236, 3L));
        this.dao.addDoc((DocInfo)this.makeDiffDoc("2 lines of added text\n line 2 of added text", null, "path/to/a/file1.txt", "1237", 1237, 4L));
        this.dao.commit();
    }

    @Test
    public void testQueryByAddedOrRemoved() throws Exception {
        String userQuery = "1 line of added text";
        Query query = DiffDocInfo.queryByAddedOrRemoved((String)userQuery, (SearchScope)SearchScope.builder().withRepositories(new RepositoryHandle[0]).build());
        int count = this.dao.countDocs(query);
        Assert.assertEquals((long)3L, (long)count);
        Iterator info = this.dao.findDocs(query, DiffDocInfo.CONVERTER, 10).iterator();
        DiffDocInfo diff1 = (DiffDocInfo)info.next();
        Assert.assertEquals((Object)"1234", (Object)diff1.getCsid());
        Assert.assertEquals(null, (Object)diff1.getCvsFileRevision());
        Assert.assertEquals((Object)"/path/to/a", (Object)diff1.getDirPath());
        Assert.assertEquals((Object)"file1.txt", (Object)diff1.getFilename());
        Assert.assertEquals((Object)"1234", (Object)diff1.getRevId());
        Assert.assertEquals((Object)new Term("key", "difftext_/path/to/a/file1.txt@1234"), (Object)diff1.getKeyTerm());
        DiffDocInfo diff2 = (DiffDocInfo)info.next();
        Assert.assertEquals((Object)"1235", (Object)diff2.getCsid());
        DiffDocInfo diff3 = (DiffDocInfo)info.next();
        Assert.assertEquals((Object)"1236", (Object)diff3.getCsid());
        Assert.assertThat((Object)LuceneHighlighter.removeCustomScoring((Query)query).toString(), (Matcher)Matchers.equalTo((Object)("+(addedText:\"" + userQuery + "\"^2.0 removedText:\"" + userQuery + "\")")));
    }

    @Test
    public void testQueryByAddedOrRemoved_withBucket() {
        String userQuery = "foo";
        SearchScope scope = SearchScope.builder().withTimeBucket(QuickSearchTimeBucket.LAST_MONTH).build();
        int startTime = TimeZoneVariables.reduceMillisToHours((long)scope.getTimeBucket().getStartTime().getMillis());
        Query query = DiffDocInfo.queryByAddedOrRemoved((String)userQuery, (SearchScope)scope);
        Assert.assertThat((Object)LuceneHighlighter.removeCustomScoring((Query)query).toString(), (Matcher)Matchers.equalTo((Object)("+(addedText:\"" + userQuery + "\"^2.0 removedText:\"" + userQuery + "\") " + "+lastModified:[" + startTime + " TO *]")));
    }

    @Test
    public void testDocWithNullFields() throws IOException {
        TestDocInfoManager dao = LuceneTestUtil.newRAMDocInfoManager();
        DiffDocInfo doc = new DiffDocInfo(null, null, Path.ROOT, null, 1, 2L, null);
        Assert.assertEquals(null, (Object)doc.getCsid());
        Assert.assertEquals(null, (Object)doc.getCvsFileRevision());
        Assert.assertEquals((Object)"/", (Object)doc.getDirPath());
        Assert.assertEquals((Object)"", (Object)doc.getFilename());
        dao.addDoc((DocInfo)doc);
        dao.commit();
        DiffDocInfo result = (DiffDocInfo)dao.findDoc((Query)new TermQuery(new Term("doctype", "difftext")), DiffDocInfo.CONVERTER);
        Assert.assertEquals((Object)doc.getFilename(), (Object)result.getFilename());
        Assert.assertEquals((Object)doc.getDirPath(), (Object)result.getDirPath());
        Assert.assertEquals((Object)doc.getCsid(), (Object)result.getCsid());
        Assert.assertEquals((Object)doc.getCvsFileRevision(), (Object)result.getCvsFileRevision());
    }

    private DiffDocInfo makeDiffDoc(String added, String removed, String path, String csid, int revid, long timestamp, String cvsrevision) {
        return new DiffDocInfo((Reader)this.makeReader(added), (Reader)this.makeReader(removed), new Path((CharSequence)path), csid, revid, timestamp, cvsrevision);
    }

    private StringReader makeReader(String removed) {
        return removed != null ? new StringReader(removed) : null;
    }

    private DiffDocInfo makeDiffDoc(String added, String removed, String path, String csid, int revid, long timestamp) {
        return this.makeDiffDoc(added, removed, path, csid, revid, timestamp, null);
    }
}

