/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.search.index.model;

import com.atlassian.fecru.search.common.api.SearchScope;
import com.atlassian.fecru.search.index.model.ContentDocInfo;
import com.atlassian.fecru.search.index.model.DocInfo;
import com.atlassian.fecru.search.index.service.LuceneTestUtil;
import com.atlassian.fecru.search.index.service.TestDocInfoManager;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.rep.RepositoryHandle;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Date;
import junit.framework.TestCase;

public class ContentDocInfoTest
extends TestCase {
    TestDocInfoManager<ContentDocInfo> dao;
    final long timestamp = new Date().getTime();

    protected void setUp() throws Exception {
        this.dao = LuceneTestUtil.newRAMDocInfoManager();
        this.dao.addDoc((DocInfo)new ContentDocInfo((Reader)new StringReader("I will not chew gum in class."), new Path((CharSequence)"/path/to/file.txt"), "123", 1, this.timestamp, "cvsrev"));
        this.dao.addDoc((DocInfo)new ContentDocInfo((Reader)new StringReader("Bart Simpson waz ere."), new Path((CharSequence)"/path/to/file1.txt"), "456", 1, this.timestamp, "cvsrev"));
        this.dao.commit();
    }

    public void testIndexContent() throws IOException {
        ContentDocInfo info = (ContentDocInfo)this.dao.findDoc(ContentDocInfo.queryByContent((String)"Bart", (SearchScope)SearchScope.builder().withRepositories(new RepositoryHandle[0]).build()), ContentDocInfo.CONVERTER);
        ContentDocInfoTest.assertEquals((String)"/path/to", (String)info.getDirPath());
        ContentDocInfoTest.assertEquals((String)"file1.txt", (String)info.getFilename());
        ContentDocInfoTest.assertEquals((String)"contents", (String)info.getDoctype());
        ContentDocInfoTest.assertEquals((String)"456", (String)info.getCsid());
        ContentDocInfoTest.assertEquals((Object)new Date(this.timestamp), (Object)info.getTimestamp());
        ContentDocInfoTest.assertEquals((String)"cvsrev", (String)info.getCvsFileRevision());
    }
}

