/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.search.filepaths;

import com.atlassian.fecru.search.filepaths.FilePathUtils;
import junit.framework.Assert;
import org.junit.Test;

public class FilePathUtilsTest {
    public static final String[][] EXPECTED_FROM_BREAK_CC = new String[][]{{"AB", "A B"}, {"ABC", "A B C"}, {"AaBb", "Aa Bb"}, {"AaBC", "Aa B C"}, {"ABbC", "A Bb C"}, {"AaBbCc", "Aa Bb Cc"}, {"ABC9", "A B C 9"}, {"ABC99", "A B C 9 9"}, {"9ABC", "9 A B C"}, {"99ABC", "9 9 A B C"}, {"A9BC", "A 9 B C"}, {"A99BC", "A 9 9 B C"}, {"AaBbCc9", "Aa Bb Cc 9"}, {"AaBbCc99", "Aa Bb Cc 9 9"}};
    public static final String[][] EXPECTED_FROM_REMOVE = new String[][]{{"a-b-c", "abc"}, {"a%%%bc", "abc"}, {"a%%%b^$#c", "abc"}, {"a%b$&!@#$%^&()c", "abc"}, {"test.txt", "test.txt"}, {"index-all.html", "indexall.html"}, {"index-all.html", "indexall.html"}, {"\"index.all.html\"", "index.all.html"}, {"index3.html", "index3.html"}, {"index?.html", "index?.html"}, {"in?ex?.html", "in?ex?.html"}, {"*.html", "*.html"}, {"meaning42", "meaning42"}, {"meaning 42", "meaning42"}, {"meaning.42", "meaning.42"}, {"mea$$^ning#%#%42", "meaning42"}};

    @Test
    public void testIsAntGlobs() throws Exception {
        Assert.assertTrue((boolean)FilePathUtils.isAntGlob((String)"**/path.xml"));
        Assert.assertTrue((boolean)FilePathUtils.isAntGlob((String)"/path.xml"));
        Assert.assertFalse((boolean)FilePathUtils.isAntGlob((String)"path.xml"));
    }

    @Test
    public void testFormatAntGlobs() throws Exception {
        Assert.assertEquals((String)"/path.xml", (String)FilePathUtils.formatAntGlob((String)"path.xml"));
        Assert.assertEquals((String)"/path.xml", (String)FilePathUtils.formatAntGlob((String)"/path.xml"));
    }

    @Test
    public void testIsCamelCase() throws Exception {
        Assert.assertTrue((boolean)FilePathUtils.isCamelCase((String)"ABC"));
        Assert.assertFalse((boolean)FilePathUtils.isCamelCase((String)"abc"));
        Assert.assertTrue((boolean)FilePathUtils.isCamelCase((String)"A3"));
        Assert.assertFalse((boolean)FilePathUtils.isCamelCase((String)"3"));
    }

    @Test
    public void testBreakCamelCases() throws Exception {
        for (String[] data : EXPECTED_FROM_BREAK_CC) {
            Assert.assertEquals((String)("Invalid result for " + data[0]), (String)data[1], (String)FilePathUtils.breakCamelCases((String)data[0]));
        }
    }

    @Test
    public void testRemoveNonAlphaNumeric() throws Exception {
        for (String[] data : EXPECTED_FROM_REMOVE) {
            Assert.assertEquals((String)("Invalid result for " + data[0]), (String)data[1], (String)FilePathUtils.removeNonAlphaNumeric((String)data[0], (boolean)true, (boolean)false));
        }
        Assert.assertEquals((String)"name with space? and *.xml", (String)FilePathUtils.removeNonAlphaNumeric((String)"name with space? and %%^&%^&!%^@()^*.xml", (boolean)true, (boolean)true));
        Assert.assertEquals((String)"name with space and .xml", (String)FilePathUtils.removeNonAlphaNumeric((String)"name with space? and %%^&%^&!%^@()^*.xml", (boolean)false, (boolean)true));
        Assert.assertEquals((String)"namewithspaceand.xml", (String)FilePathUtils.removeNonAlphaNumeric((String)"name with space? and %%^&%^&!%^@()^*.xml", (boolean)false, (boolean)false));
    }
}

