/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.search.filepaths;

import com.atlassian.fecru.search.common.api.QuickSearchTimeBucket;
import com.atlassian.fecru.search.common.api.SearchResults;
import com.atlassian.fecru.search.common.api.SearchScope;
import com.atlassian.fecru.search.common.lucene.CrossRepoSearcherState;
import com.atlassian.fecru.search.common.lucene.PrefixPhraseQuery;
import com.atlassian.fecru.search.common.lucene.RecencyBoostingQuery;
import com.atlassian.fecru.search.filepaths.FilePathSearcher;
import com.atlassian.fecru.search.index.model.DocInfo;
import com.atlassian.fecru.search.index.service.TestDocInfoManager;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.config.RepositoryManager;
import com.cenqua.fisheye.crossrepo.PathDoc;
import com.cenqua.fisheye.crossrepo.PathDocInfo;
import com.cenqua.fisheye.lucene.FreeTextAnalyzer;
import com.cenqua.fisheye.lucene.writer.DefaultIndexWriterFactory;
import com.cenqua.fisheye.rep.RepositoryEngine;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.DisjunctionMaxQuery;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.RAMDirectory;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.IsInstanceOf;
import org.joda.time.DateTime;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;

public class FilePathSearcherTest {
    private FilePathSearcher searcher;
    private CrossRepoSearcherState state;
    private RepositoryManager repositoryManager = (RepositoryManager)Mockito.mock(RepositoryManager.class);
    private final Directory directory = new RAMDirectory();
    private TestDocInfoManager<PathDocInfo> manager;
    private RepositoryHandle repository = (RepositoryHandle)Mockito.mock(RepositoryHandle.class, (Answer)Mockito.RETURNS_DEEP_STUBS);

    @Before
    public void setUp() throws Exception {
        IndexWriter writer = new DefaultIndexWriterFactory().create(this.directory, (Analyzer)new FreeTextAnalyzer(), true);
        IndexReader reader = IndexReader.open((IndexWriter)writer, (boolean)true);
        this.manager = new TestDocInfoManager(writer, reader);
        this.searcher = new FilePathSearcher(this.repositoryManager, null){

            protected IndexReader getIndexReader() {
                try {
                    return IndexReader.open((Directory)FilePathSearcherTest.this.directory);
                }
                catch (IOException e) {
                    Assert.fail((String)e.getMessage());
                    return null;
                }
            }
        };
        this.state = new CrossRepoSearcherState((Map)ImmutableMap.of((Object)"repo1", (Object)Mockito.mock(RepositoryHandle.class), (Object)"repo2", (Object)Mockito.mock(RepositoryHandle.class)), Collections.emptyList());
        Mockito.when((Object)this.repository.getName()).thenReturn((Object)"repo");
        RepositoryEngine engine = (RepositoryEngine)Mockito.mock(RepositoryEngine.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)this.repository.acquireEngine()).thenReturn((Object)engine);
        Mockito.when((Object)engine.getRevisionCache().getDefaultBranch()).thenReturn((Object)"trunk");
    }

    @Test
    public void testGenerateQuery_handlesEmptyTokenStreams() throws Exception {
        Query starQuery = this.searcher.generateQuery("*", null, SearchScope.builder().withRepositories(new RepositoryHandle[0]).build(), this.state);
        Query emptyQuery = this.searcher.generateQuery("", null, SearchScope.builder().withRepositories(new RepositoryHandle[0]).build(), this.state);
        Query specialCharQuery = this.searcher.generateQuery("\u0105\u00f3\u017c\u0142\u0119\u015b\u0107", null, SearchScope.builder().withRepositories(new RepositoryHandle[0]).build(), this.state);
        this.assertIsPrefixQuery(this.getOriginalQuery(starQuery), "*");
        this.assertIsPrefixQuery(this.getOriginalQuery(specialCharQuery), "\u0105\u00f3\u017c\u0142\u0119\u015b\u0107");
        Assert.assertThat((Object)this.getOriginalQuery(emptyQuery), (Matcher)IsInstanceOf.instanceOf(MatchAllDocsQuery.class));
    }

    @Test
    public void testGenerateQuery_handlesSpecialCharsInTokenStreams() throws Exception {
        String userQuery = "Za\u017c\u00f3\u0142\u0107G\u0119\u015bl\u0105Ja\u017a\u0144";
        PrefixPhraseQuery expectedCamelCaseQuery = new PrefixPhraseQuery("fileName");
        expectedCamelCaseQuery.addPrefix("za");
        expectedCamelCaseQuery.addPrefix("g");
        expectedCamelCaseQuery.addPrefix("l");
        expectedCamelCaseQuery.addPrefix("ja");
        Query mixedQuery = this.searcher.generateQuery(userQuery, null, SearchScope.builder().withRepositories(new RepositoryHandle[0]).build(), this.state);
        RecencyBoostingQuery recencyBoostingQuery = (RecencyBoostingQuery)((BooleanQuery)mixedQuery).getClauses()[0].getQuery();
        Assert.assertThat((Object)recencyBoostingQuery.getOriginalQuery(), (Matcher)Matchers.instanceOf(DisjunctionMaxQuery.class));
        DisjunctionMaxQuery originalQuery = (DisjunctionMaxQuery)recencyBoostingQuery.getOriginalQuery();
        Assert.assertThat((Object)Iterables.size((Iterable)originalQuery), (Matcher)Matchers.equalTo((Object)2));
        this.assertIsPrefixQuery((Query)Iterables.get((Iterable)originalQuery, (int)0), userQuery.toLowerCase(new Locale("pl")));
        Assert.assertThat((Object)Iterables.get((Iterable)originalQuery, (int)1), (Matcher)Matchers.equalTo((Object)expectedCamelCaseQuery));
    }

    @Test
    public void testTimeBuckets() throws Exception {
        DateTime now = new DateTime();
        String filename = "build.xml";
        this.manager.addDoc((DocInfo)this.makeDoc(filename, now));
        this.manager.addDoc((DocInfo)this.makeDoc(filename, now.minusHours(12)));
        this.manager.addDoc((DocInfo)this.makeDoc(filename, now.minusDays(3)));
        this.manager.addDoc((DocInfo)this.makeDoc(filename, now.minusDays(15)));
        this.manager.addDoc((DocInfo)this.makeDoc(filename, now.minusMonths(6)));
        this.manager.addDoc((DocInfo)this.makeDoc(filename, now.minusYears(2)));
        this.manager.commit();
        SearchScope.SearchScopeBuilder scopeBuilder = SearchScope.builder().withRepositories(new RepositoryHandle[]{this.repository});
        SearchResults all = this.searcher.search(filename, scopeBuilder.withTimeBucket(QuickSearchTimeBucket.ANY_DATE).build());
        SearchResults day = this.searcher.search(filename, scopeBuilder.withTimeBucket(QuickSearchTimeBucket.YESTERDAY).build());
        SearchResults week = this.searcher.search(filename, scopeBuilder.withTimeBucket(QuickSearchTimeBucket.LAST_WEEK).build());
        SearchResults month = this.searcher.search(filename, scopeBuilder.withTimeBucket(QuickSearchTimeBucket.LAST_MONTH).build());
        SearchResults year = this.searcher.search(filename, scopeBuilder.withTimeBucket(QuickSearchTimeBucket.LAST_YEAR).build());
        Assert.assertThat((Object)all.getTotalCount(), (Matcher)Matchers.equalTo((Object)6));
        Assert.assertThat((Object)year.getTotalCount(), (Matcher)Matchers.equalTo((Object)5));
        Assert.assertThat((Object)month.getTotalCount(), (Matcher)Matchers.equalTo((Object)4));
        Assert.assertThat((Object)week.getTotalCount(), (Matcher)Matchers.equalTo((Object)3));
        Assert.assertThat((Object)day.getTotalCount(), (Matcher)Matchers.equalTo((Object)2));
    }

    @Test
    public void testEmptySearch() throws Exception {
        this.manager.addDoc((DocInfo)this.makeDoc("path", new DateTime()));
        this.manager.commit();
        SearchResults results = this.searcher.search("", SearchScope.builder().withRepositories(new RepositoryHandle[]{this.repository}).build());
        Assert.assertThat((Object)results.getTotalCount(), (Matcher)Matchers.equalTo((Object)1));
    }

    private PathDocInfo makeDoc(String path, DateTime date) {
        return PathDocInfo.fromPathDoc((PathDoc)new PathDoc(new Path((CharSequence)path), PathDoc.Type.FILE, date.toDate()), (String)this.repository.getName());
    }

    private Query getOriginalQuery(Query query) {
        BooleanClause clause = ((BooleanQuery)query).getClauses()[0];
        RecencyBoostingQuery recencyBoostingQuery = (RecencyBoostingQuery)clause.getQuery();
        return recencyBoostingQuery.getOriginalQuery();
    }

    private void assertIsPrefixQuery(Query originalQuery, String prefix) {
        Assert.assertThat((Object)originalQuery, (Matcher)Matchers.instanceOf(PrefixQuery.class));
        Assert.assertThat((Object)((PrefixQuery)originalQuery).getPrefix().field(), (Matcher)Matchers.equalTo((Object)"camelCasedFileName"));
        Assert.assertThat((Object)((PrefixQuery)originalQuery).getPrefix().text(), (Matcher)Matchers.equalTo((Object)prefix));
    }
}

