/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.search.filepaths;

import com.atlassian.fecru.search.filepaths.FilePathHighlighter;
import junit.framework.Assert;
import org.junit.Test;

public class FilePathHighlighterTest {
    private static final String[][] EXPECTED = new String[][]{{"/test/myfile.txt", "file", "/test/my<span class=\"matched-text\">file</span>.txt"}, {"/test/myfile.txt", "myfile", "/test/<span class=\"matched-text\">myfile</span>.txt"}, {"/test/myfile.txt", "myfile.txt", "/test/<span class=\"matched-text\">myfile</span>.<span class=\"matched-text\">txt</span>"}, {"/test/test.txt", "test", "/test/<span class=\"matched-text\">test</span>.txt"}, {"/test/test.txt", "test.txt", "/test/<span class=\"matched-text\">test</span>.<span class=\"matched-text\">txt</span>"}, {"/test/myfile.txt", "*.txt", "/test/myfile.<span class=\"matched-text\">txt</span>"}, {"/CRU-715/changelog.txt", "c.txt", "/CRU-715/<span class=\"matched-text\">c</span>hangelog.<span class=\"matched-text\">txt</span>"}};
    private static final String[][] EXPECTED_CAMELCASES = new String[][]{{"MyFile.txt", "MF", "<span class=\"matched-text\">M</span>y<span class=\"matched-text\">F</span>ile.txt"}, {"MyFile.txt", "MF", "<span class=\"matched-text\">M</span>y<span class=\"matched-text\">F</span>ile.txt"}, {"MyFile.txt", "MFi", "<span class=\"matched-text\">M</span>y<span class=\"matched-text\">Fi</span>le.txt"}, {"MyFile.txt", "MyFi", "<span class=\"matched-text\">My</span><span class=\"matched-text\">Fi</span>le.txt"}, {"MyFile3.txt", "MyFi3", "<span class=\"matched-text\">My</span><span class=\"matched-text\">Fi</span>le<span class=\"matched-text\">3</span>.txt"}, {"MyfiFile.txt", "MyFi", "<span class=\"matched-text\">My</span>fi<span class=\"matched-text\">Fi</span>le.txt"}, {"MyfileFile.txt", "MyFi", "<span class=\"matched-text\">My</span>file<span class=\"matched-text\">Fi</span>le.txt"}, {"AbstractFactory.java", "AbFa", "<span class=\"matched-text\">Ab</span>stract<span class=\"matched-text\">Fa</span>ctory.java"}, {"AbstractFactory.java", "AbstFacto", "<span class=\"matched-text\">Abst</span>ract<span class=\"matched-text\">Facto</span>ry.java"}, {"AdminGroupUserTest.java", "GUT", "Admin<span class=\"matched-text\">G</span>roup<span class=\"matched-text\">U</span>ser<span class=\"matched-text\">T</span>est.java"}, {"AbstractLuceneFactory.java", "ALF", "<span class=\"matched-text\">A</span>bstract<span class=\"matched-text\">L</span>ucene<span class=\"matched-text\">F</span>actory.java"}, {"AbstractLuceneFactory.java", "AbLuFa", "<span class=\"matched-text\">Ab</span>stract<span class=\"matched-text\">Lu</span>cene<span class=\"matched-text\">Fa</span>ctory.java"}, {"AbstractLuceneFactory.java", "AbstLuFacto", "<span class=\"matched-text\">Abst</span>ract<span class=\"matched-text\">Lu</span>cene<span class=\"matched-text\">Facto</span>ry.java"}, {"AbstractLuceneFactory3.java", "AbstLuFacto", "<span class=\"matched-text\">Abst</span>ract<span class=\"matched-text\">Lu</span>cene<span class=\"matched-text\">Facto</span>ry3.java"}, {"AbstractLuceneFactory3.java", "AbstLuFacto3", "<span class=\"matched-text\">Abst</span>ract<span class=\"matched-text\">Lu</span>cene<span class=\"matched-text\">Facto</span>ry<span class=\"matched-text\">3</span>.java"}};
    private static final String[][] EXPECTED_ANT_GLOBS = new String[][]{{"/test/myfile.txt", "**/*.txt", "/test/myfile.<span class=\"matched-text\">txt</span>"}, {"/test/myfile.txt", "/**/*.txt", "/test/myfile.<span class=\"matched-text\">txt</span>"}, {"/test/myfile.txt", "/*/*.txt", "/test/myfile.<span class=\"matched-text\">txt</span>"}, {"/test/myfile.txt", "/*/my*.txt", "/test/<span class=\"matched-text\">my</span>file.<span class=\"matched-text\">txt</span>"}, {"/test/myfile.txt", "/*/my*.txt", "/test/<span class=\"matched-text\">my</span>file.<span class=\"matched-text\">txt</span>"}, {"/test/myfile.txt", "/????/my*.txt", "/test/<span class=\"matched-text\">my</span>file.<span class=\"matched-text\">txt</span>"}, {"/test/myfile.txt", "/*/myf?le.txt", "/test/<span class=\"matched-text\">myf</span>i<span class=\"matched-text\">le</span>.<span class=\"matched-text\">txt</span>"}, {"/test/myfile.txt", "/*/myf*le.txt", "/test/<span class=\"matched-text\">myf</span>i<span class=\"matched-text\">le</span>.<span class=\"matched-text\">txt</span>"}, {"/test/myfile.txt", "/t?st/*.txt", "/<span class=\"matched-text\">t</span>e<span class=\"matched-text\">st</span>/myfile.<span class=\"matched-text\">txt</span>"}, {"/test/myfile.txt", "/T?ST/*.txt", "/<span class=\"matched-text\">t</span>e<span class=\"matched-text\">st</span>/myfile.<span class=\"matched-text\">txt</span>"}, {"/src/java/test/myfile.txt", "/src/**/myfile.txt", "/<span class=\"matched-text\">src</span>/java/test/<span class=\"matched-text\">myfile</span>.<span class=\"matched-text\">txt</span>"}, {"/src/java/test/myfile.txt", "/src/**/test/myfile.txt", "/<span class=\"matched-text\">src</span>/java/<span class=\"matched-text\">test</span>/<span class=\"matched-text\">myfile</span>.<span class=\"matched-text\">txt</span>"}, {"/src/java/test/myfile.txt", "/**/java/**/myfile.txt", "/src/<span class=\"matched-text\">java</span>/test/<span class=\"matched-text\">myfile</span>.<span class=\"matched-text\">txt</span>"}};

    @Test
    public void testHighlighting() throws Exception {
        this.assertResults(EXPECTED);
    }

    @Test
    public void testHighlightingWithCamelCases() throws Exception {
        this.assertResults(EXPECTED_CAMELCASES);
    }

    @Test
    public void testHighlightingWithAntGlobs() throws Exception {
        this.assertResults(EXPECTED_ANT_GLOBS);
    }

    private void assertResults(String[][] data) {
        for (String[] testData : data) {
            String text = testData[0];
            String query = testData[1];
            String expected = testData[2];
            FilePathHighlighter highlighter = new FilePathHighlighter(query);
            Assert.assertEquals((String)("Invalid highlighting for query \"" + query + "\" on " + text), (String)expected, (String)highlighter.highlight(text));
        }
    }
}

