/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.search.diffs;

import com.atlassian.fecru.search.common.api.QuickSearchTimeBucket;
import com.atlassian.fecru.search.common.api.SearchResults;
import com.atlassian.fecru.search.common.api.SearchScope;
import com.atlassian.fecru.search.common.api.SearchType;
import com.atlassian.fecru.search.common.lucene.FishEyeQuickSearcherTestCase;
import com.atlassian.fecru.search.diffs.DiffResult;
import com.atlassian.fecru.search.diffs.DiffSearcher;
import com.atlassian.fecru.search.index.model.DiffDocInfo;
import com.atlassian.fecru.search.index.model.DocInfo;
import com.atlassian.fecru.search.index.service.DocInfoManager;
import com.atlassian.fecru.search.index.service.TestDocInfoManager;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.ScmType;
import com.cenqua.fisheye.lucene.LuceneConnection;
import com.cenqua.fisheye.lucene.LuceneIndexes;
import com.cenqua.fisheye.lucene.writer.DefaultIndexWriterFactory;
import com.cenqua.fisheye.rep.RepositoryEngine;
import com.cenqua.fisheye.rep.RepositoryHandle;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.AbstractMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.KeywordAnalyzer;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.store.Directory;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.joda.time.DateTime;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;

public class DiffSearcherTest
extends FishEyeQuickSearcherTestCase {
    private static final String ADDED_TEXT = " added line ";
    private static final String REMOVED_TEXT = "removed line ";
    private static final String FILE = "file";
    private final DateTime now = new DateTime();

    @Override
    protected void createDocuments() throws IOException {
        IndexWriter writer = new DefaultIndexWriterFactory().create(this.indexRamDir, (Analyzer)new KeywordAnalyzer(), true);
        TestDocInfoManager<DiffDocInfo> dao = new TestDocInfoManager<DiffDocInfo>(writer, null);
        for (int i = 0; i < 24; ++i) {
            DateTime time;
            int csid = this.random.nextInt();
            switch (i) {
                case 0: {
                    time = this.now.minusHours(6);
                    break;
                }
                case 1: {
                    time = this.now.minusDays(3);
                    break;
                }
                case 2: {
                    time = this.now.minusDays(14);
                    break;
                }
                case 3: {
                    time = this.now.minusMonths(6);
                    break;
                }
                case 4: {
                    time = this.now.minusYears(2);
                    break;
                }
                default: {
                    time = this.now;
                }
            }
            this.addDiff(dao, csid, FILE + csid, ADDED_TEXT + csid, REMOVED_TEXT + csid, i, time);
        }
        this.addDiff(dao, 1, "filenot_the_file_youre_looking_for", "nope", "", 123, this.now);
        writer.close();
    }

    private void addDiff(DocInfoManager<DiffDocInfo> writer, int csid, String file, String addedText, String removedText, int revid, DateTime timestamp) throws IOException {
        DiffDocInfo doc = new DiffDocInfo((Reader)new StringReader(addedText), (Reader)new StringReader(removedText), new Path((CharSequence)file), Integer.toString(csid), revid, timestamp.getMillis(), null);
        writer.addDoc((DocInfo)doc);
    }

    @Test
    public void testBuildSearchResults() throws Exception {
        LuceneConnection luceneConnection = (LuceneConnection)Mockito.mock(LuceneConnection.class);
        Mockito.when((Object)this.repositoryEngine.getCrossRepLuceneConnection()).thenReturn((Object)luceneConnection);
        DiffSearcher searcher = new DiffSearcher();
        SearchScope scope = SearchScope.builder().withRepositories(new RepositoryHandle[]{this.repositoryHandle}).withTo(100).build();
        Query query = searcher.generateQuery("text", null, scope);
        SearchResults results = searcher.buildSearchResults(this.topDocs, scope, this.multiSearcher, "text", query);
        junit.framework.Assert.assertEquals((int)25, (int)results.getTotalCount());
        Iterator i = results.iterator();
        int resultCount = 0;
        while (i.hasNext()) {
            DiffResult result = (DiffResult)i.next();
            junit.framework.Assert.assertEquals((String)"repoName", (String)result.getRepository());
            junit.framework.Assert.assertEquals((int)1, (int)result.getFiles().size());
            junit.framework.Assert.assertNotNull((Object)result.getCsid());
            junit.framework.Assert.assertNotNull((Object)result.getDisplayCsid());
            DiffResult.DiffFile diffFile = (DiffResult.DiffFile)result.getFiles().get(0);
            junit.framework.Assert.assertTrue((boolean)diffFile.getFilename().startsWith(FILE));
            junit.framework.Assert.assertNotNull((Object)diffFile.getHighlightedAddedText());
            junit.framework.Assert.assertNotNull((Object)diffFile.getHighlightedRemovedText());
            ++resultCount;
        }
        junit.framework.Assert.assertEquals((int)25, (int)resultCount);
    }

    @Test
    public void testProperties() throws Exception {
        DiffSearcher searcher = new DiffSearcher();
        junit.framework.Assert.assertEquals((Object)SearchType.CHANGESET_DIFFS, (Object)searcher.getType());
        junit.framework.Assert.assertEquals((Object)LuceneIndexes.DIFFTEXT, (Object)searcher.getIndex());
    }

    @Test
    public void testQuery() throws Exception {
        DiffSearcher searcher = new DiffSearcher();
        Query query = searcher.generateQuery("test", null, SearchScope.builder().withRepositories(new RepositoryHandle[0]).build());
        HashSet terms = new HashSet();
        query.extractTerms(terms);
        for (Term term : terms) {
            String field = term.field();
            junit.framework.Assert.assertTrue((String)("incorrect field: " + field), ("addedText".equals(field) || "removedText".equals(field) ? 1 : 0) != 0);
        }
    }

    @Test
    public void testSearch() throws Exception {
        RepositoryHandle handle = (RepositoryHandle)Mockito.mock(RepositoryHandle.class);
        DiffSearcher searcher = this.makeSearcher(handle);
        SearchResults all = searcher.search(ADDED_TEXT, SearchScope.builder().withRepositories(new RepositoryHandle[]{handle}).build());
        Assert.assertThat((Object)all.getTotalCount(), (Matcher)Matchers.equalTo((Object)24));
    }

    @Test
    public void testTimeBuckets() throws Exception {
        RepositoryHandle handle = (RepositoryHandle)Mockito.mock(RepositoryHandle.class);
        DiffSearcher searcher = this.makeSearcher(handle);
        SearchScope.SearchScopeBuilder scopeBuilder = SearchScope.builder().withRepositories(new RepositoryHandle[]{handle});
        SearchResults all = searcher.search(ADDED_TEXT, scopeBuilder.withTimeBucket(QuickSearchTimeBucket.ANY_DATE).build());
        SearchResults year = searcher.search(ADDED_TEXT, scopeBuilder.withTimeBucket(QuickSearchTimeBucket.LAST_YEAR).build());
        SearchResults month = searcher.search(ADDED_TEXT, scopeBuilder.withTimeBucket(QuickSearchTimeBucket.LAST_MONTH).build());
        SearchResults week = searcher.search(ADDED_TEXT, scopeBuilder.withTimeBucket(QuickSearchTimeBucket.LAST_WEEK).build());
        SearchResults day = searcher.search(ADDED_TEXT, scopeBuilder.withTimeBucket(QuickSearchTimeBucket.YESTERDAY).build());
        Assert.assertThat((Object)all.getTotalCount(), (Matcher)Matchers.equalTo((Object)24));
        Assert.assertThat((Object)year.getTotalCount(), (Matcher)Matchers.equalTo((Object)23));
        Assert.assertThat((Object)month.getTotalCount(), (Matcher)Matchers.equalTo((Object)22));
        Assert.assertThat((Object)week.getTotalCount(), (Matcher)Matchers.equalTo((Object)21));
        Assert.assertThat((Object)day.getTotalCount(), (Matcher)Matchers.equalTo((Object)20));
    }

    private DiffSearcher makeSearcher(RepositoryHandle handle) throws RepositoryHandle.StateException {
        final RepositoryEngine engine = (RepositoryEngine)Mockito.mock(RepositoryEngine.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)handle.acquireEngine()).thenReturn((Object)engine);
        Mockito.when((Object)engine.getCfg().getScmConfig().getRepositoryType()).thenReturn((Object)ScmType.SVN);
        return new DiffSearcher(){

            protected Map.Entry<IndexReader, RepositoryEngine> openReader(RepositoryHandle handle) {
                try {
                    return new AbstractMap.SimpleEntry<IndexReader, RepositoryEngine>(IndexReader.open((Directory)DiffSearcherTest.this.indexRamDir), engine);
                }
                catch (IOException e) {
                    Assert.fail((String)e.getMessage());
                    return null;
                }
            }
        };
    }

    @Test
    public void testEmptySearch() throws Exception {
        RepositoryHandle handle = (RepositoryHandle)Mockito.mock(RepositoryHandle.class);
        DiffSearcher searcher = this.makeSearcher(handle);
        SearchResults results = searcher.search("", SearchScope.builder().withRepositories(new RepositoryHandle[]{handle}).build());
        Assert.assertThat((Object)results.getTotalCount(), (Matcher)Matchers.equalTo((Object)25));
    }
}

