/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.search.content;

import com.atlassian.fecru.search.common.api.QuickSearchTimeBucket;
import com.atlassian.fecru.search.common.api.SearchResults;
import com.atlassian.fecru.search.common.api.SearchScope;
import com.atlassian.fecru.search.common.api.SearchType;
import com.atlassian.fecru.search.common.lucene.FishEyeQuickSearcherTestCase;
import com.atlassian.fecru.search.content.ContentResult;
import com.atlassian.fecru.search.content.ContentSearcher;
import com.atlassian.fecru.search.index.model.ContentDocInfo;
import com.atlassian.fecru.search.index.model.DocInfo;
import com.atlassian.fecru.search.index.service.DocInfoManager;
import com.atlassian.fecru.search.index.service.LuceneTestUtil;
import com.atlassian.fecru.search.index.service.TestDocInfoManager;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.ScmType;
import com.cenqua.fisheye.lucene.LuceneIndexes;
import com.cenqua.fisheye.rep.RepositoryEngine;
import com.cenqua.fisheye.rep.RepositoryHandle;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.AbstractMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.store.Directory;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.joda.time.DateTime;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;

public class ContentSearcherTest
extends FishEyeQuickSearcherTestCase {
    private static final String CONTENT = "text ";
    private static final String CONTENT_FILE = "file ";

    @Override
    protected void createDocuments() throws IOException {
        DateTime now = new DateTime();
        TestDocInfoManager<ContentDocInfo> dao = LuceneTestUtil.newRAMDocInfoManager(this.indexRamDir);
        for (int i = 0; i < 25; ++i) {
            DateTime time;
            int id = this.random.nextInt();
            switch (i) {
                case 0: {
                    time = now.minusHours(6);
                    break;
                }
                case 1: {
                    time = now.minusDays(3);
                    break;
                }
                case 2: {
                    time = now.minusDays(14);
                    break;
                }
                case 3: {
                    time = now.minusMonths(6);
                    break;
                }
                case 4: {
                    time = now.minusYears(2);
                    break;
                }
                default: {
                    time = now;
                }
            }
            this.addContentDoc(dao, id, CONTENT + id, CONTENT_FILE + id, i, time);
        }
        dao.commit();
    }

    private void addContentDoc(DocInfoManager<ContentDocInfo> writer, int csid, String content, String file, int revid, DateTime date) throws IOException {
        writer.addDoc((DocInfo)new ContentDocInfo((Reader)new StringReader(content), new Path((CharSequence)file), csid + "", revid, date.getMillis(), null));
    }

    @Test
    public void testBuildSearchResults() throws Exception {
        ContentSearcher searcher = new ContentSearcher();
        SearchScope scope = SearchScope.builder().withRepositories(new RepositoryHandle[]{this.repositoryHandle}).build();
        Query query = searcher.generateQuery("text", null, SearchScope.builder().withRepositories(new RepositoryHandle[0]).build());
        SearchResults results = searcher.buildSearchResults(this.topDocs, scope, this.multiSearcher, "text", query);
        junit.framework.Assert.assertEquals((int)25, (int)results.getTotalCount());
        Iterator i = results.iterator();
        int resultCount = 0;
        while (i.hasNext()) {
            ContentResult result = (ContentResult)i.next();
            junit.framework.Assert.assertEquals((String)"repoName", (String)result.getRepository());
            junit.framework.Assert.assertTrue((boolean)result.getPath().getPath().startsWith(CONTENT_FILE));
            junit.framework.Assert.assertNotNull((Object)result.getCsid());
            junit.framework.Assert.assertNotNull((Object)result.getDisplayCsid());
            junit.framework.Assert.assertNotNull((Object)result.getHighlightedContent());
            ++resultCount;
        }
        junit.framework.Assert.assertEquals((int)scope.length(), (int)resultCount);
    }

    @Test
    public void testProperties() throws Exception {
        ContentSearcher searcher = new ContentSearcher();
        junit.framework.Assert.assertEquals((Object)SearchType.CONTENT, (Object)searcher.getType());
        junit.framework.Assert.assertEquals((Object)LuceneIndexes.CONTENT, (Object)searcher.getIndex());
    }

    @Test
    public void testQuery() throws Exception {
        ContentSearcher searcher = new ContentSearcher();
        Query query = searcher.generateQuery("test", null, SearchScope.builder().withRepositories(new RepositoryHandle[0]).build());
        HashSet terms = new HashSet();
        query.extractTerms(terms);
        for (Term term : terms) {
            junit.framework.Assert.assertEquals((String)"contents", (String)term.field());
        }
    }

    @Test
    public void testTimeBuckets() throws Exception {
        ContentSearcher searcher = this.makeSearcher();
        SearchResults all = searcher.search(CONTENT, SearchScope.builder().withRepositories(new RepositoryHandle[]{this.repositoryHandle}).withTimeBucket(QuickSearchTimeBucket.ANY_DATE).build());
        SearchResults year = searcher.search(CONTENT, SearchScope.builder().withRepositories(new RepositoryHandle[]{this.repositoryHandle}).withTimeBucket(QuickSearchTimeBucket.LAST_YEAR).build());
        SearchResults month = searcher.search(CONTENT, SearchScope.builder().withRepositories(new RepositoryHandle[]{this.repositoryHandle}).withTimeBucket(QuickSearchTimeBucket.LAST_MONTH).build());
        SearchResults week = searcher.search(CONTENT, SearchScope.builder().withRepositories(new RepositoryHandle[]{this.repositoryHandle}).withTimeBucket(QuickSearchTimeBucket.LAST_WEEK).build());
        SearchResults day = searcher.search(CONTENT, SearchScope.builder().withRepositories(new RepositoryHandle[]{this.repositoryHandle}).withTimeBucket(QuickSearchTimeBucket.YESTERDAY).build());
        Assert.assertThat((Object)all.getTotalCount(), (Matcher)Matchers.equalTo((Object)25));
        Assert.assertThat((Object)year.getTotalCount(), (Matcher)Matchers.equalTo((Object)24));
        Assert.assertThat((Object)month.getTotalCount(), (Matcher)Matchers.equalTo((Object)23));
        Assert.assertThat((Object)week.getTotalCount(), (Matcher)Matchers.equalTo((Object)22));
        Assert.assertThat((Object)day.getTotalCount(), (Matcher)Matchers.equalTo((Object)21));
        Assert.assertThat((Object)((ContentResult)day.getIterator().next()).getHighlightedContent(), (Matcher)Matchers.containsString((String)CONTENT.trim()));
    }

    @Test
    public void testEmptySearch() throws Exception {
        ContentSearcher searcher = this.makeSearcher();
        SearchResults results = searcher.search("", SearchScope.builder().withRepositories(new RepositoryHandle[]{this.repositoryHandle}).build());
        Assert.assertThat((Object)results.getTotalCount(), (Matcher)Matchers.equalTo((Object)25));
    }

    private ContentSearcher makeSearcher() throws RepositoryHandle.StateException {
        RepositoryHandle handle = (RepositoryHandle)Mockito.mock(RepositoryHandle.class);
        final RepositoryEngine engine = (RepositoryEngine)Mockito.mock(RepositoryEngine.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)handle.acquireEngine()).thenReturn((Object)engine);
        Mockito.when((Object)engine.getCfg().getScmConfig().getRepositoryType()).thenReturn((Object)ScmType.SVN);
        return new ContentSearcher(){

            protected Map.Entry<IndexReader, RepositoryEngine> openReader(RepositoryHandle handle) {
                try {
                    return new AbstractMap.SimpleEntry<IndexReader, RepositoryEngine>(IndexReader.open((Directory)ContentSearcherTest.this.indexRamDir), engine);
                }
                catch (IOException e) {
                    Assert.fail((String)e.getMessage());
                    return null;
                }
            }
        };
    }
}

