/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.search.common.lucene;

import com.atlassian.fecru.search.common.lucene.RecencyBoostingQuery;
import com.atlassian.fecru.search.index.model.DocInfo;
import com.atlassian.fecru.search.index.service.LuceneTestUtil;
import com.atlassian.fecru.search.index.service.TestDocInfoManager;
import com.atlassian.fisheye.bucket.TimeZoneVariables;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.crossrepo.PathDoc;
import com.cenqua.fisheye.crossrepo.PathDocInfo;
import com.cenqua.fisheye.crossrepo.PathQueryBuilder;
import com.google.common.collect.Iterators;
import java.util.Iterator;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.WildcardQuery;
import org.apache.lucene.search.function.CustomScoreProvider;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.RAMDirectory;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public final class RecencyBoostingQueryTest {
    private TestDocInfoManager<PathDocInfo> dao;
    private IndexReader reader;

    @Before
    public void setUp() throws Exception {
        RAMDirectory dir = new RAMDirectory();
        this.dao = LuceneTestUtil.newRAMDocInfoManager((Directory)dir);
        this.dao.updateDoc((DocInfo)this.makePathDoc("src/never.txt", 0));
        this.dao.updateDoc((DocInfo)this.makePathDoc("src/negative.txt", -1));
        this.dao.updateDoc((DocInfo)this.makePathDoc("src/negative.txt", -100));
        this.dao.updateDoc((DocInfo)this.makePathDoc("src/10-hours.txt", 10));
        this.dao.updateDoc((DocInfo)this.makePathDoc("src/100-hours.txt", 100));
        this.dao.updateDoc((DocInfo)this.makePathDoc("src/1000.txt", 1000));
        this.dao.updateDoc((DocInfo)this.makePathDoc("src/1000.txt", 2000));
        this.dao.updateDoc((DocInfo)this.makePathDoc("src/FromTheFuture.java", Integer.MAX_VALUE));
        this.dao.commit();
        this.reader = IndexReader.open((Directory)dir);
    }

    private PathDocInfo makePathDoc(String path, int hoursSinceEpoch) {
        return PathDocInfo.fromPathDoc((PathDoc)new PathDoc(new Path((CharSequence)path), PathDoc.Type.FILE, TimeZoneVariables.hoursToDate((int)hoursSinceEpoch)), (String)"repo");
    }

    @Test
    public void testLogBoostingStrategy() {
        junit.framework.Assert.assertEquals((Object)(1.0 / Math.log10(3.0)), (Object)RecencyBoostingQuery.LOG_STRATEGY.score(0, 1.0f));
        junit.framework.Assert.assertEquals((Object)(1.0 / Math.log10(4.0)), (Object)RecencyBoostingQuery.LOG_STRATEGY.score(1, 1.0f));
        junit.framework.Assert.assertEquals((Object)1.0, (Object)RecencyBoostingQuery.LOG_STRATEGY.score(7, 1.0f));
        junit.framework.Assert.assertEquals((Object)0.5, (Object)RecencyBoostingQuery.LOG_STRATEGY.score(97, 1.0f));
        junit.framework.Assert.assertEquals((Object)0.3333333333333333, (Object)RecencyBoostingQuery.LOG_STRATEGY.score(997, 1.0f));
        junit.framework.Assert.assertEquals((Object)0.25, (Object)RecencyBoostingQuery.LOG_STRATEGY.score(9997, 1.0f));
        junit.framework.Assert.assertEquals((Object)(1.0 / Math.log10(4.0)), (Object)RecencyBoostingQuery.LOG_STRATEGY.score(10, 10.0f));
        junit.framework.Assert.assertEquals((Object)(1.0 / Math.log10(4.0)), (Object)RecencyBoostingQuery.LOG_STRATEGY.score(1000, 1000.0f));
        junit.framework.Assert.assertEquals((Object)(1.0 / Math.log10(6.0)), (Object)RecencyBoostingQuery.LOG_STRATEGY.score(3000, 1000.0f));
    }

    @Test
    public void testDocumentsAreBoosted() throws Exception {
        String[] expectedPaths = new String[]{"src/FromTheFuture.java", "src/1000.txt", "src/100-hours.txt", "src/10-hours.txt", "src/never.txt", "src/negative.txt"};
        Iterator results = this.dao.findDocs(PathQueryBuilder.newPathCrossRepoQueryBuilder().queryByPath("/src/**").build(), PathDocInfo.CONVERTER, 10).iterator();
        int numResults = 0;
        while (results.hasNext()) {
            PathDocInfo infoDoc = (PathDocInfo)results.next();
            junit.framework.Assert.assertEquals((String)expectedPaths[numResults], (String)infoDoc.getPath());
            ++numResults;
        }
        junit.framework.Assert.assertEquals((int)6, (int)numResults);
    }

    @Test
    public void testFutureDocsFound() throws Exception {
        Query query = PathQueryBuilder.newPathCrossRepoQueryBuilder().queryByPath("src/FromTheFuture.java").build();
        Iterator docs = this.dao.findDocs(query, PathDocInfo.CONVERTER, 10).iterator();
        Assert.assertThat((Object)((PathDocInfo)Iterators.getOnlyElement(docs)).getPath(), (Matcher)CoreMatchers.equalTo((Object)"src/FromTheFuture.java"));
    }

    @Test
    public void testFutureDocsReturnScore() throws Exception {
        RecencyBoostingQuery q = PathQueryBuilder.queryWithRecencyBoost((Query)PathQueryBuilder.newPathCrossRepoQueryBuilder().build());
        CustomScoreProvider recencyBoostingScoreProvider = q.getCustomScoreProvider(this.reader);
        Query query = PathQueryBuilder.newPathCrossRepoQueryBuilder().queryByPath("FromTheFuture.java").build();
        ScoreDoc futureDoc = new IndexSearcher((IndexReader)this.reader).search((Query)query, (int)1).scoreDocs[0];
        Float futureDocScore = Float.valueOf(recencyBoostingScoreProvider.customScore(futureDoc.doc, 0.5f, 0.5f));
        Assert.assertFalse((boolean)futureDocScore.isNaN());
    }

    @Test
    public void testGetOriginalQuery() throws Exception {
        WildcardQuery q = new WildcardQuery(new Term("path", "Test.*"));
        RecencyBoostingQuery rbq = new RecencyBoostingQuery((Query)q, 1.0f, "lastModified");
        junit.framework.Assert.assertEquals((Object)q, (Object)rbq.getOriginalQuery());
    }
}

