/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.search.common.lucene;

import com.atlassian.fecru.search.LuceneTestUtils;
import com.atlassian.fecru.search.common.api.SearchResult;
import com.atlassian.fecru.search.common.api.SearchResults;
import com.atlassian.fecru.search.common.api.SearchScope;
import com.atlassian.fecru.search.common.api.SearchType;
import com.atlassian.fecru.search.common.lucene.MultiIndexRepositorySearcher;
import com.cenqua.fisheye.lucene.LuceneConnection;
import com.cenqua.fisheye.lucene.LuceneIndexes;
import com.cenqua.fisheye.lucene.searcher.MultiRepositoryIndexReader;
import com.cenqua.fisheye.rep.RepositoryEngine;
import com.cenqua.fisheye.rep.RepositoryHandle;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.RAMDirectory;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public final class MultiIndexRepositorySearcherRepositorySearcherTest {
    private static final String[][] DOCS = new String[][]{{"field", "data"}};
    private final RepositoryHandle repositoryHandle = (RepositoryHandle)Mockito.mock(RepositoryHandle.class);
    private final RepositoryEngine repositoryEngine = (RepositoryEngine)Mockito.mock(RepositoryEngine.class);
    private final LuceneConnection luceneConnection = (LuceneConnection)Mockito.mock(LuceneConnection.class);

    @Before
    public void setUp() throws Exception {
        Mockito.when((Object)this.repositoryHandle.acquireEngine()).thenReturn((Object)this.repositoryEngine);
    }

    @Test
    public void testSearchNoRepositories() throws Exception {
        TestableRepositorySearcher repositorySearcher = new TestableRepositorySearcher();
        SearchResults results = repositorySearcher.search("text", SearchScope.builder().withRepositories(new RepositoryHandle[0]).build());
        junit.framework.Assert.assertEquals((int)0, (int)results.getTotalCount());
        Assert.assertFalse((boolean)results.iterator().hasNext());
    }

    @Test
    public void testSearch() throws Exception {
        RAMDirectory indexDir = new RAMDirectory();
        LuceneTestUtils.writeDocuments((Directory)indexDir, DOCS, false, false, false);
        IndexReader reader = IndexReader.open((Directory)indexDir);
        TestableRepositorySearcher repositorySearcher = new TestableRepositorySearcher();
        SearchScope scope = SearchScope.builder().withRepositories(new RepositoryHandle[]{this.repositoryHandle}).build();
        Mockito.when((Object)this.repositoryEngine.getIndexConnection()).thenReturn((Object)this.luceneConnection);
        Mockito.when((Object)this.luceneConnection.leakIndexReader((LuceneConnection.IndexConfig)Mockito.any())).thenReturn((Object)reader);
        repositorySearcher.search("text", scope);
        junit.framework.Assert.assertEquals((Object)scope, (Object)repositorySearcher.scope);
        MultiRepositoryIndexReader multiReader = (MultiRepositoryIndexReader)repositorySearcher.multiSearcher.getIndexReader();
        junit.framework.Assert.assertEquals((int)1, (int)multiReader.getSequentialSubReaders().length);
        junit.framework.Assert.assertEquals((Object)this.repositoryEngine, (Object)multiReader.getRepositoryEngineForDoc(1));
        junit.framework.Assert.assertNotNull((Object)repositorySearcher.query);
        junit.framework.Assert.assertEquals((int)1, (int)((TestableRepositorySearcher)repositorySearcher).hits.totalHits);
        junit.framework.Assert.assertEquals((int)1, (int)((TestableRepositorySearcher)repositorySearcher).hits.scoreDocs.length);
        Assert.assertThat((Object)multiReader.getRefCount(), (Matcher)Matchers.equalTo((Object)0));
    }

    @Test
    public void testCount() throws Exception {
        RAMDirectory indexDir = new RAMDirectory();
        LuceneTestUtils.writeDocuments((Directory)indexDir, DOCS, false, false, false);
        IndexReader reader = IndexReader.open((Directory)indexDir);
        TestableRepositorySearcher repositorySearcher = new TestableRepositorySearcher();
        SearchScope scope = SearchScope.builder().withCountOnly(true).withRepositories(new RepositoryHandle[]{this.repositoryHandle}).build();
        Mockito.when((Object)this.repositoryEngine.getIndexConnection()).thenReturn((Object)this.luceneConnection);
        Mockito.when((Object)this.luceneConnection.leakIndexReader((LuceneConnection.IndexConfig)Mockito.any())).thenReturn((Object)reader);
        SearchResults results = repositorySearcher.search("text", scope);
        junit.framework.Assert.assertEquals((int)1, (int)results.getTotalCount());
        junit.framework.Assert.assertEquals((boolean)false, (boolean)results.iterator().hasNext());
        Assert.assertThat((Object)reader.getRefCount(), (Matcher)Matchers.equalTo((Object)0));
    }

    @Test
    public void testDefaultMaxResult() throws Exception {
        SearchScope scope = SearchScope.builder().withTo(20).build();
        TestableRepositorySearcher repositorySearcher = new TestableRepositorySearcher();
        junit.framework.Assert.assertEquals((int)20, (int)repositorySearcher.getMaxResults(scope));
    }

    @Test
    public void testGetRepository() throws Exception {
        RAMDirectory indexDir = new RAMDirectory();
        LuceneTestUtils.writeDocuments((Directory)indexDir, new String[0][], false, false, false);
        RepositoryEngine repositoryEngine = (RepositoryEngine)Mockito.mock(RepositoryEngine.class);
        IndexSearcher multiSearcher = (IndexSearcher)Mockito.mock(IndexSearcher.class);
        MultiRepositoryIndexReader mockMultiReader = (MultiRepositoryIndexReader)Mockito.mock(MultiRepositoryIndexReader.class);
        Mockito.when((Object)multiSearcher.getIndexReader()).thenReturn((Object)mockMultiReader);
        Mockito.when((Object)mockMultiReader.getRepositoryEngineForDoc(0)).thenReturn((Object)repositoryEngine);
        TestableRepositorySearcher repositorySearcher = new TestableRepositorySearcher();
        junit.framework.Assert.assertEquals((Object)repositoryEngine, (Object)repositorySearcher.getRepositoryForDocument(0, multiSearcher));
    }

    private static class TestableRepositorySearcher
    extends MultiIndexRepositorySearcher<SearchResult> {
        private TopDocs hits;
        private SearchScope scope;
        private IndexSearcher multiSearcher;
        private Query query;

        private TestableRepositorySearcher() {
            super(SearchType.FILE_PATHS, LuceneIndexes.CONTENT);
        }

        protected Query generateQuery(String userQuery, IndexSearcher searcher, SearchScope scope) {
            return new TermQuery(new Term("field", "data"));
        }

        protected SearchResults<SearchResult> buildSearchResults(TopDocs hits, SearchScope scope, IndexSearcher multiSearcher, String queryText, Query query) {
            this.hits = hits;
            this.scope = scope;
            this.multiSearcher = multiSearcher;
            this.query = query;
            return null;
        }
    }
}

