/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.search.common.lucene;

import com.atlassian.fecru.search.common.lucene.LuceneTestUtils;
import com.atlassian.fecru.search.common.lucene.LuceneUtils;
import com.cenqua.fisheye.lucene.FreeTextAnalyzer;
import java.io.IOException;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.FieldSelector;
import org.apache.lucene.document.FieldSelectorResult;
import org.apache.lucene.search.Query;
import org.junit.Assert;
import org.junit.Test;

public class LuceneUtilsTest {
    @Test
    public void testSingleFieldSelector() throws Exception {
        FieldSelector selector = LuceneUtils.singleFieldSelector((String)"field");
        Assert.assertEquals((Object)FieldSelectorResult.NO_LOAD, (Object)selector.accept("anotherfield1"));
        Assert.assertEquals((Object)FieldSelectorResult.LOAD_AND_BREAK, (Object)selector.accept("field"));
        Assert.assertEquals((Object)FieldSelectorResult.NO_LOAD, (Object)selector.accept("anotherfield2"));
    }

    @Test
    public void testMultipleFieldsSelector() throws Exception {
        FieldSelector selector = LuceneUtils.multipleFieldsSelector((String[])new String[]{"field", "anotherfield"});
        Assert.assertEquals((Object)FieldSelectorResult.NO_LOAD, (Object)selector.accept("anotherfield1"));
        Assert.assertEquals((Object)FieldSelectorResult.LOAD, (Object)selector.accept("field"));
        Assert.assertEquals((Object)FieldSelectorResult.NO_LOAD, (Object)selector.accept("anotherfield2"));
        Assert.assertEquals((Object)FieldSelectorResult.LOAD, (Object)selector.accept("anotherfield"));
    }

    @Test
    public void testGeneratePrefixPhraseQuery() throws IOException {
        this.assertSearchMatch("10.20.3-dev-foo", "1.2.3", true);
        this.assertSearchMatch("10.20.3-dev-foo", "1.0.3", false);
        this.assertSearchMatch("10.20.3-dev-foo", "dev.foo", false);
        this.assertSearchMatch("10.20.3-devx-foox", "dev-foo", true);
        this.assertSearchMatch("10.20.3-dev-foo", "foo-dev", false);
        this.assertSearchMatch("10.20.3-dev-foo", "2", true);
    }

    private void assertSearchMatch(String input, String query, boolean expectedFound) throws IOException {
        LuceneTestUtils.assertSearchMatch((Analyzer)new FreeTextAnalyzer(), (LuceneTestUtils.QueryProvider)new OurQueryProvider(), input, query, expectedFound);
    }

    private static class OurQueryProvider
    implements LuceneTestUtils.QueryProvider {
        private OurQueryProvider() {
        }

        @Override
        public Query get(Analyzer analyzer, String field, String query) {
            return LuceneUtils.generatePrefixPhraseQuery((String)query, (String)field, (Analyzer)analyzer);
        }
    }
}

