/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.search.common.lucene;

import com.cenqua.fisheye.lucene.LuceneHelper;
import com.cenqua.fisheye.lucene.writer.DefaultIndexWriterFactory;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import junit.framework.Assert;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.RAMDirectory;

public class LuceneTestUtils {
    public static void assertSearchMatch(Analyzer analyzer, QueryProvider queryProvider, String inputContents, String queryString, boolean expectedFind) throws IOException {
        StringReader input = new StringReader(inputContents);
        LuceneTestUtils.assertSearchMatch(analyzer, queryProvider, input, queryString, expectedFind);
    }

    public static void assertSearchMatch(Analyzer analyzer, QueryProvider queryProvider, Reader input, String queryString, boolean expectedFind) throws IOException {
        RAMDirectory dir = new RAMDirectory();
        IndexWriter writer = new DefaultIndexWriterFactory().create((Directory)dir, analyzer, true);
        Document inDoc = new Document();
        inDoc.add((Fieldable)LuceneHelper.Text((String)"contents", (Reader)input));
        writer.addDocument(inDoc);
        writer.close();
        Query q = queryProvider.get(analyzer, "contents", queryString);
        IndexSearcher searcher = new IndexSearcher(IndexReader.open((Directory)dir));
        TopDocs hits = searcher.search(q, 2);
        if (expectedFind) {
            Assert.assertEquals((int)1, (int)hits.totalHits);
        } else {
            Assert.assertEquals((int)0, (int)hits.totalHits);
        }
        input.close();
    }

    public static interface QueryProvider {
        public Query get(Analyzer var1, String var2, String var3);
    }
}

