/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.search.common.lucene;

import com.atlassian.fecru.search.common.lucene.LuceneHighlighter;
import com.atlassian.fecru.search.common.lucene.RecencyBoostingQuery;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import junit.framework.Assert;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.WhitespaceAnalyzer;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.highlight.SimpleHTMLEncoder;
import org.junit.Test;

public final class LuceneHighlighterTest {
    private static final String TEXT = "sample text with the word text repeated";
    private static final String HIGHLIGHTED_TEXT = "sample <span class=\"matched-text\">text</span> with the word <span class=\"matched-text\">text</span> repeated";
    private static final String TERM_TO_HIGHLIGHT = "text";

    @Test
    public void testHTMLEncoding() throws Exception {
        TestableLuceneHighlighter highlighter = new TestableLuceneHighlighter(null);
        Assert.assertTrue((String)"HTML encoding was disabled", (boolean)(highlighter.getHighlighter().getEncoder() instanceof SimpleHTMLEncoder));
    }

    @Test
    public void testHighlighting() throws Exception {
        TermQuery query = new TermQuery(new Term("", TERM_TO_HIGHLIGHT));
        TestableLuceneHighlighter highlighter = new TestableLuceneHighlighter((Query)query);
        String highlightedText = highlighter.highlight(TEXT, new WhitespaceAnalyzer().tokenStream("", (Reader)new StringReader(TEXT)), "...");
        Assert.assertEquals((String)HIGHLIGHTED_TEXT, (String)highlightedText);
    }

    @Test
    public void testHighlightingWithScoringQuery() throws Exception {
        RecencyBoostingQuery query = new RecencyBoostingQuery((Query)new TermQuery(new Term("", TERM_TO_HIGHLIGHT)), 1.0f, "");
        TestableLuceneHighlighter highlighter = new TestableLuceneHighlighter((Query)query);
        String highlightedText = highlighter.highlight(TEXT, new WhitespaceAnalyzer().tokenStream("", (Reader)new StringReader(TEXT)), "...");
        Assert.assertEquals((String)HIGHLIGHTED_TEXT, (String)highlightedText);
    }

    @Test
    public void testExceptionInHighlighter() throws Exception {
        RecencyBoostingQuery query = new RecencyBoostingQuery((Query)new TermQuery(new Term("", TERM_TO_HIGHLIGHT)), 1.0f, "");
        TestableLuceneHighlighter highlighter = new TestableLuceneHighlighter((Query)query);
        Tokenizer stream = new Tokenizer(new StringReader(TEXT)){

            public boolean incrementToken() throws IOException {
                throw new IOException();
            }
        };
        String highlightedText = highlighter.highlight(TEXT, (TokenStream)stream, "...");
        Assert.assertEquals((String)"", (String)highlightedText);
    }

    private static class TestableLuceneHighlighter
    extends LuceneHighlighter {
        private TestableLuceneHighlighter(Query query) {
            super(query);
        }
    }
}

