/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.search.common.lucene;

import com.cenqua.fisheye.ScmType;
import com.cenqua.fisheye.cache.RevisionCache;
import com.cenqua.fisheye.lucene.searcher.MultiRepositoryIndexReader;
import com.cenqua.fisheye.rep.RepositoryEngine;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.Map;
import java.util.Random;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.RAMDirectory;
import org.junit.After;
import org.junit.Before;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;

public abstract class FishEyeQuickSearcherTestCase {
    protected static final int NUM_DOCS = 25;
    protected static final String REPOSITORY_NAME = "repoName";
    protected final RepositoryEngine repositoryEngine = (RepositoryEngine)Mockito.mock(RepositoryEngine.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
    protected final RepositoryHandle repositoryHandle = (RepositoryHandle)Mockito.mock(RepositoryHandle.class);
    protected final RevisionCache repositoryCache = (RevisionCache)Mockito.mock(RevisionCache.class);
    protected final Directory indexRamDir = new RAMDirectory();
    protected final Random random = new Random();
    protected IndexSearcher multiSearcher;
    protected TopDocs topDocs;

    @Before
    public void setUp() throws Exception {
        Mockito.when((Object)this.repositoryHandle.getName()).thenReturn((Object)REPOSITORY_NAME);
        Mockito.when((Object)this.repositoryHandle.acquireEngine()).thenReturn((Object)this.repositoryEngine);
        Mockito.when((Object)this.repositoryEngine.getName()).thenReturn((Object)REPOSITORY_NAME);
        Mockito.when((Object)this.repositoryEngine.getRevisionCache()).thenReturn((Object)this.repositoryCache);
        Mockito.when((Object)this.repositoryEngine.getCfg().getRepositoryType()).thenReturn((Object)ScmType.SVN);
        this.createDocuments();
        this.topDocs = this.createTopDocs();
        this.multiSearcher = this.createMultiSearcher(this.repositoryEngine);
    }

    @After
    public void tearDown() throws Exception {
        this.multiSearcher.close();
        this.indexRamDir.close();
    }

    protected abstract void createDocuments() throws IOException;

    protected TopDocs createTopDocs() throws IOException {
        IndexReader reader = IndexReader.open((Directory)this.indexRamDir);
        ScoreDoc[] scoreDocs = new ScoreDoc[25];
        for (int i = 0; i < reader.numDocs() && i < 25; ++i) {
            if (reader.isDeleted(i)) continue;
            Document doc = reader.document(i);
            scoreDocs[i] = new ScoreDoc(i, this.random.nextFloat());
        }
        return new TopDocs(25, scoreDocs, 1.0f);
    }

    protected IndexSearcher createMultiSearcher(RepositoryEngine repositoryEngine) throws IOException {
        return new IndexSearcher((IndexReader)new MultiRepositoryIndexReader((Map)ImmutableMap.of((Object)IndexReader.open((Directory)this.indexRamDir), (Object)repositoryEngine)));
    }
}

