/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.search.common.lucene;

import com.atlassian.fecru.search.LuceneTestUtils;
import com.atlassian.fecru.search.common.lucene.FieldHighlighter;
import java.io.Closeable;
import junit.framework.Assert;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.MultiReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.RAMDirectory;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class FieldHighlighterTest {
    private static final String[][] DOCS = new String[][]{{"fieldname", "abc def ijk"}};
    private final Directory indexDir = new RAMDirectory();
    private IndexSearcher multiSearcher;

    @Before
    public void setUp() throws Exception {
        LuceneTestUtils.writeDocuments(this.indexDir, DOCS, true, true, true);
        this.multiSearcher = new IndexSearcher((IndexReader)new MultiReader(new IndexReader[]{IndexReader.open((Directory)this.indexDir)}));
    }

    @After
    public void tearDown() throws Exception {
        LuceneTestUtils.close(new Closeable[]{this.multiSearcher, this.indexDir});
    }

    @Test
    public void testHighlight() throws Exception {
        boolean docId = false;
        String fieldname = "fieldname";
        TermQuery query = new TermQuery(new Term("fieldname", "abc"));
        TestableFieldHighlighter highlighter = new TestableFieldHighlighter(this.multiSearcher, 0, (Query)query);
        Assert.assertEquals((String)"<span class=\"matched-text\">abc</span> def ijk", (String)highlighter.highlight("fieldname"));
    }

    private static class TestableFieldHighlighter
    extends FieldHighlighter {
        private TestableFieldHighlighter(IndexSearcher multiSearcher, int docId, Query query) {
            super(multiSearcher, docId, query);
        }
    }
}

