/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.search.common.lucene;

import com.atlassian.fecru.search.common.api.SearchResult;
import com.atlassian.fecru.search.common.api.SearchResults;
import com.atlassian.fecru.search.common.api.SearchScope;
import com.atlassian.fecru.search.common.lucene.CrossRepoSearcher;
import com.atlassian.fecru.search.common.lucene.CrossRepoSearcherState;
import com.cenqua.fisheye.FisheyeTestUtil;
import com.cenqua.fisheye.config.RepositoryManager;
import com.cenqua.fisheye.lucene.searcher.PayloadIndexSearcher;
import com.cenqua.fisheye.rep.RepositoryEngine;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TopDocs;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class CrossRepoSearcherTest {
    private TestCrossRepoSearcher searchResultCrossRepoSearcher;
    public static final String REPO_A = "repoA";
    public static final String REPO_B = "repoB";
    public static final String REPO_C = "repoC";
    private RepositoryEngine repoEngineB;
    private RepositoryEngine repoEngineC;
    private RepositoryHandle repoHandleA;
    private RepositoryHandle repoHandleB;
    private RepositoryHandle repoHandleC;
    private RepositoryManager repoManager;

    @Before
    public void setUp() throws Exception {
        this.repoEngineB = this.mockRepoEngine(REPO_B);
        this.repoEngineC = this.mockRepoEngine(REPO_C);
        this.repoHandleA = FisheyeTestUtil.mockRepoHandle(REPO_A);
        this.repoHandleB = FisheyeTestUtil.mockRepoHandle(REPO_B);
        this.repoHandleC = FisheyeTestUtil.mockRepoHandle(REPO_C);
        this.repoManager = (RepositoryManager)Mockito.mock(RepositoryManager.class);
        IndexReader indexReader = (IndexReader)Mockito.mock(IndexReader.class);
        this.searchResultCrossRepoSearcher = new TestCrossRepoSearcher(this.repoManager, indexReader);
    }

    @Test
    public void testGetSearcher() throws Exception {
        SearchScope searchScope = SearchScope.builder().withFrom(13).withTo(56).withRepositories(new RepositoryHandle[]{this.repoHandleB, this.repoHandleC}).build();
        ImmutableMap allRepoHandles = Maps.uniqueIndex((Iterable)ImmutableList.of((Object)this.repoHandleA, (Object)this.repoHandleB, (Object)this.repoHandleC), (Function)RepositoryHandle.TO_REPO_NAME);
        Mockito.when((Object)this.repoManager.getHandleMap()).thenReturn((Object)allRepoHandles);
        PayloadIndexSearcher searcher = this.searchResultCrossRepoSearcher.getSearcher(searchScope);
        Assert.assertThat((Object)searcher, (Matcher)CoreMatchers.notNullValue());
        CrossRepoSearcherState searcherState = CrossRepoSearcher.getSearcherState((PayloadIndexSearcher)searcher);
        Assert.assertThat((String)"searcher state set", (Object)searcherState, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)"searching in both repos specified in the search scope", (Object)searcherState.getIncludeRepos(), (Matcher)Matchers.hasSize((int)2));
        Assert.assertThat((String)"searching in both repos specified in the search scope", (Object)searcherState.getIncludeRepos(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{REPO_B, REPO_C}));
        Assert.assertThat((String)"excluding other repo from searches", (Object)searcherState.getExcludeRepos(), (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat((String)"excluding other repo from searches", (Object)searcherState.getExcludeRepos(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{REPO_A}));
    }

    private RepositoryEngine mockRepoEngine(String name) {
        RepositoryEngine repositoryEngine = (RepositoryEngine)Mockito.mock(RepositoryEngine.class);
        Mockito.when((Object)repositoryEngine.getName()).thenReturn((Object)name);
        return repositoryEngine;
    }

    private static class TestCrossRepoSearcher
    extends CrossRepoSearcher<SearchResult> {
        private final IndexReader indexReader;

        protected TestCrossRepoSearcher(RepositoryManager repositoryManager, IndexReader indexReader) {
            super(null, null, repositoryManager, null);
            this.indexReader = indexReader;
        }

        protected Query generateQuery(String userQuery, PayloadIndexSearcher<CrossRepoSearcherState> searcher, SearchScope scope, CrossRepoSearcherState state) throws IOException {
            return null;
        }

        protected SearchResults<SearchResult> buildSearchResults(TopDocs hits, SearchScope scope, PayloadIndexSearcher<CrossRepoSearcherState> searcher, String queryText, Query query) {
            return null;
        }

        protected IndexReader getIndexReader() {
            return this.indexReader;
        }
    }
}

