/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.search.common.lucene;

import com.atlassian.fecru.search.LuceneTestUtils;
import com.atlassian.fecru.search.common.lucene.AntGlobQuery;
import com.cenqua.fisheye.lucene.writer.DefaultIndexWriterFactory;
import java.io.Closeable;
import java.io.IOException;
import junit.framework.Assert;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.KeywordAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.RAMDirectory;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class AntGlobQueryTest {
    private static final String PATH = "field";
    private static final String ID = "id";
    private Directory indexRamDir = new RAMDirectory();
    private IndexSearcher searcher;

    @Before
    public void setUp() throws Exception {
        IndexWriter writer = new DefaultIndexWriterFactory().create(this.indexRamDir, (Analyzer)new KeywordAnalyzer(), true);
        this.addPath(writer, "/src/AntGlobQueryTest.java");
        this.addPath(writer, "/src/test/AntGlobQueryTest.java");
        writer.close();
        this.searcher = new IndexSearcher(IndexReader.open((Directory)this.indexRamDir));
    }

    private void addPath(IndexWriter writer, String path) throws IOException {
        Document document = new Document();
        document.add((Fieldable)new Field(PATH, path, Field.Store.YES, Field.Index.NOT_ANALYZED));
        document.add((Fieldable)new Field(ID, Integer.toString(path.hashCode()), Field.Store.YES, Field.Index.NOT_ANALYZED));
        writer.addDocument(document);
    }

    @After
    public void tearDown() throws Exception {
        LuceneTestUtils.close(new Closeable[]{this.searcher, this.indexRamDir});
    }

    @Test
    public void testAntGlobMatching() throws Exception {
        AntGlobQuery query = new AntGlobQuery(new Term(PATH, "/src/t*/AntGlobQueryT?st.java"));
        TopDocs docs = this.searcher.search((Query)query, 1);
        Assert.assertEquals((int)1, (int)docs.totalHits);
        Assert.assertEquals((String)"/src/test/AntGlobQueryTest.java", (String)this.searcher.doc(docs.scoreDocs[0].doc).get(PATH));
        query = new AntGlobQuery(new Term(PATH, "/src/t**/AntGlobQueryT?st.java"));
        docs = this.searcher.search((Query)query, 1);
        Assert.assertEquals((int)1, (int)docs.totalHits);
        Assert.assertEquals((String)"/src/test/AntGlobQueryTest.java", (String)this.searcher.doc(docs.scoreDocs[0].doc).get(PATH));
    }

    @Test
    public void testLiteralMatching() throws Exception {
        AntGlobQuery query = new AntGlobQuery(new Term(PATH, "/src/test/AntGlobQueryTest.java"));
        TopDocs docs = this.searcher.search((Query)query, 1);
        Assert.assertEquals((int)1, (int)docs.totalHits);
        Assert.assertEquals((String)"/src/test/AntGlobQueryTest.java", (String)this.searcher.doc(docs.scoreDocs[0].doc).get(PATH));
    }

    @Test
    public void testPatternStartWithAntGlob() throws Exception {
        AntGlobQuery query = new AntGlobQuery(new Term(PATH, "**/AntGlobQueryTest.java"));
        TopDocs docs = this.searcher.search((Query)query, 2);
        Assert.assertEquals((int)2, (int)docs.totalHits);
        Assert.assertEquals((String)"/src/AntGlobQueryTest.java", (String)this.searcher.doc(docs.scoreDocs[0].doc).get(PATH));
        Assert.assertEquals((String)"/src/test/AntGlobQueryTest.java", (String)this.searcher.doc(docs.scoreDocs[1].doc).get(PATH));
    }

    @Test
    public void testFirstWildcard() throws Exception {
        AntGlobQuery query = new AntGlobQuery(new Term(PATH, "/src/?ntGlobQue*Test.java"));
        TopDocs docs = this.searcher.search((Query)query, 1);
        Assert.assertEquals((int)1, (int)docs.totalHits);
        Assert.assertEquals((String)"/src/AntGlobQueryTest.java", (String)this.searcher.doc(docs.scoreDocs[0].doc).get(PATH));
        query = new AntGlobQuery(new Term(PATH, "/src/AntGlobQue*Test.j?va"));
        docs = this.searcher.search((Query)query, 1);
        Assert.assertEquals((int)1, (int)docs.totalHits);
        Assert.assertEquals((String)"/src/AntGlobQueryTest.java", (String)this.searcher.doc(docs.scoreDocs[0].doc).get(PATH));
    }

    @Test
    public void testOnlyOneWildcard() throws Exception {
        AntGlobQuery query = new AntGlobQuery(new Term(PATH, "/src/?ntGlobQueryTest.java"));
        TopDocs docs = this.searcher.search((Query)query, 1);
        Assert.assertEquals((int)1, (int)docs.totalHits);
        Assert.assertEquals((String)"/src/AntGlobQueryTest.java", (String)this.searcher.doc(docs.scoreDocs[0].doc).get(PATH));
        query = new AntGlobQuery(new Term(PATH, "/src/*ntGlobQueryTest.java"));
        docs = this.searcher.search((Query)query, 1);
        Assert.assertEquals((int)1, (int)docs.totalHits);
        Assert.assertEquals((String)"/src/AntGlobQueryTest.java", (String)this.searcher.doc(docs.scoreDocs[0].doc).get(PATH));
    }

    @Test
    public void testNoWildcard() throws Exception {
        AntGlobQuery query = new AntGlobQuery(new Term(PATH, "/src/AntGlobQueryTest.java"));
        TopDocs docs = this.searcher.search((Query)query, 1);
        Assert.assertEquals((int)1, (int)docs.totalHits);
        Assert.assertEquals((String)"/src/AntGlobQueryTest.java", (String)this.searcher.doc(docs.scoreDocs[0].doc).get(PATH));
        query = new AntGlobQuery(new Term(PATH, "/src/test.java"));
        docs = this.searcher.search((Query)query, 1);
        Assert.assertEquals((int)0, (int)docs.totalHits);
        Assert.assertEquals((int)0, (int)docs.scoreDocs.length);
    }

    @Test
    public void testCoverage() throws Exception {
        Term term = new Term(PATH, "pattern");
        Assert.assertEquals((String)term.toString(), (String)new AntGlobQuery(term).toString());
    }
}

