/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.search.common.highlighting;

import com.atlassian.crucible.wikirenderer.CrucibleRenderContext;
import com.atlassian.crucible.wikirenderer.CrucibleWikiRenderer;
import com.atlassian.fecru.search.common.highlighting.WikiHighlighter;
import com.atlassian.fisheye.plugin.web.helpers.WikiRenderer;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.RendererConfiguration;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.config.ConfigMockery;
import com.cenqua.fisheye.config.RootConfig;
import com.cenqua.fisheye.syntax.LinkerService;
import junit.framework.Assert;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class WikiHighlighterTest {
    private final RenderContext context = new CrucibleRenderContext(null, " ", "<br>", null);
    private CrucibleWikiRenderer renderer;
    private final RootConfig rootConfig = ConfigMockery.mockRootConfig();
    private RootConfig oldConfig;
    private WikiHighlighter highlighter;

    @Before
    public void setUp() throws Exception {
        this.oldConfig = AppConfig.getsConfig();
        AppConfig.resetConfig((RootConfig)this.rootConfig);
        RendererConfiguration configuration = new RendererConfiguration(){

            public String getWebAppContextPath() {
                return WikiHighlighterTest.this.rootConfig.getContextPath();
            }

            public boolean isNofollowExternalLinks() {
                return false;
            }

            public boolean isAllowCamelCase() {
                return false;
            }

            public String getCharacterEncoding() {
                return "UTF-8";
            }
        };
        this.renderer = new CrucibleWikiRenderer(configuration, this.rootConfig, (LinkerService)ConfigMockery.createJIRALinkerService(), null);
        this.highlighter = new WikiHighlighter((WikiRenderer)this.renderer);
    }

    @After
    public void tearDown() {
        AppConfig.resetConfig((RootConfig)this.oldConfig);
    }

    @Test
    public void testHighlightPlainText() throws Exception {
        Assert.assertEquals((String)"<p>test <span class=\"matched-text\">match</span> textb</p>", (String)this.highlighter.highlight("test match textb", "match", this.context, true));
        Assert.assertEquals((String)"<p>test <span class=\"matched-text\">&lt;match&gt;</span> textb</p>", (String)this.highlighter.highlight("test <match> textb", "<match>", this.context, true));
        Assert.assertEquals((String)"<p>test <span class=\"matched-text\">&lt;match</span> textb</p>", (String)this.highlighter.highlight("test <match textb", "<match", this.context, true));
        Assert.assertEquals((String)"<p>test <span class=\"matched-text\">match&gt;</span> textb</p>", (String)this.highlighter.highlight("test match> textb", "match>", this.context, true));
    }

    @Test
    public void testHighlightAndCaseSensitivity() throws Exception {
        Assert.assertEquals((String)"<p>test <span class=\"matched-text\">match</span> textb</p>", (String)this.highlighter.highlight("test match textb", "MATCH", this.context, true));
        Assert.assertEquals((String)"<p>test <span class=\"matched-text\">mATch</span> textb</p>", (String)this.highlighter.highlight("test mATch textb", "MATCH", this.context, true));
        Assert.assertEquals((String)"<p>test <span class=\"matched-text\">MATCH</span> textb</p>", (String)this.highlighter.highlight("test MATCH textb", "match", this.context, true));
        Assert.assertEquals((String)"<p>test <span class=\"matched-text\">MAtch</span> textb</p>", (String)this.highlighter.highlight("test MAtch textb", "maTCh", this.context, true));
    }

    @Test
    public void testHighlightWikiMarkup() throws Exception {
        Assert.assertEquals((String)"<p><tt>test</tt> <span class=\"matched-text\">match</span> textb</p>", (String)this.highlighter.highlight("{{test}} match textb", "match", this.context, true));
        Assert.assertEquals((String)"<p>test <span class=\"matched-text\">match</span> <tt>textb</tt></p>", (String)this.highlighter.highlight("test match {{textb}}", "match", this.context, true));
        Assert.assertEquals((String)"<p>test <tt><span class=\"matched-text\">match</span> textb</tt></p>", (String)this.highlighter.highlight("test {{match textb}}", "match", this.context, true));
        Assert.assertEquals((String)"<p><tt>test <span class=\"matched-text\">match</span></tt> textb</p>", (String)this.highlighter.highlight("{{test match}} textb", "match", this.context, true));
        Assert.assertEquals((String)"<p><tt>test <span class=\"matched-text\">match</span> textb</tt></p>", (String)this.highlighter.highlight("{{test match textb}}", "match", this.context, true));
        Assert.assertEquals((String)"<p>test <tt><span class=\"matched-text\">match</span></tt> textb</p>", (String)this.highlighter.highlight("test {{match}} textb", "match", this.context, true));
        Assert.assertEquals((String)"<p>test <tt><span class=\"matched-text\">&lt;match</span>b</tt> textb</p>", (String)this.highlighter.highlight("test {{<matchb}} textb", "<match", this.context, true));
    }

    @Test
    public void testHighlightLinks() throws Exception {
        RenderContext context = new RenderContext();
        String result = this.highlighter.highlight("[match|http://blah.com]", "match", context, true);
        Assert.assertTrue((String)("result does not appear to be a link: " + result), (boolean)result.contains("href=\"http://blah.com\""));
        Assert.assertTrue((String)("result does not have a match: " + result), (boolean)result.contains("<span class=\"matched-text\">match</span>"));
        String result2 = this.highlighter.highlight("[JIRA-123|http://jira/JIRA-123]", "jira", context, true);
        Assert.assertTrue((String)("result does not appear to be a link: " + result2), (boolean)result2.contains("href=\"http://jira/JIRA-123\""));
        Assert.assertTrue((String)("result: " + result2), (boolean)result2.toLowerCase().contains("<span class=\"matched-text\">jira</span>"));
    }

    @Test
    public void testHighlightTags() throws Exception {
        Assert.assertEquals((String)"<p>test &lt;<span class=\"matched-text\">match</span>&gt; text</p>", (String)this.highlighter.highlight("test <match> text", "matCH", this.context, true));
    }

    @Test
    public void testHighlightWithRepeatedMatch() throws Exception {
        Assert.assertEquals((String)"<p>test <span class=\"matched-text\">match</span> text &lt;<span class=\"matched-text\">match</span>&gt;</p>", (String)this.highlighter.highlight("test match text <match>", "match", this.context, true));
    }

    @Test
    public void testOutOfOrderMatches() throws Exception {
        Assert.assertEquals((String)"<p>test <span class=\"matched-text\">match1</span> <span class=\"matched-text\">match2</span> text</p>", (String)this.highlighter.highlight("test match1 match2 text", "match2 match1", this.context, false));
        Assert.assertEquals((String)"<p>test <span class=\"matched-text\">match1</span> match3 <span class=\"matched-text\">match2</span> text</p>", (String)this.highlighter.highlight("test match1 match3 match2 text", "match2 match1", this.context, false));
        Assert.assertEquals((String)"<p><span class=\"matched-text\">match1</span> <span class=\"matched-text\">match2</span> text</p>", (String)this.highlighter.highlight("match1 match2 text", "match2 match1", this.context, false));
    }

    @Test
    public void testOverlappingMatches() throws Exception {
        Assert.assertEquals((String)"<p>test <span class=\"matched-text\">matches</span> text</p>", (String)this.highlighter.highlight("test matches text", "match matches", this.context, false));
        Assert.assertEquals((String)"<p>test <span class=\"matched-text\">matches</span> text</p>", (String)this.highlighter.highlight("test matches text", "matches match", this.context, false));
        Assert.assertEquals((String)"<p>test <span class=\"matched-text\">match</span> <span class=\"matched-text\">matches</span> text</p>", (String)this.highlighter.highlight("test match matches text", "match matches", this.context, false));
        Assert.assertEquals((String)"<p>test <span class=\"matched-text\">matches</span> text</p>", (String)this.highlighter.highlight("test matches text", "atch matches", this.context, false));
        Assert.assertEquals((String)"<p>test <span class=\"matched-text\">matches</span> text</p>", (String)this.highlighter.highlight("test matches text", "matches atch", this.context, false));
        Assert.assertEquals((String)"<p>test <span class=\"matched-text\">matches</span> text</p>", (String)this.highlighter.highlight("test matches text", "match atches", this.context, false));
        Assert.assertEquals((String)"<p>test <span class=\"matched-text\">matches</span> text</p>", (String)this.highlighter.highlight("test matches text", "atches match", this.context, false));
        Assert.assertEquals((String)"<p>test <span class=\"matched-text\">matches</span> <span class=\"matched-text\">tch</span> text</p>", (String)this.highlighter.highlight("test matches tch text", "atches match tch", this.context, false));
        Assert.assertEquals((String)"<p>test <span class=\"matched-text\">matches</span> <span class=\"matched-text\">tch</span> text</p>", (String)this.highlighter.highlight("test matches tch text", "tch atches match", this.context, false));
        Assert.assertEquals((String)"<p>test <span class=\"matched-text\">matches</span> <span class=\"matched-text\">tch</span> text</p>", (String)this.highlighter.highlight("test matches tch text", "match tch atches", this.context, false));
        Assert.assertEquals((String)"<p>test <span class=\"matched-text\">matches</span> <span class=\"matched-text\">tch</span> text</p>", (String)this.highlighter.highlight("test matches tch text", "tch atches match", this.context, false));
    }

    @Test
    public void testHighlightNullText() throws Exception {
        Assert.assertNull((Object)this.highlighter.highlight(null, "match", this.context, true));
    }

    @Test(expected=NullPointerException.class)
    public void testHighlightNullQuery() throws Exception {
        Assert.assertNull((Object)this.highlighter.highlight("text", null, this.context, true));
    }

    @Test
    public void testHighlightNoMatch() throws Exception {
        Assert.assertEquals((String)"<p>test without no match</p>", (String)this.highlighter.highlight("test without no match", "pattern", this.context, false));
        Assert.assertNull((Object)this.highlighter.highlight("test without no match", "pattern", this.context, true));
    }
}

