/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.search.common.highlighting;

import com.atlassian.fecru.search.common.highlighting.SimpleHighlighter;
import org.junit.Assert;
import org.junit.Test;

public class SimpleHighlighterTest {
    private static final String[][] TESTS = new String[][]{{"myfile.txt", " ", "myfile.txt"}, {"myfile.txt", "file", "my<span class=\"matched-text\">file</span>.txt"}, {"myfile.txt", "my", "<span class=\"matched-text\">my</span>file.txt"}, {"myfile.txt", "i", "myf<span class=\"matched-text\">i</span>le.txt"}, {"MyFile.txt", "file", "My<span class=\"matched-text\">File</span>.txt"}, {"MyFile.txt", "File", "My<span class=\"matched-text\">File</span>.txt"}, {"MYFILE.txt", "file", "MY<span class=\"matched-text\">FILE</span>.txt"}, {"MYFILE.txt", "FILE", "MY<span class=\"matched-text\">FILE</span>.txt"}, {"myFILE.txt", "File", "my<span class=\"matched-text\">FILE</span>.txt"}, {"myFILE.txt", "FILE", "my<span class=\"matched-text\">FILE</span>.txt"}, {"MYfile.txt", "file", "MY<span class=\"matched-text\">file</span>.txt"}, {"myfile.txt has more than one match", "file one", "my<span class=\"matched-text\">file</span>.txt has more than <span class=\"matched-text\">one</span> match"}, {"myfile.txt has more than one match", "my match", "<span class=\"matched-text\">my</span>file.txt has more than one <span class=\"matched-text\">match</span>"}, {"myfile.txt has more than one match", "more than", "myfile.txt has <span class=\"matched-text\">more</span> <span class=\"matched-text\">than</span> one match"}, {"myfile.txt has more than one match", "file     one", "my<span class=\"matched-text\">file</span>.txt has more than <span class=\"matched-text\">one</span> match"}, {"myfile.txt has more than one match", "   my match ", "<span class=\"matched-text\">my</span>file.txt has more than one <span class=\"matched-text\">match</span>"}, {"myfile.txt has more than one match", "more  than  ", "myfile.txt has <span class=\"matched-text\">more</span> <span class=\"matched-text\">than</span> one match"}};
    private static final String[][] TESTS_CASE_INSENSITIVITY = new String[][]{{"MyFile.txt", "file", "My<span class=\"matched-text\">File</span>.txt"}, {"MyFile.txt", "File", "My<span class=\"matched-text\">File</span>.txt"}, {"MyFile.txt", "FILE", "My<span class=\"matched-text\">File</span>.txt"}, {"MYFilefile.txt", "file", "MYFile<span class=\"matched-text\">file</span>.txt"}, {"MyFilefile.txt", "File", "My<span class=\"matched-text\">File</span>file.txt"}, {"MyFilefile.txt", "FILE", "My<span class=\"matched-text\">File</span>file.txt"}};
    private static final String[][] TESTS_ANT_GLOBS = new String[][]{{"/src/test.txt", "*.txt", "/src/test.<span class=\"matched-text\">txt</span>"}, {"/src/test.txt", "**/*.txt", "/src/test.<span class=\"matched-text\">txt</span>"}, {"/src/test.txt", "/src/*.txt", "/<span class=\"matched-text\">src</span>/test.<span class=\"matched-text\">txt</span>"}, {"/src/test.txt", "/src/t?st.txt", "/<span class=\"matched-text\">src</span>/<span class=\"matched-text\">t</span>e<span class=\"matched-text\">st</span>.<span class=\"matched-text\">txt</span>"}, {"/src/test.txt", "/src/?e??.txt", "/<span class=\"matched-text\">src</span>/t<span class=\"matched-text\">e</span>st.<span class=\"matched-text\">txt</span>"}, {"/src/dir/dir2/test.txt", "/src/**/test.txt", "/<span class=\"matched-text\">src</span>/dir/dir2/<span class=\"matched-text\">test</span>.<span class=\"matched-text\">txt</span>"}, {"/src/dir/dir2/test.txt", "/**/dir/**/test.txt", "/src/<span class=\"matched-text\">dir</span>/dir2/<span class=\"matched-text\">test</span>.<span class=\"matched-text\">txt</span>"}, {"/src/dir/dir2/test.txt", "/*/dir/*/test.txt", "/src/<span class=\"matched-text\">dir</span>/dir2/<span class=\"matched-text\">test</span>.<span class=\"matched-text\">txt</span>"}, {"/src/dir/dir2/test.txt", "/*/dir/*/t?st.txt", "/src/<span class=\"matched-text\">dir</span>/dir2/<span class=\"matched-text\">t</span>e<span class=\"matched-text\">st</span>.<span class=\"matched-text\">txt</span>"}};
    private static final String[][] TESTS_WITH_XSS = new String[][]{{"<script>xss</script> attack", "xss", "&lt;script&gt;<span class=\"matched-text\">xss</span>&lt;/script&gt; attack"}, {"<script>xss</script> attack", "attack", "&lt;script&gt;xss&lt;/script&gt; <span class=\"matched-text\">attack</span>"}, {"<script>xss</script> attack", "<script>", "&lt;<span class=\"matched-text\">script</span>&gt;xss&lt;/script&gt; attack"}, {"/src/<script>xss</script>/attack.txt", "/src/*.txt", "/<span class=\"matched-text\">src</span>/&lt;script&gt;xss&lt;/script&gt;/attack.<span class=\"matched-text\">txt</span>"}, {"/src/<script>xss</script>/attack.txt", "/*/<script>xss</script>/*.txt", "/src/&lt;<span class=\"matched-text\">script</span>&gt;<span class=\"matched-text\">xss</span>&lt;/<span class=\"matched-text\">script</span>&gt;/attack.<span class=\"matched-text\">txt</span>"}, {"/src/<script>xss</script>/attack.txt", "/src/**/attack.txt", "/<span class=\"matched-text\">src</span>/&lt;script&gt;xss&lt;/script&gt;/<span class=\"matched-text\">attack</span>.<span class=\"matched-text\">txt</span>"}};

    @Test
    public void testHighlighter() throws Exception {
        this.assertHighlightings(TESTS);
    }

    @Test
    public void testHighlighterWithCaseInsensitivity() throws Exception {
        this.assertHighlightings(TESTS_CASE_INSENSITIVITY);
    }

    @Test
    public void testHighlighterWithAntGlobs() throws Exception {
        this.assertHighlightings(TESTS_ANT_GLOBS);
    }

    @Test
    public void testHighlighterWithXSS() throws Exception {
        this.assertHighlightings(TESTS_WITH_XSS);
    }

    private void assertHighlightings(String[][] data) {
        for (String[] testData : data) {
            String s = testData[0];
            String pattern = testData[1];
            String expected = testData[2];
            SimpleHighlighter highlighter = new SimpleHighlighter(pattern);
            Assert.assertEquals((String)("Invalid highlighting for pattern \"" + pattern + "\" on text \"" + s + '\"'), (Object)expected, (Object)highlighter.highlight(s));
        }
    }
}

