/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.search.common.api;

import com.atlassian.fecru.search.common.api.SearchScope;
import com.cenqua.fisheye.FisheyeTestUtil;
import com.cenqua.fisheye.rep.RepositoryHandle;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class SearchScopeTest {
    @Test(expected=IllegalArgumentException.class)
    public void testNegativeFrom() throws Exception {
        SearchScope.builder().withFrom(-1).build();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNegativeTo() throws Exception {
        SearchScope.builder().withTo(-1).build();
    }

    @Test(expected=IllegalStateException.class)
    public void testFromBeforeTo() throws Exception {
        SearchScope.builder().withFrom(10).withTo(5).build();
    }

    @Test
    public void testGetRepositoryForName() throws Exception {
        RepositoryHandle repAlpha = FisheyeTestUtil.mockRepoHandle("alpha");
        RepositoryHandle repOmega = FisheyeTestUtil.mockRepoHandle("omega");
        SearchScope searchScope = SearchScope.builder().withTo(45).withFrom(32).withRepositories(new RepositoryHandle[]{repAlpha, repOmega}).build();
        Assert.assertThat((String)"alpha repository found", (Object)searchScope.getRepositoryForName("alpha"), (Matcher)CoreMatchers.is((Object)repAlpha));
        Assert.assertThat((String)"omega repository found", (Object)searchScope.getRepositoryForName("omega"), (Matcher)CoreMatchers.is((Object)repOmega));
        Assert.assertThat((String)"other repository not found", (Object)searchScope.getRepositoryForName("delta"), (Matcher)CoreMatchers.nullValue());
    }
}

