/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.search.common;

import com.atlassian.fecru.search.common.SearchUtils;
import com.atlassian.fisheye.Visitor;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.ScmType;
import com.cenqua.fisheye.cache.RevisionCache;
import com.cenqua.fisheye.rep.RepositoryEngine;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class SearchUtilsTest {
    private final RepositoryEngine repositoryEngine = (RepositoryEngine)Mockito.mock(RepositoryEngine.class);
    private final RevisionCache revisionCache = (RevisionCache)Mockito.mock(RevisionCache.class);

    @Before
    public void setUp() throws Exception {
        Mockito.when((Object)this.repositoryEngine.getRevisionCache()).thenReturn((Object)this.revisionCache);
    }

    @Test
    public void testGetDisplayId() throws Exception {
        String csid = "12345678901234567890";
        Assert.assertEquals((Object)csid, (Object)SearchUtils.getDisplayId((ScmType)ScmType.CLEARCASE, (String)csid));
        Assert.assertEquals((Object)csid, (Object)SearchUtils.getDisplayId((ScmType)ScmType.CVS, (String)csid));
        Assert.assertEquals((Object)csid, (Object)SearchUtils.getDisplayId((ScmType)ScmType.SVN, (String)csid));
        Assert.assertEquals((Object)csid, (Object)SearchUtils.getDisplayId((ScmType)ScmType.P4, (String)csid));
        Assert.assertEquals((Object)"1234567", (Object)SearchUtils.getDisplayId((ScmType)ScmType.GIT, (String)csid));
        Assert.assertEquals((Object)"1234567", (Object)SearchUtils.getDisplayId((ScmType)ScmType.HG, (String)csid));
    }

    @Test
    public void testLoadRevisions() throws Exception {
        Path path = new Path((CharSequence)"/src/file.java");
        List<Integer> revList = Arrays.asList(10, 20, 30, 40, 50);
        List<Integer> visitedList = Arrays.asList(10, 20, 30);
        Mockito.when((Object)this.revisionCache.getHeadRevisions(path, true)).thenReturn(revList);
        SearchUtils.loadLatestRevisions((RepositoryEngine)this.repositoryEngine, (Path)path, new ArrayList(3), (int)3);
        ((RevisionCache)Mockito.verify((Object)this.revisionCache)).getHeadRevisions(path, true);
        ((RevisionCache)Mockito.verify((Object)this.revisionCache)).visitRevisions((Iterable)Mockito.eq(visitedList), (Visitor)Mockito.isA(Visitor.class));
    }

    @Test
    public void testLoadRevisionsLowRevisionCount() throws Exception {
        Path path = new Path((CharSequence)"/src/file.java");
        List<Integer> revList = Arrays.asList(10, 20);
        Mockito.when((Object)this.revisionCache.getHeadRevisions(path, true)).thenReturn(revList);
        SearchUtils.loadLatestRevisions((RepositoryEngine)this.repositoryEngine, (Path)path, new ArrayList(3), (int)3);
        ((RevisionCache)Mockito.verify((Object)this.revisionCache)).getHeadRevisions(path, true);
        ((RevisionCache)Mockito.verify((Object)this.revisionCache)).visitRevisions((Iterable)Mockito.eq(revList), (Visitor)Mockito.isA(Visitor.class));
    }

    @Test
    public void testLoadRevisionsWithPhysicalPath() throws Exception {
        Path path = new Path((CharSequence)"/src/file.java");
        Mockito.when((Object)this.revisionCache.getRepositoryType()).thenReturn((Object)ScmType.CVS);
        List revIds = Collections.emptyList();
        Mockito.when((Object)this.revisionCache.getHeadRevisions(path, true)).thenReturn(revIds);
        SearchUtils.loadLatestRevisions((RepositoryEngine)this.repositoryEngine, (Path)path, new ArrayList(3), (int)3);
        ((RevisionCache)Mockito.verify((Object)this.revisionCache)).getHeadRevisions(path, true);
        ((RevisionCache)Mockito.verify((Object)this.revisionCache)).visitRevisions((Iterable)Mockito.eq(revIds), (Visitor)Mockito.isA(Visitor.class));
    }

    @Test
    public void testLoadRevisionsWithSVNPhysicalPath() throws Exception {
        Path path = new Path((CharSequence)"/src/file.java");
        List<Integer> revList = Arrays.asList(10, 20, 30, 40, 50);
        List<Integer> visitedList = Arrays.asList(10, 20, 30);
        Mockito.when((Object)this.revisionCache.getRepositoryType()).thenReturn((Object)ScmType.SVN);
        Mockito.when((Object)this.revisionCache.getHeadRevisions(path, true)).thenReturn(Collections.emptyList());
        Mockito.when((Object)this.revisionCache.getHeadRevisions(path, false)).thenReturn(revList);
        SearchUtils.loadLatestRevisions((RepositoryEngine)this.repositoryEngine, (Path)path, new ArrayList(3), (int)3);
        ((RevisionCache)Mockito.verify((Object)this.revisionCache)).getHeadRevisions(path, true);
        ((RevisionCache)Mockito.verify((Object)this.revisionCache)).visitRevisions((Iterable)Mockito.eq(visitedList), (Visitor)Mockito.isA(Visitor.class));
    }
}

