/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.search.changesets;

import com.atlassian.fecru.search.changesets.ChangesetResult;
import com.atlassian.fecru.search.changesets.CommitMessageSearcher;
import com.atlassian.fecru.search.common.api.QuickSearchTimeBucket;
import com.atlassian.fecru.search.common.api.SearchResults;
import com.atlassian.fecru.search.common.api.SearchScope;
import com.atlassian.fecru.search.common.api.SearchType;
import com.atlassian.fecru.search.index.model.DocInfo;
import com.atlassian.fecru.search.index.service.TestDocInfoManager;
import com.atlassian.fecru.user.FecruUser;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.ScmType;
import com.cenqua.fisheye.config.RepositoryManager;
import com.cenqua.fisheye.crossrepo.ChangesetDoc;
import com.cenqua.fisheye.crossrepo.ChangesetDocInfo;
import com.cenqua.fisheye.lucene.CrossRepLuceneIndexes;
import com.cenqua.fisheye.lucene.FreeTextAnalyzer;
import com.cenqua.fisheye.lucene.writer.DefaultIndexWriterFactory;
import com.cenqua.fisheye.model.manager.CommitterUserMappingManager;
import com.cenqua.fisheye.rep.ChangeSet;
import com.cenqua.fisheye.rep.DummyChangeSet;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.user.UserManager;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.util.Collections;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.RAMDirectory;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.joda.time.DateTime;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;

public class CommitMessageSearcherTest {
    private CommitMessageSearcher searcher;
    private TestDocInfoManager<ChangesetDocInfo> manager;
    private final Directory directory = new RAMDirectory();
    private RepositoryHandle repository = (RepositoryHandle)Mockito.mock(RepositoryHandle.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
    private RepositoryHandle repository2 = (RepositoryHandle)Mockito.mock(RepositoryHandle.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
    private UserManager userManager = (UserManager)Mockito.mock(UserManager.class);
    private CommitterUserMappingManager commiterManager = (CommitterUserMappingManager)Mockito.mock(CommitterUserMappingManager.class);
    private RepositoryManager repositoryManager = (RepositoryManager)Mockito.mock(RepositoryManager.class);

    private static ChangesetDocInfo makeDoc(final int id, final String author, final String commitMessage, final DateTime date, final String repo) {
        DummyChangeSet cs = new DummyChangeSet(){

            public String getId() {
                return String.valueOf(id);
            }

            public String getAuthor() {
                return author;
            }

            public String getComment() {
                return commitMessage;
            }

            public long getDate() {
                return date.getMillis();
            }

            public Iterable<Path> getPaths() {
                return Collections.emptyList();
            }

            public String getRepName() {
                return repo;
            }
        };
        return new ChangesetDocInfo(ChangesetDoc.fromChangeSet((ChangeSet)cs), false);
    }

    @Before
    public void setUp() throws Exception {
        IndexWriter writer = new DefaultIndexWriterFactory().create(this.directory, (Analyzer)new FreeTextAnalyzer(), true);
        IndexReader reader = IndexReader.open((IndexWriter)writer, (boolean)true);
        this.manager = new TestDocInfoManager(writer, reader);
        this.mockRepository(this.repository, "repo");
        this.mockRepository(this.repository2, "repo2");
        ImmutableMap handleMap = ImmutableMap.of((Object)this.repository.getName(), (Object)this.repository, (Object)this.repository2.getName(), (Object)this.repository2);
        Mockito.when((Object)this.repositoryManager.getHandleMap()).thenReturn((Object)handleMap);
        this.searcher = new CommitMessageSearcher(null, null, null, null, this.repositoryManager, this.commiterManager, this.userManager){

            protected IndexReader getIndexReader() {
                try {
                    return IndexReader.open((Directory)CommitMessageSearcherTest.this.directory);
                }
                catch (IOException e) {
                    Assert.fail((String)e.getMessage());
                    return null;
                }
            }
        };
    }

    private void mockRepository(RepositoryHandle repository, String name) {
        Mockito.when((Object)repository.getName()).thenReturn((Object)name);
        Mockito.when((Object)repository.getCfg().getRepositoryType()).thenReturn((Object)ScmType.SVN);
    }

    @Test
    public void testProperties() throws Exception {
        junit.framework.Assert.assertEquals((Object)SearchType.CHANGESET_COMMENTS, (Object)this.searcher.getType());
        junit.framework.Assert.assertEquals((Object)CrossRepLuceneIndexes.METADATA, (Object)this.searcher.getIndex());
    }

    @Test
    public void testTimeBuckets() throws Exception {
        DateTime now = new DateTime();
        String repo = this.repository.getName();
        this.manager.addDoc((DocInfo)CommitMessageSearcherTest.makeDoc(1, "author1", "test", now, repo));
        this.manager.addDoc((DocInfo)CommitMessageSearcherTest.makeDoc(2, "author2", "test", now.minusHours(12), repo));
        this.manager.addDoc((DocInfo)CommitMessageSearcherTest.makeDoc(3, "author3", "test", now.minusDays(3), repo));
        this.manager.addDoc((DocInfo)CommitMessageSearcherTest.makeDoc(4, "author4", "test", now.minusDays(15), repo));
        this.manager.addDoc((DocInfo)CommitMessageSearcherTest.makeDoc(5, "author5", "test", now.minusMonths(6), repo));
        this.manager.addDoc((DocInfo)CommitMessageSearcherTest.makeDoc(6, "author6", "test", now.minusYears(2), repo));
        this.manager.commit();
        SearchResults anyDate = this.searcher.search("test", SearchScope.builder().withRepositories(new RepositoryHandle[]{this.repository}).withTimeBucket(QuickSearchTimeBucket.ANY_DATE).build());
        SearchResults lastDay = this.searcher.search("test", SearchScope.builder().withRepositories(new RepositoryHandle[]{this.repository}).withTimeBucket(QuickSearchTimeBucket.YESTERDAY).build());
        SearchResults lastWeek = this.searcher.search("test", SearchScope.builder().withRepositories(new RepositoryHandle[]{this.repository}).withTimeBucket(QuickSearchTimeBucket.LAST_WEEK).build());
        SearchResults lastMonth = this.searcher.search("test", SearchScope.builder().withRepositories(new RepositoryHandle[]{this.repository}).withTimeBucket(QuickSearchTimeBucket.LAST_MONTH).build());
        SearchResults lastYear = this.searcher.search("test", SearchScope.builder().withRepositories(new RepositoryHandle[]{this.repository}).withTimeBucket(QuickSearchTimeBucket.LAST_YEAR).build());
        Assert.assertThat((Object)anyDate.getTotalCount(), (Matcher)Matchers.equalTo((Object)6));
        Assert.assertThat((Object)lastYear.getTotalCount(), (Matcher)Matchers.equalTo((Object)5));
        Assert.assertThat((Object)lastMonth.getTotalCount(), (Matcher)Matchers.equalTo((Object)4));
        Assert.assertThat((Object)lastWeek.getTotalCount(), (Matcher)Matchers.equalTo((Object)3));
        Assert.assertThat((Object)lastDay.getTotalCount(), (Matcher)Matchers.equalTo((Object)2));
    }

    @Test
    public void testUserFilter() throws Exception {
        FecruUser user = new FecruUser("user1");
        this.manager.addDoc((DocInfo)CommitMessageSearcherTest.makeDoc(1, "committer1", "test", new DateTime(), this.repository.getName()));
        this.manager.addDoc((DocInfo)CommitMessageSearcherTest.makeDoc(2, "committer2", "test", new DateTime(), this.repository.getName()));
        this.manager.addDoc((DocInfo)CommitMessageSearcherTest.makeDoc(3, "committer3", "test", new DateTime(), this.repository.getName()));
        this.manager.addDoc((DocInfo)CommitMessageSearcherTest.makeDoc(4, "committer1", "test", new DateTime(), this.repository.getName()));
        this.manager.commit();
        Mockito.when((Object)this.userManager.getLicensedUser(user.getUsername())).thenReturn((Object)user);
        Mockito.when((Object)this.commiterManager.getAllCommittersForUserInRep(this.repository.getName(), user.getUsername())).thenReturn((Object)ImmutableList.of((Object)"committer1", (Object)"committer2"));
        SearchResults userChangesets = this.searcher.search("test", SearchScope.builder().withRepositories(new RepositoryHandle[]{this.repository}).withUser(user.getUsername()).build());
        Assert.assertThat((Object)ImmutableList.copyOf((Iterable)userChangesets), (Matcher)Matchers.hasSize((int)3));
        Assert.assertThat((Object)Iterables.transform((Iterable)userChangesets, ChangesetResult::getCsid), (Matcher)Matchers.hasItems((Object[])new String[]{"2", "1", "4"}));
    }

    @Test
    public void testUserFilter_multipleReps_differentMappings() throws Exception {
        FecruUser user = new FecruUser("user");
        this.manager.addDoc((DocInfo)CommitMessageSearcherTest.makeDoc(1, "committer1", "test", new DateTime(), this.repository.getName()));
        this.manager.addDoc((DocInfo)CommitMessageSearcherTest.makeDoc(2, "committer2", "test", new DateTime(), this.repository.getName()));
        this.manager.addDoc((DocInfo)CommitMessageSearcherTest.makeDoc(3, "committer1", "test", new DateTime(), this.repository2.getName()));
        this.manager.addDoc((DocInfo)CommitMessageSearcherTest.makeDoc(4, "committer2", "test", new DateTime(), this.repository2.getName()));
        this.manager.commit();
        Mockito.when((Object)this.userManager.getLicensedUser(user.getUsername())).thenReturn((Object)user);
        ImmutableMultimap mappings = ImmutableMultimap.of((Object)this.repository.getName(), (Object)"committer1", (Object)this.repository2.getName(), (Object)"committer2");
        Mockito.when((Object)this.commiterManager.getAllCommittersForUser(user.getUsername())).thenReturn((Object)mappings);
        SearchResults userChangesets = this.searcher.search("test", SearchScope.builder().withRepositories(new RepositoryHandle[]{this.repository, this.repository2}).withUser(user.getUsername()).build());
        Assert.assertThat((Object)ImmutableList.copyOf((Iterable)userChangesets), (Matcher)Matchers.hasSize((int)2));
        Assert.assertThat((Object)Iterables.transform((Iterable)userChangesets, ChangesetResult::getCsid), (Matcher)Matchers.hasItems((Object[])new String[]{"1", "4"}));
    }

    @Test
    public void testUserFilter_noMappings() throws Exception {
        FecruUser user = new FecruUser("user");
        this.manager.addDoc((DocInfo)CommitMessageSearcherTest.makeDoc(1, "committer1", "test", new DateTime(), this.repository.getName()));
        this.manager.commit();
        Mockito.when((Object)this.userManager.getLicensedUser(user.getUsername())).thenReturn((Object)user);
        Mockito.when((Object)this.commiterManager.getAllCommittersForUserInRep(this.repository.getName(), user.getUsername())).thenReturn(Collections.emptyList());
        SearchResults userChangesets = this.searcher.search("test", SearchScope.builder().withRepositories(new RepositoryHandle[]{this.repository}).withUser(user.getUsername()).build());
        Assert.assertThat((Object)ImmutableList.copyOf((Iterable)userChangesets), (Matcher)Matchers.hasSize((int)0));
    }

    @Test
    public void testEmptySearch() throws Exception {
        this.manager.addDoc((DocInfo)CommitMessageSearcherTest.makeDoc(1, "no_author", "", new DateTime(), this.repository.getName()));
        this.manager.commit();
        SearchResults results = this.searcher.search("", SearchScope.builder().withRepositories(new RepositoryHandle[]{this.repository}).build());
        Assert.assertThat((Object)results.getTotalCount(), (Matcher)Matchers.equalTo((Object)1));
    }
}

