/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.search;

import com.cenqua.fisheye.lucene.LuceneConnection;
import com.cenqua.fisheye.lucene.writer.DefaultIndexWriterFactory;
import java.io.Closeable;
import java.io.IOException;
import junit.framework.Assert;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.WhitespaceAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.Directory;

public class LuceneTestUtils {
    public static void writeDocuments(Directory directory, String[][] documentData, boolean store, boolean analyse, boolean termVector) throws IOException {
        IndexWriter writer = new DefaultIndexWriterFactory().create(directory, (Analyzer)new WhitespaceAnalyzer(LuceneConnection.VERSION), true);
        for (String[] fieldData : documentData) {
            Assert.assertEquals((int)2, (int)fieldData.length);
            Document document = new Document();
            Field.Store stored = store ? Field.Store.YES : Field.Store.NO;
            Field.Index indexed = analyse ? Field.Index.ANALYZED_NO_NORMS : Field.Index.NOT_ANALYZED_NO_NORMS;
            Field.TermVector vector = termVector ? Field.TermVector.WITH_POSITIONS_OFFSETS : Field.TermVector.NO;
            Field field = new Field(fieldData[0], fieldData[1], stored, indexed, vector);
            document.add((Fieldable)field);
            writer.addDocument(document);
        }
        writer.close();
    }

    public static void close(Closeable ... closeables) {
        if (closeables != null && closeables.length > 0) {
            for (Closeable closeable : closeables) {
                if (closeable == null) continue;
                try {
                    closeable.close();
                }
                catch (IOException | AlreadyClosedException throwable) {
                    // empty catch block
                }
            }
        }
    }
}

