/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.review.store;

import com.atlassian.crucible.spi.data.ReviewData;
import com.atlassian.fecru.review.store.data.CoreReviewData;
import com.atlassian.fecru.user.FecruUser;
import com.cenqua.crucible.model.PermaIdKey;
import com.cenqua.crucible.model.Project;
import com.cenqua.crucible.model.Review;
import com.google.common.collect.ImmutableList;
import java.util.Date;
import java.util.Random;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import net.sf.ehcache.store.chm.ConcurrentHashMap;

public class ReviewDataGenerators {
    private static final Random rnd = new Random();
    private static final ConcurrentMap<String, AtomicInteger> sequenceGenerator = new ConcurrentHashMap();

    public static PermaIdKey generatePermaIdKey(Project project) {
        return new PermaIdKey(project.getProjKey(), rnd.nextInt(999999999));
    }

    public static CoreReviewData generateCoreReviewData(Project project, FecruUser creator, Review parentReview) {
        PermaIdKey currentPermaIdKey = ReviewDataGenerators.generatePermaIdKey(project);
        return new CoreReviewData.Builder().id(Integer.valueOf(ReviewDataGenerators.genId(project.getProjKey()))).permId(currentPermaIdKey.toString()).projectKey(project).defaultSource("source_" + rnd.nextInt(Integer.MAX_VALUE)).type(ReviewData.ReviewType.REVIEW).permaIdHistory(ImmutableList.of((Object)currentPermaIdKey.toString())).name("name_" + rnd.nextInt(Integer.MAX_VALUE)).summary("summary_" + rnd.nextInt(Integer.MAX_VALUE)).description("description_" + rnd.nextInt(Integer.MAX_VALUE)).stateName("Review").creatorName(creator.getUsername()).createDate(new Date()).reminderDate(new Date()).dueDate(new Date()).parentReviewPermId(parentReview).metricsVersion(Integer.valueOf(rnd.nextInt(100))).jiraIssueKey("jira-" + rnd.nextInt(Integer.MAX_VALUE)).allowReviewerToJoin(Boolean.valueOf(rnd.nextBoolean())).build();
    }

    private static int genId(String key) {
        sequenceGenerator.putIfAbsent(key, new AtomicInteger(0));
        return ((AtomicInteger)sequenceGenerator.get(key)).incrementAndGet();
    }
}

