/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.review.store;

import com.atlassian.crucible.spi.TxCallback;
import com.atlassian.fecru.page.Page;
import com.atlassian.fecru.page.PageRequest;
import com.atlassian.fecru.review.store.DefaultReviewDataManager;
import com.atlassian.fecru.review.store.ReviewDataGenerators;
import com.atlassian.fecru.review.store.ReviewDataManager;
import com.atlassian.fecru.review.store.data.CoreReviewData;
import com.atlassian.fecru.user.FecruUser;
import com.atlassian.fecru.user.FecruUserDAO;
import com.atlassian.fisheye.spi.TxTemplate;
import com.cenqua.crucible.model.PermissionScheme;
import com.cenqua.crucible.model.Project;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.ReviewPermaId;
import com.cenqua.crucible.model.dao.Generators;
import com.cenqua.crucible.model.dao.PermissionSchemeDAO;
import com.cenqua.crucible.model.dao.ProjectDAO;
import com.cenqua.crucible.model.dao.ReviewDAO;
import com.cenqua.crucible.model.dao.ReviewPermaIdDAO;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.IsInstanceOf;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.aop.framework.Advised;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.transaction.TransactionStatus;
import org.unitils.reflectionassert.ReflectionAssert;
import org.unitils.reflectionassert.ReflectionComparatorMode;

@ContextConfiguration(value={"classpath:/tests-db-spring-context-level3-manager.xml"})
@DirtiesContext(classMode=DirtiesContext.ClassMode.AFTER_EACH_TEST_METHOD)
@RunWith(value=SpringJUnit4ClassRunner.class)
public class DefaultReviewDataManagerTest {
    @Autowired
    PermissionSchemeDAO permissionSchemeDAO;
    @Autowired
    ProjectDAO projectDAO;
    @Autowired
    ReviewDAO reviewDAO;
    @Autowired
    ReviewPermaIdDAO reviewPermaIdDAO;
    @Autowired
    FecruUserDAO userDAO;
    @Autowired
    TxTemplate txTemplate;
    @Autowired
    ReviewDataManager reviewDataManager;
    PermissionScheme permissionScheme;
    Project project1;
    Project project2;
    FecruUser user1;
    FecruUser user2;
    Review review1;

    @Before
    public void setUp() {
        this.txTemplate.execute((TxCallback)new TxCallback<Void>(){

            public Void doInTransaction(TransactionStatus status) throws Exception {
                DefaultReviewDataManagerTest.this.permissionScheme = Generators.generatePermissionScheme();
                DefaultReviewDataManagerTest.this.permissionSchemeDAO.add(DefaultReviewDataManagerTest.this.permissionScheme);
                DefaultReviewDataManagerTest.this.project1 = Generators.generateProject(DefaultReviewDataManagerTest.this.permissionScheme, "PROJA");
                DefaultReviewDataManagerTest.this.projectDAO.add(DefaultReviewDataManagerTest.this.project1);
                DefaultReviewDataManagerTest.this.project2 = Generators.generateProject(DefaultReviewDataManagerTest.this.permissionScheme, "PROJB");
                DefaultReviewDataManagerTest.this.projectDAO.add(DefaultReviewDataManagerTest.this.project2);
                DefaultReviewDataManagerTest.this.user1 = Generators.generateUser();
                DefaultReviewDataManagerTest.this.userDAO.create(DefaultReviewDataManagerTest.this.user1);
                DefaultReviewDataManagerTest.this.user2 = Generators.generateUser();
                DefaultReviewDataManagerTest.this.userDAO.create(DefaultReviewDataManagerTest.this.user2);
                DefaultReviewDataManagerTest.this.review1 = Generators.generateReview(DefaultReviewDataManagerTest.this.project2, DefaultReviewDataManagerTest.this.user2);
                DefaultReviewDataManagerTest.this.reviewDAO.add(DefaultReviewDataManagerTest.this.review1);
                DefaultReviewDataManagerTest.this.review1.getPermaIdHistory().add(new ReviewPermaId(DefaultReviewDataManagerTest.this.review1, "ELO", 1));
                return null;
            }
        });
    }

    @Test
    public void testIsThisTestingWhatItShould() throws Exception {
        MatcherAssert.assertThat((Object)AopUtils.isAopProxy((Object)this.reviewDataManager), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)((Advised)this.reviewDataManager).getTargetSource().getTarget(), (Matcher)IsInstanceOf.instanceOf(DefaultReviewDataManager.class));
    }

    @Test
    public void testAddAndListOneCoreReviewData() throws Exception {
        CoreReviewData coreReviewDataCreated = ReviewDataGenerators.generateCoreReviewData(this.project1, this.user1, this.review1);
        this.reviewDataManager.createReviewFrom(coreReviewDataCreated);
        Page pageOfCoreReviewData = this.reviewDataManager.getCoreReviewDataPageForProject(this.project1.getProjKey(), PageRequest.createDefault());
        MatcherAssert.assertThat((Object)pageOfCoreReviewData.getSize(), (Matcher)Matchers.is((Object)1));
        CoreReviewData coreReviewDataRead = (CoreReviewData)pageOfCoreReviewData.getValues().iterator().next();
        MatcherAssert.assertThat((Object)coreReviewDataCreated, (Matcher)Matchers.not((Matcher)Matchers.sameInstance((Object)coreReviewDataRead)));
        MatcherAssert.assertThat((Object)coreReviewDataCreated.id, (Matcher)Matchers.not((Matcher)Matchers.nullValue()));
        CoreReviewData coreReviewDataCreatedNoId = new CoreReviewData.Builder().copy(coreReviewDataCreated).id(null).build();
        CoreReviewData coreReviewDataReadNoId = new CoreReviewData.Builder().copy(coreReviewDataRead).id(null).build();
        ReflectionAssert.assertReflectionEquals((Object)coreReviewDataCreatedNoId, (Object)coreReviewDataReadNoId, (ReflectionComparatorMode[])new ReflectionComparatorMode[0]);
    }

    @Test
    public void testAddManyAndPage() throws Exception {
        ArrayList coreReviewDataCreatedList = Lists.newArrayList();
        for (int i = 0; i < 200; ++i) {
            CoreReviewData coreReviewDataCreated = ReviewDataGenerators.generateCoreReviewData(this.project1, this.user1, this.review1);
            this.reviewDataManager.createReviewFrom(coreReviewDataCreated);
            coreReviewDataCreatedList.add(coreReviewDataCreated);
        }
        Page page20To70 = this.reviewDataManager.getCoreReviewDataPageForProject(this.project1.getProjKey(), PageRequest.create((Integer)20, (Integer)70));
        int i = 20;
        for (CoreReviewData coreReviewDataRead : page20To70.getValues()) {
            CoreReviewData coreReviewDataCreatedNoId = new CoreReviewData.Builder().copy((CoreReviewData)coreReviewDataCreatedList.get(i++)).id(null).build();
            CoreReviewData coreReviewDataReadNoId = new CoreReviewData.Builder().copy(coreReviewDataRead).id(null).build();
            ReflectionAssert.assertReflectionEquals((Object)coreReviewDataCreatedNoId, (Object)coreReviewDataReadNoId, (ReflectionComparatorMode[])new ReflectionComparatorMode[0]);
        }
    }

    @Test
    public void testAddManyAndIterate() throws Exception {
        ArrayList coreReviewDataCreatedList = Lists.newArrayList();
        for (int i = 0; i < 200; ++i) {
            CoreReviewData coreReviewDataCreated = ReviewDataGenerators.generateCoreReviewData(this.project1, this.user1, this.review1);
            this.reviewDataManager.createReviewFrom(coreReviewDataCreated);
            coreReviewDataCreatedList.add(coreReviewDataCreated);
        }
        Iterable all = this.reviewDataManager.getCoreReviewDataIterableForProject(this.project1.getProjKey(), PageRequest.create((Integer)0, (Integer)30));
        int i = 0;
        for (CoreReviewData coreReviewDataRead : all) {
            CoreReviewData coreReviewDataCreatedNoId = new CoreReviewData.Builder().copy((CoreReviewData)coreReviewDataCreatedList.get(i++)).id(null).build();
            CoreReviewData coreReviewDataReadNoId = new CoreReviewData.Builder().copy(coreReviewDataRead).id(null).build();
            ReflectionAssert.assertReflectionEquals((Object)coreReviewDataCreatedNoId, (Object)coreReviewDataReadNoId, (ReflectionComparatorMode[])new ReflectionComparatorMode[0]);
        }
    }

    @Test
    public void testAddBulk() throws Exception {
        ArrayList coreReviewDataCreatedList = Lists.newArrayList();
        for (int i = 0; i < 200; ++i) {
            CoreReviewData coreReviewDataCreated = ReviewDataGenerators.generateCoreReviewData(this.project1, this.user1, this.review1);
            coreReviewDataCreatedList.add(coreReviewDataCreated);
        }
        this.reviewDataManager.createReviewsFrom((Iterable)coreReviewDataCreatedList);
        Page page0To200 = this.reviewDataManager.getCoreReviewDataPageForProject(this.project1.getProjKey(), PageRequest.create((Integer)0, (Integer)200));
        int i = 0;
        for (CoreReviewData coreReviewDataRead : page0To200.getValues()) {
            CoreReviewData coreReviewDataCreatedNoId = new CoreReviewData.Builder().copy((CoreReviewData)coreReviewDataCreatedList.get(i++)).id(null).build();
            CoreReviewData coreReviewDataReadNoId = new CoreReviewData.Builder().copy(coreReviewDataRead).id(null).build();
            ReflectionAssert.assertReflectionEquals((Object)coreReviewDataCreatedNoId, (Object)coreReviewDataReadNoId, (ReflectionComparatorMode[])new ReflectionComparatorMode[0]);
        }
    }

    @Test
    public void testAddOnlyPermaIdSetHistoryNull() throws Exception {
        CoreReviewData coreReviewDataCreated = new CoreReviewData.Builder().copy(ReviewDataGenerators.generateCoreReviewData(this.project1, this.user1, this.review1)).permaIdHistory(null).build();
        MatcherAssert.assertThat((Object)coreReviewDataCreated.permId, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)coreReviewDataCreated.permaIdHistory, (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        this.reviewDataManager.createReviewFrom(coreReviewDataCreated);
        CoreReviewData coreReviewDataRead = (CoreReviewData)this.reviewDataManager.getCoreReviewDataPageForProject(this.project1.getProjKey(), PageRequest.createDefault()).getValues().iterator().next();
        MatcherAssert.assertThat((Object)coreReviewDataRead.permId, (Matcher)Matchers.is((Object)coreReviewDataCreated.permId));
        MatcherAssert.assertThat((Object)coreReviewDataRead.permaIdHistory, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)coreReviewDataRead.permaIdHistory.get(0), (Matcher)Matchers.is((Object)coreReviewDataCreated.permId));
    }

    @Test
    public void testAddOnlyHistorySetPermaIdNull() throws Exception {
        CoreReviewData coreReviewDataCreated = new CoreReviewData.Builder().copy(ReviewDataGenerators.generateCoreReviewData(this.project1, this.user1, this.review1)).permId(null).build();
        MatcherAssert.assertThat((Object)coreReviewDataCreated.permId, (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        MatcherAssert.assertThat((Object)coreReviewDataCreated.permaIdHistory, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        this.reviewDataManager.createReviewFrom(coreReviewDataCreated);
        CoreReviewData coreReviewDataRead = (CoreReviewData)this.reviewDataManager.getCoreReviewDataPageForProject(this.project1.getProjKey(), PageRequest.createDefault()).getValues().iterator().next();
        MatcherAssert.assertThat((Object)coreReviewDataRead.permId, (Matcher)Matchers.is((Object)coreReviewDataCreated.permaIdHistory.get(0)));
        MatcherAssert.assertThat((Object)coreReviewDataRead.permaIdHistory.get(0), (Matcher)Matchers.is((Object)coreReviewDataCreated.permaIdHistory.get(0)));
    }

    @Test
    public void testAddBothSetButHistoryWithNoCurrent() throws Exception {
        CoreReviewData coreReviewDataCreated = new CoreReviewData.Builder().copy(ReviewDataGenerators.generateCoreReviewData(this.project1, this.user1, this.review1)).permaIdHistory(ImmutableList.of((Object)ReviewDataGenerators.generatePermaIdKey(this.project2).toString())).permId(ReviewDataGenerators.generatePermaIdKey(this.project1).toString()).build();
        MatcherAssert.assertThat((Object)coreReviewDataCreated.permId, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)coreReviewDataCreated.permaIdHistory, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)coreReviewDataCreated.permId, (Matcher)Matchers.is((Matcher)Matchers.not((Object)coreReviewDataCreated.permaIdHistory.get(0))));
        this.reviewDataManager.createReviewFrom(coreReviewDataCreated);
        CoreReviewData coreReviewDataRead = (CoreReviewData)this.reviewDataManager.getCoreReviewDataPageForProject(this.project1.getProjKey(), PageRequest.createDefault()).getValues().iterator().next();
        MatcherAssert.assertThat((Object)coreReviewDataRead.permId, (Matcher)Matchers.is((Object)coreReviewDataCreated.permId));
        MatcherAssert.assertThat((Object)coreReviewDataRead.permaIdHistory, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{coreReviewDataCreated.permId, (String)coreReviewDataCreated.permaIdHistory.get(0)}));
    }
}

