/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.review;

import com.atlassian.fecru.review.ReviewLockManager;
import com.atlassian.fecru.review.StripedLockReviewLockManager;
import com.atlassian.fugue.Pair;
import com.cenqua.crucible.model.Review;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.mutable.MutableBoolean;
import org.junit.Assert;
import org.junit.Test;

public class StripedLockReviewLockManagerTest {
    @Test
    public void testLockingTimesOut() throws InterruptedException {
        MutableBoolean gotException = new MutableBoolean();
        StripedLockReviewLockManager reviewLockManager = new StripedLockReviewLockManager(){

            protected Pair<Integer, TimeUnit> getTimeout() {
                return Pair.pair((Object)100, (Object)((Object)TimeUnit.MILLISECONDS));
            }
        };
        Thread t = new Thread((ReviewLockManager)reviewLockManager, gotException){
            final /* synthetic */ ReviewLockManager val$reviewLockManager;
            final /* synthetic */ MutableBoolean val$gotException;
            {
                this.val$reviewLockManager = reviewLockManager;
                this.val$gotException = mutableBoolean;
            }

            @Override
            public void run() {
                try {
                    this.val$reviewLockManager.withReviewLock(StripedLockReviewLockManagerTest.this.makeReview(1), () -> null);
                    Assert.fail((String)"Expected timeout");
                }
                catch (Exception e) {
                    Assert.assertEquals((String)"Exception message", (Object)"Timed out waiting to lock Review 1", (Object)e.getMessage());
                    this.val$gotException.setValue(true);
                }
            }
        };
        reviewLockManager.withReviewLock(this.makeReview(1), () -> {
            t.start();
            try {
                t.join(10000L);
                Assert.assertTrue((String)"Thread should stop", (!t.isAlive() ? 1 : 0) != 0);
            }
            catch (InterruptedException e) {
                Assert.fail((String)"Unexpected exception");
            }
            return null;
        });
        Assert.assertTrue((boolean)gotException.booleanValue());
    }

    @Test
    public void testLockingDifferentReviewsUseDifferentLocks() {
        MutableBoolean ran = new MutableBoolean();
        StripedLockReviewLockManager reviewLockManager = new StripedLockReviewLockManager(){

            protected Pair<Integer, TimeUnit> getTimeout() {
                return Pair.pair((Object)100, (Object)((Object)TimeUnit.MILLISECONDS));
            }
        };
        Thread t = new Thread((ReviewLockManager)reviewLockManager, ran){
            final /* synthetic */ ReviewLockManager val$reviewLockManager;
            final /* synthetic */ MutableBoolean val$ran;
            {
                this.val$reviewLockManager = reviewLockManager;
                this.val$ran = mutableBoolean;
            }

            @Override
            public void run() {
                try {
                    this.val$reviewLockManager.withReviewLock(StripedLockReviewLockManagerTest.this.makeReview(2), () -> {
                        this.val$ran.setValue(true);
                        return null;
                    });
                }
                catch (Exception e) {
                    Assert.fail((String)("Unexpected Exception " + e.getMessage()));
                }
            }
        };
        reviewLockManager.withReviewLock(this.makeReview(1), () -> {
            t.start();
            try {
                t.join(10000L);
                Assert.assertTrue((String)"Thread should stop", (!t.isAlive() ? 1 : 0) != 0);
            }
            catch (InterruptedException e) {
                Assert.fail((String)("Unexpected exception " + e.getMessage()));
            }
            return null;
        });
        Assert.assertTrue((boolean)ran.booleanValue());
    }

    private Review makeReview(int id) {
        Review r = new Review();
        r.setId(Integer.valueOf(id));
        return r;
    }
}

