/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.properties;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.fecru.properties.RepositoryPropertyManager;
import com.atlassian.fisheye.event.RepositoryDeletedEventImpl;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.transaction.TransactionConfiguration;
import org.springframework.transaction.annotation.Transactional;

@TransactionConfiguration(defaultRollback=true)
@ContextConfiguration(value={"classpath:/tests-db-spring-context-level3-manager.xml"})
@Transactional
@RunWith(value=SpringJUnit4ClassRunner.class)
public class RepositoryPropertyManagerImplTest {
    @Autowired
    private RepositoryPropertyManager repositoryPropertyManager;
    @Autowired
    private EventPublisher eventPublisher;

    @Test
    public void propertiesAreRemovedAfterRepoDeleted() throws Exception {
        this.repositoryPropertyManager.saveProperty("repo", "property", "value");
        String preDelete = this.repositoryPropertyManager.loadProperty("repo", "property");
        this.eventPublisher.publish((Object)new RepositoryDeletedEventImpl("repo", "git"));
        String postDelete = this.repositoryPropertyManager.loadProperty("repo", "property");
        Assert.assertThat((Object)preDelete, (Matcher)Matchers.equalTo((Object)"value"));
        Assert.assertThat((Object)postDelete, (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }
}

