/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.profiling;

import com.atlassian.fecru.profiling.MemoryAllocationTracker;
import java.util.Optional;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class MemoryAllocationTrackerTest {
    private MemoryAllocationTracker memoryAllocationTracker;

    @Before
    public void setUp() throws Exception {
        this.memoryAllocationTracker = new MemoryAllocationTracker();
    }

    @Test
    public void testSomeAllocation() throws Exception {
        int loops = 1000;
        int byteArraySize = 65536;
        byte[][] preventGC = new byte[1000][];
        this.memoryAllocationTracker.start();
        for (int i = 0; i < 1000; ++i) {
            preventGC[i] = new byte[65536];
        }
        Optional allocation = this.memoryAllocationTracker.stop();
        Assert.assertThat((String)"allocation was recorded", (Object)allocation, (Matcher)new TypeSafeMatcher<Optional<Long>>(){
            private final long expectedAllocation = 65536000L;

            protected boolean matchesSafely(Optional<Long> actualOpt) {
                long actual = actualOpt.orElse(-1L);
                return actual >= 65536000L && (double)actual < 6.619136E7;
            }

            public void describeTo(Description description) {
                description.appendText("allocation of ").appendValue((Object)65536000L).appendText(" bytes plus some overhead");
            }

            protected void describeMismatchSafely(Optional<Long> item, Description mismatchDescription) {
                super.describeMismatchSafely(item, mismatchDescription);
                if (item.isPresent()) {
                    mismatchDescription.appendText(" what is ").appendValue((Object)((double)item.get().longValue() * 100.0 / 6.5536E7)).appendText(" % of expected value");
                }
            }
        });
    }
}

