/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.page;

import com.atlassian.fecru.page.Page;
import com.atlassian.fecru.page.PageRequest;
import com.atlassian.fecru.page.PagedResourceIterable;
import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class PagedResourceIterableTest {
    private int pagedResourceCallCounter;

    @Before
    public void setUp() {
        this.pagedResourceCallCounter = 0;
    }

    @Test
    public void testHasNextService() {
        PagedResourceIterable<String> empty = this.createPagedServiceIterableWithEmptyService();
        Assert.assertThat(empty, (Matcher)Matchers.emptyIterable());
        Assert.assertThat((Object)this.pagedResourceCallCounter, (Matcher)Matchers.is((Object)1));
    }

    @Test(expected=NoSuchElementException.class)
    public void testNextService() {
        PagedResourceIterable<String> empty = this.createPagedServiceIterableWithEmptyService();
        empty.iterator().next();
        Assert.assertThat((Object)this.pagedResourceCallCounter, (Matcher)Matchers.is((Object)1));
    }

    @Test
    public void testLessThenOnePageServiceHasNextNext() {
        PagedResourceIterable<String> iterable = this.createPagedServiceIterableWith6ElementsPageService(PageRequest.create((Integer)0, (Integer)10));
        Iterator iterator = iterable.iterator();
        Assert.assertThat((Object)iterator.hasNext(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat(iterator.next(), (Matcher)Matchers.is((Object)"a1"));
        Assert.assertThat((Object)this.pagedResourceCallCounter, (Matcher)Matchers.is((Object)1));
        Assert.assertThat((Object)iterator.hasNext(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat(iterator.next(), (Matcher)Matchers.is((Object)"b2"));
        Assert.assertThat((Object)this.pagedResourceCallCounter, (Matcher)Matchers.is((Object)1));
        Assert.assertThat((Object)iterator.hasNext(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat(iterator.next(), (Matcher)Matchers.is((Object)"c3"));
        Assert.assertThat((Object)this.pagedResourceCallCounter, (Matcher)Matchers.is((Object)1));
    }

    @Test
    public void testLessThenOnePageServiceAll() {
        PagedResourceIterable<String> iterable = this.createPagedServiceIterableWith6ElementsPageService(PageRequest.create((Integer)0, (Integer)10));
        Assert.assertThat(iterable, (Matcher)Matchers.contains((Object[])new String[]{"a1", "b2", "c3", "d4", "e5", "f6"}));
        Assert.assertThat((Object)this.pagedResourceCallCounter, (Matcher)Matchers.is((Object)1));
    }

    @Test
    public void testMoreThenOnePageServiceHasNextNext() {
        PagedResourceIterable<String> iterable = this.createPagedServiceIterableWith6ElementsPageService(PageRequest.create((Integer)0, (Integer)2));
        Iterator iterator = iterable.iterator();
        Assert.assertThat((Object)iterator.hasNext(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat(iterator.next(), (Matcher)Matchers.is((Object)"a1"));
        Assert.assertThat((Object)this.pagedResourceCallCounter, (Matcher)Matchers.is((Object)1));
        Assert.assertThat((Object)iterator.hasNext(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat(iterator.next(), (Matcher)Matchers.is((Object)"b2"));
        Assert.assertThat((Object)this.pagedResourceCallCounter, (Matcher)Matchers.is((Object)1));
        Assert.assertThat((Object)iterator.hasNext(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat(iterator.next(), (Matcher)Matchers.is((Object)"c3"));
        Assert.assertThat((Object)this.pagedResourceCallCounter, (Matcher)Matchers.is((Object)2));
    }

    @Test
    public void testMoreThenOnePageServiceAll() {
        PagedResourceIterable<String> iterable = this.createPagedServiceIterableWith6ElementsPageService(PageRequest.create((Integer)0, (Integer)2));
        Assert.assertThat(iterable, (Matcher)Matchers.contains((Object[])new String[]{"a1", "b2", "c3", "d4", "e5", "f6"}));
        Assert.assertThat((Object)this.pagedResourceCallCounter, (Matcher)Matchers.is((Object)3));
    }

    @Test
    public void testTransform() {
        PagedResourceIterable<String> iterable = this.createPagedServiceIterableWith6ElementsPageService(PageRequest.create((Integer)0, (Integer)2));
        Iterable iterableUpperCased = Iterables.transform(iterable, String::toUpperCase);
        Assert.assertThat((Object)iterableUpperCased, (Matcher)Matchers.contains((Object[])new String[]{"A1", "B2", "C3", "D4", "E5", "F6"}));
        Assert.assertThat((Object)this.pagedResourceCallCounter, (Matcher)Matchers.is((Object)3));
    }

    private PagedResourceIterable<String> createPagedServiceIterableWithEmptyService() {
        return new PagedResourceIterable(pageRequest -> {
            ++this.pagedResourceCallCounter;
            return Page.empty();
        });
    }

    private PagedResourceIterable<String> createPagedServiceIterableWith6ElementsPageService(PageRequest firstPageRequest) {
        return new PagedResourceIterable(pageRequest -> {
            ++this.pagedResourceCallCounter;
            return Page.Builder.buildFromAllDataIterable(Arrays.asList("a1", "b2", "c3", "d4", "e5", "f6"), (PageRequest)pageRequest);
        }, firstPageRequest);
    }
}

