/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.page;

import com.atlassian.fecru.page.PageRequest;
import org.junit.Assert;
import org.junit.Test;

public class PageRequestTest {
    @Test
    public void testDefault() throws Exception {
        this.assertStartAndLimit(0, 100, PageRequest.createDefault());
    }

    @Test
    public void testCreateWithNullValues() throws Exception {
        this.assertStartAndLimit(0, 100, PageRequest.create(null, null));
    }

    @Test
    public void testCreateWithZeros() throws Exception {
        this.assertStartAndLimit(0, 0, PageRequest.create((Integer)0, (Integer)0));
    }

    @Test
    public void testCreateWithSpecifiedValues() throws Exception {
        this.assertStartAndLimit(13, 42, PageRequest.create((Integer)13, (Integer)42));
    }

    @Test
    public void testCreateWithLargeValues() throws Exception {
        this.assertStartAndLimit(500000, 1000, PageRequest.create((Integer)500000, (Integer)1000000));
    }

    @Test
    public void testCreateWithNegativeValues() throws Exception {
        this.assertStartAndLimit(0, 100, PageRequest.create((Integer)-1, (Integer)-2));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testImproperUsageOnMaxInteger() throws Exception {
        PageRequest.create((Integer)0, (Integer)Integer.MAX_VALUE);
    }

    private void assertStartAndLimit(int expectedStart, int expectedLimit, PageRequest defaultPageRequest) {
        Assert.assertEquals((String)"start", (long)expectedStart, (long)defaultPageRequest.getStart());
        Assert.assertEquals((String)"limit", (long)expectedLimit, (long)defaultPageRequest.getLimit());
    }
}

