/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.page;

import com.atlassian.fecru.page.OnePageRequest;
import com.atlassian.fecru.page.PageRequest;
import org.junit.Assert;
import org.junit.Test;

public class OnePageRequestTest {
    @Test
    public void testOnePageRequestNegative() throws Exception {
        this.assertStartAndLimit(0, -1, OnePageRequest.create((int)-1));
    }

    @Test
    public void testOnePageRequestZero() throws Exception {
        this.assertStartAndLimit(0, 0, OnePageRequest.create((int)0));
    }

    @Test
    public void testOnePageRequestFourtyTwo() throws Exception {
        this.assertStartAndLimit(0, 42, OnePageRequest.create((int)42));
    }

    @Test
    public void testOnePageRequestOneMillion() throws Exception {
        this.assertStartAndLimit(0, 1000000, OnePageRequest.create((int)1000000));
    }

    @Test
    public void testOnePageRequestNoLimit() throws Exception {
        this.assertStartAndLimit(0, 0x7FFFFFFE, OnePageRequest.createNoLimit());
    }

    private void assertStartAndLimit(int expectedStart, int expectedLimit, PageRequest defaultPageRequest) {
        Assert.assertEquals((String)"start", (long)expectedStart, (long)defaultPageRequest.getStart());
        Assert.assertEquals((String)"limit", (long)expectedLimit, (long)defaultPageRequest.getLimit());
    }
}

