/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.mentions;

import com.atlassian.crucible.configuration.metrics.FieldDefinition;
import com.atlassian.crucible.event.CommentCreatedEvent;
import com.atlassian.crucible.event.CommentCreatedEventImpl;
import com.atlassian.crucible.event.CommentUpdatedEvent;
import com.atlassian.crucible.event.CommentUpdatedEventImpl;
import com.atlassian.crucible.event.ReviewStateChangedEvent;
import com.atlassian.crucible.event.ReviewStateChangedEventImpl;
import com.atlassian.crucible.event.cscomment.CsCommentCreatedEvent;
import com.atlassian.crucible.event.cscomment.CsCommentCreatedEventImpl;
import com.atlassian.crucible.event.cscomment.CsCommentUpdatedEvent;
import com.atlassian.crucible.event.cscomment.CsCommentUpdatedEventImpl;
import com.atlassian.crucible.spi.PermId;
import com.atlassian.crucible.spi.data.ReviewData;
import com.atlassian.crucible.spi.data.UserData;
import com.atlassian.crucible.spi.impl.SPIUserUtils;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.fecru.mentions.DefaultMentionParserListener;
import com.atlassian.fecru.mentions.TestUserMentionedEventImpl;
import com.atlassian.fecru.user.FecruUser;
import com.atlassian.fecru.user.UserProfile;
import com.atlassian.fisheye.model.ChangesetComment;
import com.atlassian.fisheye.model.managers.ChangesetCommentManager;
import com.cenqua.crucible.model.Comment;
import com.cenqua.crucible.model.CommentVisitor;
import com.cenqua.crucible.model.CommonListMixin;
import com.cenqua.crucible.model.LogItem;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.managers.CommentManager;
import com.cenqua.crucible.model.managers.DefaultCommentManager;
import com.cenqua.crucible.model.managers.LogItemBuilder;
import com.cenqua.crucible.model.managers.ReviewManager;
import com.cenqua.crucible.model.managers.StateManager;
import com.cenqua.crucible.model.managers.UserActionManager;
import com.cenqua.crucible.notification.DeliverySchedule;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.config.RootConfig;
import com.cenqua.fisheye.config1.ConfigDocument;
import com.cenqua.fisheye.config1.WebServerType;
import com.cenqua.fisheye.user.UserManager;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class MentionParserListenerTest {
    @MockitoAnnotations.Mock
    private ChangesetCommentManager changesetCommentManager;
    @MockitoAnnotations.Mock
    private ReviewManager reviewManager;
    @MockitoAnnotations.Mock
    private EventPublisher eventPublisher;
    @MockitoAnnotations.Mock
    private UserManager userManager;
    @MockitoAnnotations.Mock
    private CommentManager commentManager;
    @MockitoAnnotations.Mock
    RootConfig rootConfig;
    @MockitoAnnotations.Mock
    ConfigDocument.Config config;
    @MockitoAnnotations.Mock
    private WebServerType webServerType;
    @MockitoAnnotations.Mock
    private SPIUserUtils spiUserUtils;
    private List<LogItem> logItems;
    private RootConfig oldRootConfig;

    @Before
    public void setUp() {
        this.oldRootConfig = AppConfig.getsConfig();
    }

    @After
    public void tearDown() {
        AppConfig.resetConfig((RootConfig)this.oldRootConfig);
    }

    private DefaultMentionParserListener getListener() {
        return new DefaultMentionParserListener(this.changesetCommentManager, this.reviewManager, this.eventPublisher, this.userManager, this.commentManager, this.spiUserUtils){

            protected List<LogItem> getLogItems(int reviewId, Set<String> actions) {
                return MentionParserListenerTest.this.logItems;
            }

            protected void logMentionSent(Review review, FecruUser user, String mentionedUserName, String url) {
            }
        };
    }

    @Test
    public void testNoMentions() {
        Assert.assertTrue((boolean)this.getListener().parseMentions("@ [~] [~foo zzz zzz@bbb").isEmpty());
    }

    @Test
    public void testMentions() {
        Set names = this.getListener().parseMentions("@Xxxx [~foo] @\u6c49\u5b57/\u6f22\u5b57 [~\u03b1\u03b2\u03b3\u03b4\u03b5\u03b6][~fred] @qqq");
        Assert.assertEquals((long)6L, (long)names.size());
        Assert.assertTrue((boolean)names.contains("Xxxx"));
        Assert.assertTrue((boolean)names.contains("foo"));
        Assert.assertTrue((boolean)names.contains("\u6c49\u5b57/\u6f22\u5b57"));
        Assert.assertTrue((boolean)names.contains("\u03b1\u03b2\u03b3\u03b4\u03b5\u03b6"));
        Assert.assertTrue((boolean)names.contains("fred"));
        Assert.assertTrue((boolean)names.contains("qqq"));
    }

    @Test
    public void testCsCommentCreatedEventListener() {
        UserData actioner = new UserData("fred");
        this.testCsCommentCreated(actioner);
    }

    @Test
    public void testCsCommentCreatedByAnonEventListener() {
        this.testCsCommentCreated(null);
    }

    @Test
    public void testCsCommentUpdatedEventListener() {
        String oldMessage = "blah blah";
        this.testCsCommentUpdated(oldMessage);
        ((EventPublisher)Mockito.verify((Object)this.eventPublisher)).publish((Object)new TestUserMentionedEventImpl("reviewer", "fred", "http://host:port/context/changelog/the_repo?cs=the_csid#c101"));
    }

    @Test
    public void testCsCommentUpdatedNoNewMentionEventListener() {
        String oldMessage = "@reviewer";
        this.testCsCommentUpdated(oldMessage);
        ((EventPublisher)Mockito.verify((Object)this.eventPublisher, (VerificationMode)Mockito.never())).publish(Matchers.anyObject());
    }

    @Test
    public void testCommentCreatedEventListener() {
        this.logItems = Collections.emptyList();
        CommentTestEnv commentTestEnv = new CommentTestEnv().invoke("mentioning @nonreviewer");
        Review review = commentTestEnv.getReview();
        Comment comment = commentTestEnv.getComment();
        DefaultMentionParserListener l = this.getListener();
        l.commentCreatedEventListener((CommentCreatedEvent)new CommentCreatedEventImpl(review.getPermId(), new UserData(comment.getUser().getUsername()), new PermId(comment.getPermaId()), comment.isDraft(), null));
        this.verifyEventPublished(new UserData("fred"), "http://host:port/context/cru/CR-102#c100", "nonreviewer");
    }

    @Test
    public void testCommentUpdatedEventListener() {
        this.logItems = Collections.emptyList();
        CommentTestEnv commentTestEnv = new CommentTestEnv().invoke("mentioning @nonreviewer and @nonUser");
        Review review = commentTestEnv.getReview();
        Comment comment = commentTestEnv.getComment();
        DefaultMentionParserListener l = this.getListener();
        l.commentUpdatedEventListener((CommentUpdatedEvent)new CommentUpdatedEventImpl(review.getPermId(), new UserData(comment.getUser().getUsername()), new PermId(comment.getPermaId()), "hi @nonreviewer", false, comment.isDraft(), null));
        this.verifyEventPublished(new UserData("fred"), "http://host:port/context/cru/CR-102#c100", "nonUser");
        ((EventPublisher)Mockito.verify((Object)this.eventPublisher)).register((Object)l);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.eventPublisher});
    }

    @Test
    public void testNewDraftCommentsIgnored() {
        this.logItems = Collections.emptyList();
        CommentTestEnv commentTestEnv = new CommentTestEnv().invoke("mentioning @nonreviewer");
        Review review = commentTestEnv.getReview();
        Comment comment = commentTestEnv.getComment();
        comment.setDraft(true);
        DefaultMentionParserListener l = this.getListener();
        l.commentCreatedEventListener((CommentCreatedEvent)new CommentCreatedEventImpl(review.getPermId(), new UserData(comment.getUser().getUsername()), new PermId(comment.getPermaId()), comment.isDraft(), null));
        ((EventPublisher)Mockito.verify((Object)this.eventPublisher)).register((Object)l);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.eventPublisher});
    }

    @Test
    public void testChangedDraftCommentsIgnored() {
        this.logItems = Collections.emptyList();
        CommentTestEnv commentTestEnv = new CommentTestEnv().invoke("mentioning @nonreviewer and @nonUser");
        Review review = commentTestEnv.getReview();
        Comment comment = commentTestEnv.getComment();
        comment.setDraft(true);
        DefaultMentionParserListener l = this.getListener();
        l.commentUpdatedEventListener((CommentUpdatedEvent)new CommentUpdatedEventImpl(review.getPermId(), new UserData(comment.getUser().getUsername()), new PermId(comment.getPermaId()), "hi @nonreviewer", false, comment.isDraft(), null));
        ((EventPublisher)Mockito.verify((Object)this.eventPublisher)).register((Object)l);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.eventPublisher});
    }

    @Test
    public void testReviewerMentionIgnored() {
        this.logItems = Collections.emptyList();
        CommentTestEnv commentTestEnv = new CommentTestEnv().invoke("mentioning @reviewer");
        Review review = commentTestEnv.getReview();
        Comment comment = commentTestEnv.getComment();
        DefaultMentionParserListener l = this.getListener();
        l.commentCreatedEventListener((CommentCreatedEvent)new CommentCreatedEventImpl(review.getPermId(), new UserData(comment.getUser().getUsername()), new PermId(comment.getPermaId()), comment.isDraft(), null));
        ((EventPublisher)Mockito.verify((Object)this.eventPublisher)).register((Object)l);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.eventPublisher});
    }

    @Test
    public void testPublishedCommentsSent() {
        this.logItems = Collections.emptyList();
        CommentTestEnv commentTestEnv = new CommentTestEnv().invoke("mentioning @nonreviewer and @nonUser");
        Review review = commentTestEnv.getReview();
        Comment comment = commentTestEnv.getComment();
        DefaultMentionParserListener l = this.getListener();
        l.commentUpdatedEventListener((CommentUpdatedEvent)new CommentUpdatedEventImpl(review.getPermId(), new UserData(comment.getUser().getUsername()), new PermId(comment.getPermaId()), "mentioning @nonreviewer and @nonUser", true, comment.isDraft(), null));
        this.verifyEventPublished(new UserData("fred"), "http://host:port/context/cru/CR-102#c100", "nonreviewer");
        this.verifyEventPublished(new UserData("fred"), "http://host:port/context/cru/CR-102#c100", "nonUser");
        ((EventPublisher)Mockito.verify((Object)this.eventPublisher)).register((Object)l);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.eventPublisher});
    }

    @Test
    public void testCommentsPublishedWhenReviewStarted() {
        this.logItems = Collections.emptyList();
        DefaultMentionParserListener l = this.testStateChange(new CommentTestEnv().invoke("mentioning @nonreviewer and @nonUser"));
        this.verifyEventPublished(new UserData("fred"), "http://host:port/context/cru/CR-102#c100", "nonreviewer");
        this.verifyEventPublished(new UserData("fred"), "http://host:port/context/cru/CR-102#c100", "nonUser");
        this.verifyEventPublished(new UserData("fred"), "http://host:port/context/cru/CR-102", "avi");
        ((EventPublisher)Mockito.verify((Object)this.eventPublisher)).register((Object)l);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.eventPublisher});
    }

    private DefaultMentionParserListener testStateChange(CommentTestEnv commentTestEnv) {
        Review review = commentTestEnv.getReview();
        DefaultMentionParserListener l = this.getListener();
        l.reviewStateChangedEventListener((ReviewStateChangedEvent)new ReviewStateChangedEventImpl(new PermId(review.getPermaId()), ReviewData.State.Draft, ReviewData.State.Review, UserActionManager.ACTION_APPROVE, new UserData("fred")));
        return l;
    }

    @Test
    public void testCommentsNotPublishedWhenReviewRestarted() {
        CommentTestEnv commentTestEnv = new CommentTestEnv().invoke("mentioning @nonreviewer and @nonUser");
        this.logItems = Arrays.asList(LogItemBuilder.buildMentionEventSent((Review)commentTestEnv.getReview(), (FecruUser)new FecruUser("fred"), (String)"nonreviewer", (String)"http://host:port/context/cru/CR-102#c100"), LogItemBuilder.buildMentionEventSent((Review)commentTestEnv.getReview(), (FecruUser)new FecruUser("fred"), (String)"nonUser", (String)"http://host:port/context/cru/CR-102#c100"), LogItemBuilder.buildMentionEventSent((Review)commentTestEnv.getReview(), (FecruUser)new FecruUser("fred"), (String)"avi", (String)"http://host:port/context/cru/CR-103"));
        DefaultMentionParserListener l = this.testStateChange(commentTestEnv);
        this.verifyEventPublished(new UserData("fred"), "http://host:port/context/cru/CR-102", "avi");
        ((EventPublisher)Mockito.verify((Object)this.eventPublisher)).register((Object)l);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.eventPublisher});
    }

    private void testCsCommentUpdated(String oldMessage) {
        UserData actioner = new UserData("fred");
        this.setupMockConfig();
        ChangesetComment comment = new ChangesetComment(new FecruUser("jill"), "the_repo", "the_csid", "hi @reviewer how are you?", null, false, false);
        comment.setId(Integer.valueOf(101));
        Mockito.when((Object)this.changesetCommentManager.getComment(new PermId("the_permid"))).thenReturn((Object)comment);
        DefaultMentionParserListener l = this.getListener();
        l.csCommentUpdatedEventListener((CsCommentUpdatedEvent)new CsCommentUpdatedEventImpl(actioner, "the_repo", "the_csid", "the_permid", oldMessage));
    }

    private void testCsCommentCreated(UserData actioner) {
        this.setupMockConfig();
        ChangesetComment comment = new ChangesetComment(new FecruUser("jill"), "the_repo", "the_csid", "hi @reviewer how are you?", null, false, false);
        comment.setId(Integer.valueOf(101));
        Mockito.when((Object)this.changesetCommentManager.getComment(new PermId("the_permid"))).thenReturn((Object)comment);
        DefaultMentionParserListener l = this.getListener();
        l.csCommentCreatedEventListener((CsCommentCreatedEvent)new CsCommentCreatedEventImpl(actioner, "the_repo", "the_csid", "the_permid"));
        String url = "http://host:port/context/changelog/the_repo?cs=the_csid#c101";
        this.verifyEventPublished(actioner, "http://host:port/context/changelog/the_repo?cs=the_csid#c101", "reviewer");
    }

    private void verifyEventPublished(UserData actioner, String url, String mentionedUserName) {
        ((EventPublisher)Mockito.verify((Object)this.eventPublisher)).publish((Object)new TestUserMentionedEventImpl(mentionedUserName, actioner == null ? null : actioner.getUserName(), url));
    }

    private void setupMockConfig() {
        AppConfig.resetConfig((RootConfig)this.rootConfig);
        Mockito.when((Object)this.rootConfig.getConfig()).thenReturn((Object)this.config);
        Mockito.when((Object)this.config.getWebServer()).thenReturn((Object)this.webServerType);
        Mockito.when((Object)this.rootConfig.getSiteURL()).thenReturn((Object)"http://host:port/context");
        Mockito.when((Object)this.webServerType.getContext()).thenReturn((Object)"context");
    }

    private class CommentTestEnv {
        private Review review;
        private Comment comment;
        private CommonListMixin commentList = new CommonListMixin(){

            public Map<String, FieldDefinition> getFieldDefinitions() {
                return Collections.emptyMap();
            }
        };

        private CommentTestEnv() {
        }

        public Review getReview() {
            return this.review;
        }

        public Comment getComment() {
            return this.comment;
        }

        public CommentTestEnv invoke(String message) {
            MentionParserListenerTest.this.setupMockConfig();
            FecruUser user = new FecruUser("fred");
            this.review = (Review)Mockito.mock(Review.class);
            Mockito.when((Object)MentionParserListenerTest.this.spiUserUtils.createUserData(user)).thenReturn((Object)new UserData(user.getUsername()));
            Mockito.when((Object)MentionParserListenerTest.this.userManager.getLicensedUser(user.getUsername())).thenReturn((Object)user);
            this.comment = new Comment();
            this.comment.setDraft(false);
            this.comment.setMessage(message);
            this.comment.setId(Integer.valueOf(100));
            this.comment.setUser(user);
            this.comment.setReview(this.review);
            this.commentList.addComment(this.comment);
            Mockito.when((Object)this.review.getPermaId()).thenReturn((Object)"CR-102");
            Mockito.when((Object)MentionParserListenerTest.this.reviewManager.getReviewByPermaId("CR-102")).thenReturn((Object)this.review);
            Mockito.when((Object)this.review.getState()).thenReturn((Object)StateManager.INSTANCE.getReviewState());
            Mockito.when((Object)this.review.getDescription()).thenReturn((Object)"@avi");
            Mockito.when((Object)this.review.isSnippet()).thenReturn((Object)false);
            FecruUser reviewer = (FecruUser)Mockito.mock(FecruUser.class);
            UserProfile reviewerProfile = (UserProfile)Mockito.mock(UserProfile.class);
            Mockito.when((Object)reviewer.getUserProfile()).thenReturn((Object)reviewerProfile);
            Mockito.when((Object)reviewerProfile.getCommentEmailNotification()).thenReturn((Object)DeliverySchedule.IMMEDIATE);
            Mockito.when((Object)MentionParserListenerTest.this.userManager.getLicensedUser("reviewer")).thenReturn((Object)reviewer);
            Mockito.when((Object)this.review.isReviewer(reviewer)).thenReturn((Object)true);
            FecruUser nonReviewer = (FecruUser)Mockito.mock(FecruUser.class);
            UserProfile nonReviewerProfile = (UserProfile)Mockito.mock(UserProfile.class);
            Mockito.when((Object)nonReviewer.getUserProfile()).thenReturn((Object)nonReviewerProfile);
            Mockito.when((Object)reviewerProfile.getCommentEmailNotification()).thenReturn((Object)DeliverySchedule.IMMEDIATE);
            Mockito.when((Object)MentionParserListenerTest.this.userManager.getLicensedUser("nonreviewer")).thenReturn((Object)nonReviewer);
            Mockito.when((Object)this.review.isReviewer(nonReviewer)).thenReturn((Object)false);
            Mockito.when((Object)this.review.getFrxs()).thenReturn(Collections.emptySet());
            ((Review)Mockito.doAnswer(invocation -> {
                this.commentList.visit((CommentVisitor)invocation.getArguments()[0]);
                return null;
            }).when((Object)this.review)).visit((CommentVisitor)Matchers.anyObject());
            Mockito.when((Object)MentionParserListenerTest.this.commentManager.getByPermId(new PermId(this.comment.getPermaId()))).thenReturn((Object)this.comment);
            Mockito.when((Object)MentionParserListenerTest.this.commentManager.comments(this.review)).thenReturn((Object)new DefaultCommentManager(null, null, null, null, null, null).comments(this.review));
            return this;
        }
    }
}

