/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.matcher;

import com.atlassian.fecru.matcher.FileMatchers;
import java.io.File;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class FileMatchersTest {
    private File file;

    @After
    public void tearDown() throws Exception {
        if (null != this.file && this.file.exists()) {
            this.file.delete();
        }
    }

    @Test
    public void testFileMatcherExistsFileExists() throws Exception {
        this.file = File.createTempFile("FileMatchersTest", null);
        Assert.assertThat((String)"temporary file should be created by now", (Object)this.file, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
        Assert.assertThat((String)"temporary file should be created by now", (Object)this.file.exists(), (Matcher)CoreMatchers.is((Object)Boolean.TRUE));
        Assert.assertThat((String)"tested matcher should realise the file exists", (Object)this.file, FileMatchers.exists());
    }

    @Test
    public void testFileMatcherExistsFileDoesNotExist() throws Exception {
        this.file = File.createTempFile("FileMatchersTest", null);
        Assert.assertThat((String)"temporary file should be created by now", (Object)this.file, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
        this.file.delete();
        Assert.assertThat((String)"temporary file should not exist by now", (Object)this.file.exists(), (Matcher)CoreMatchers.is((Object)Boolean.FALSE));
        Assert.assertThat((String)"tested matcher should realise the file does not exist", (Object)this.file, (Matcher)CoreMatchers.not(FileMatchers.exists()));
    }

    @Test
    public void testFileMatcherIsDirectoryForFile() throws Exception {
        this.file = File.createTempFile("FileMatchersTest", null);
        Assert.assertThat((String)"temporary file should be created by now", (Object)this.file, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
        Assert.assertThat((String)"file is of type of file", (Object)this.file.isFile(), (Matcher)CoreMatchers.is((Object)Boolean.TRUE));
        Assert.assertThat((String)"tested matcher should realise the file is not a folder", (Object)this.file, (Matcher)CoreMatchers.not(FileMatchers.isDirectory()));
    }

    @Test
    public void testFileMatcherIsDirectoryForDirectory() throws Exception {
        this.file = File.createTempFile("FileMatchersTest", null);
        Assert.assertThat((String)"temporary file should be created by now", (Object)this.file, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
        this.file.delete();
        this.file.mkdir();
        Assert.assertThat((String)"file is of type of directory", (Object)this.file.isDirectory(), (Matcher)CoreMatchers.is((Object)Boolean.TRUE));
        Assert.assertThat((String)"tested matcher should realise the file is a folder", (Object)this.file, FileMatchers.isDirectory());
    }

    @Test
    public void testFileMatcherIsDirectoryForNonExisting() throws Exception {
        this.file = new File("/some/non/existent/file");
        Assert.assertThat((String)"temporary file should be created by now", (Object)this.file, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
        Assert.assertThat((String)"file does not exist", (Object)this.file.exists(), (Matcher)CoreMatchers.is((Object)Boolean.FALSE));
        Assert.assertThat((String)"tested matcher should realise the path does not represent a folder", (Object)this.file, (Matcher)CoreMatchers.not(FileMatchers.isDirectory()));
    }
}

