/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.license;

import com.atlassian.crowd.event.DirectoryEvent;
import com.atlassian.crowd.event.application.ApplicationDirectoryAddedEvent;
import com.atlassian.crowd.event.application.ApplicationDirectoryOrderUpdatedEvent;
import com.atlassian.crowd.event.application.ApplicationDirectoryRemovedEvent;
import com.atlassian.crowd.event.application.ApplicationUpdatedEvent;
import com.atlassian.crowd.event.directory.DirectoryCreatedEvent;
import com.atlassian.crowd.event.directory.DirectoryDeletedEvent;
import com.atlassian.crowd.event.directory.DirectoryUpdatedEvent;
import com.atlassian.crowd.event.group.GroupCreatedEvent;
import com.atlassian.crowd.event.group.GroupDeletedEvent;
import com.atlassian.crowd.event.group.GroupMembershipCreatedEvent;
import com.atlassian.crowd.event.group.GroupMembershipDeletedEvent;
import com.atlassian.crowd.event.group.GroupUpdatedEvent;
import com.atlassian.crowd.event.user.UserCreatedEvent;
import com.atlassian.crowd.event.user.UserDeletedEvent;
import com.atlassian.crowd.event.user.UserEditedEvent;
import com.atlassian.crowd.event.user.UserRenamedEvent;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.fecru.license.LicenseChangedEvent;
import com.atlassian.fecru.user.UserListChangedEvent;
import com.atlassian.fecru.user.UserListChangedEventPublisher;
import com.atlassian.fecru.user.crowd.event.RemoteDirectorySynchronisationCompleteEvent;
import com.cenqua.fisheye.user.embeddedcrowd.UserSynchronizationStatusManager;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class UserListChangedEventPublisherTest {
    private UserListChangedEventPublisher userListChangedEventPublisher;
    @Mock
    private EventPublisher eventPublisher;
    @Mock
    UserSynchronizationStatusManager userSynchronizationStatusManager;

    @Before
    public void setUp() throws Exception {
        this.userListChangedEventPublisher = new UserListChangedEventPublisher(this.eventPublisher, this.userSynchronizationStatusManager);
    }

    @Test
    public void shouldPublishEagerlyWhenNoSync() {
        this.userListChangedEventPublisher.onLicenseChangedEvent((LicenseChangedEvent)Mockito.mock(LicenseChangedEvent.class));
        this.userListChangedEventPublisher.onGroupMembershipCreatedEvent((GroupMembershipCreatedEvent)Mockito.mock(GroupMembershipCreatedEvent.class));
        this.userListChangedEventPublisher.onGroupMembershipDeletedEvent((GroupMembershipDeletedEvent)Mockito.mock(GroupMembershipDeletedEvent.class));
        this.userListChangedEventPublisher.onGroupCreatedEvent((GroupCreatedEvent)Mockito.mock(GroupCreatedEvent.class));
        this.userListChangedEventPublisher.onGroupUpdatedEvent((GroupUpdatedEvent)Mockito.mock(GroupUpdatedEvent.class));
        this.userListChangedEventPublisher.onGroupDeletedEvent((GroupDeletedEvent)Mockito.mock(GroupDeletedEvent.class));
        this.userListChangedEventPublisher.onUserCreatedEvent((UserCreatedEvent)Mockito.mock(UserCreatedEvent.class));
        this.userListChangedEventPublisher.onUserEditedEvent((UserEditedEvent)Mockito.mock(UserEditedEvent.class));
        this.userListChangedEventPublisher.onUserDeletedEvent((UserDeletedEvent)Mockito.mock(UserDeletedEvent.class));
        this.userListChangedEventPublisher.onUserRenamedEvent((UserRenamedEvent)Mockito.mock(UserRenamedEvent.class));
        this.userListChangedEventPublisher.onDirectoryDeletedEvent((DirectoryDeletedEvent)Mockito.mock(DirectoryDeletedEvent.class));
        this.userListChangedEventPublisher.onDirectoryUpdatedEvent((DirectoryUpdatedEvent)Mockito.mock(DirectoryUpdatedEvent.class));
        this.userListChangedEventPublisher.onDirectoryCreatedEvent((DirectoryCreatedEvent)Mockito.mock(DirectoryCreatedEvent.class));
        this.userListChangedEventPublisher.onApplicationDirectoryAddedEvent((ApplicationDirectoryAddedEvent)Mockito.mock(ApplicationDirectoryAddedEvent.class));
        this.userListChangedEventPublisher.onApplicationDirectoryRemovedEvent((ApplicationDirectoryRemovedEvent)Mockito.mock(ApplicationDirectoryRemovedEvent.class));
        this.userListChangedEventPublisher.onApplicationDirectoryOrderUpdatedEvent((ApplicationDirectoryOrderUpdatedEvent)Mockito.mock(ApplicationDirectoryOrderUpdatedEvent.class));
        this.userListChangedEventPublisher.onApplicationUpdatedEvent((ApplicationUpdatedEvent)Mockito.mock(ApplicationUpdatedEvent.class));
        ((EventPublisher)Mockito.verify((Object)this.eventPublisher, (VerificationMode)Mockito.times((int)17))).publish(Matchers.any(UserListChangedEvent.class));
    }

    @Test
    public void shouldPublishLazilyDuringSync() throws Exception {
        Mockito.when((Object)this.userSynchronizationStatusManager.isSynchronisationInProgress(1L)).thenReturn((Object)true);
        this.userListChangedEventPublisher.onUserCreatedEvent(this.mockDirectoryEvent(UserCreatedEvent.class, 1L));
        this.userListChangedEventPublisher.onUserCreatedEvent(this.mockDirectoryEvent(UserCreatedEvent.class, 1L));
        this.userListChangedEventPublisher.onUserCreatedEvent(this.mockDirectoryEvent(UserCreatedEvent.class, 1L));
        this.userListChangedEventPublisher.onRemoteDirectorySynchronisationCompleteEvent(this.mockSyncCompleteEvent(1L));
        ((EventPublisher)Mockito.verify((Object)this.eventPublisher, (VerificationMode)Mockito.times((int)1))).publish(Matchers.any(UserListChangedEvent.class));
    }

    @Test
    public void shouldNotPublishForSyncsWithoutMutations() throws Exception {
        this.userListChangedEventPublisher.onRemoteDirectorySynchronisationCompleteEvent(this.mockSyncCompleteEvent(1L));
        ((EventPublisher)Mockito.verify((Object)this.eventPublisher, (VerificationMode)Mockito.never())).publish(Matchers.any(UserListChangedEvent.class));
    }

    @Test
    public void shouldNotPublishForSubsequentSyncsWithoutMutations() throws Exception {
        Mockito.when((Object)this.userSynchronizationStatusManager.isSynchronisationInProgress(1L)).thenReturn((Object)true);
        this.userListChangedEventPublisher.onUserCreatedEvent(this.mockDirectoryEvent(UserCreatedEvent.class, 1L));
        this.userListChangedEventPublisher.onRemoteDirectorySynchronisationCompleteEvent(this.mockSyncCompleteEvent(1L));
        this.userListChangedEventPublisher.onRemoteDirectorySynchronisationCompleteEvent(this.mockSyncCompleteEvent(1L));
        ((EventPublisher)Mockito.verify((Object)this.eventPublisher, (VerificationMode)Mockito.times((int)1))).publish(Matchers.any(UserListChangedEvent.class));
    }

    @Test
    public void shouldPublishImmediatelyForEventsThatOccurAfterSyncEnds() throws Exception {
        Mockito.when((Object)this.userSynchronizationStatusManager.isSynchronisationInProgress(1L)).thenReturn((Object)true);
        this.userListChangedEventPublisher.onUserCreatedEvent(this.mockDirectoryEvent(UserCreatedEvent.class, 1L));
        this.userListChangedEventPublisher.onRemoteDirectorySynchronisationCompleteEvent(this.mockSyncCompleteEvent(1L));
        Mockito.when((Object)this.userSynchronizationStatusManager.isSynchronisationInProgress(1L)).thenReturn((Object)false);
        this.userListChangedEventPublisher.onUserCreatedEvent(this.mockDirectoryEvent(UserCreatedEvent.class, 1L));
        ((EventPublisher)Mockito.verify((Object)this.eventPublisher, (VerificationMode)Mockito.times((int)2))).publish(Matchers.any(UserListChangedEvent.class));
    }

    @Test
    public void shouldHandleMultipleDirectories() throws Exception {
        Mockito.when((Object)this.userSynchronizationStatusManager.isSynchronisationInProgress(2L)).thenReturn((Object)true);
        this.userListChangedEventPublisher.onUserDeletedEvent(this.mockDirectoryEvent(UserDeletedEvent.class, 1L));
        ((EventPublisher)Mockito.verify((Object)this.eventPublisher, (VerificationMode)Mockito.times((int)1))).publish(Matchers.any(UserListChangedEvent.class));
    }

    private RemoteDirectorySynchronisationCompleteEvent mockSyncCompleteEvent(long directoryId) {
        RemoteDirectorySynchronisationCompleteEvent event = (RemoteDirectorySynchronisationCompleteEvent)Mockito.mock(RemoteDirectorySynchronisationCompleteEvent.class);
        Mockito.when((Object)event.getDirectoryId()).thenReturn((Object)directoryId);
        return event;
    }

    private <T extends DirectoryEvent> T mockDirectoryEvent(Class<T> eventClazz, long directoryId) {
        DirectoryEvent event = (DirectoryEvent)Mockito.mock(eventClazz);
        Mockito.when((Object)event.getDirectoryId()).thenReturn((Object)directoryId);
        return (T)event;
    }
}

