/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.license;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.fecru.license.DefaultLicenseManager;
import com.atlassian.fecru.license.LicenseChangedEvent;
import com.atlassian.fecru.license.LicenseManager;
import com.atlassian.fisheye.user.permissions.GlobalPermissionManager;
import com.atlassian.fisheye.user.permissions.GlobalPermissionType;
import com.cenqua.fisheye.config.ConfigException;
import com.cenqua.fisheye.config.RootConfig;
import com.cenqua.fisheye.config.RootConfigRule;
import com.cenqua.fisheye.config1.ConfigDocument;
import com.cenqua.fisheye.config1.LicenseType;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class DefaultLicenseManagerTest {
    private static final String CONFIG_XML = "configs/empty.xml";
    private LicenseManager licenseManager;
    private EventPublisher eventPublisher;
    private RootConfig rootConfig;
    private ConfigDocument.Config config;
    private LicenseType licenseType;
    private GlobalPermissionManager globalPermissionManager;
    @Rule
    public RootConfigRule rootConfigRule = new RootConfigRule();

    @Before
    public void setUp() throws Exception {
        this.rootConfig = this.rootConfigRule.getRootConfig();
        this.eventPublisher = (EventPublisher)Mockito.mock(EventPublisher.class);
        this.config = (ConfigDocument.Config)Mockito.mock(ConfigDocument.Config.class);
        this.licenseType = (LicenseType)Mockito.mock(LicenseType.class);
        this.globalPermissionManager = (GlobalPermissionManager)Mockito.mock(GlobalPermissionManager.class);
        Mockito.when((Object)this.config.getLicense()).thenReturn((Object)this.licenseType);
        Mockito.when((Object)this.rootConfig.getConfig()).thenReturn((Object)this.config);
        this.licenseManager = new DefaultLicenseManager(this.rootConfig, this.eventPublisher, this.globalPermissionManager);
    }

    @Test
    public void testEmptyStringLicenseIsDisabledLicense() throws Exception {
        Mockito.when((Object)this.licenseType.getFisheye()).thenReturn((Object)"Disabled");
        Mockito.when((Object)this.licenseType.getCrucible()).thenReturn((Object)"qMqRmLENIjGEKbtAQbwVtoXVqNopDBekhJgDJubIwKdUIJ\nmi2K2Bt6jt>dPQ0JYUoUcHMb2KXb<MWDz<WhaHUfybkCt0\nmqOOWwRNQMMPQMNoqQQWuQonQnpNRmmMNRVSstXsSXTxSP\nWvtoTTwwuPMmnonnnmUUqmvrqmsummmmmUUqmvrqmsummm\nmmUU1qiXppfXkWGqvWCqaUUnmmmm");
        Mockito.when((Object)this.licenseType.isSetCrucible()).thenReturn((Object)true);
        Mockito.when((Object)this.licenseType.isSetFisheye()).thenReturn((Object)true);
        this.licenseManager.updateLicenses("", "qMqRmLENIjGEKbtAQbwVtoXVqNopDBekhJgDJubIwKdUIJ\nmi2K2Bt6jt>dPQ0JYUoUcHMb2KXb<MWDz<WhaHUfybkCt0\nmqOOWwRNQMMPQMNoqQQWuQonQnpNRmmMNRVSstXsSXTxSP\nWvtoTTwwuPMmnonnnmUUqmvrqmsummmmmUUqmvrqmsummm\nmmUU1qiXppfXkWGqvWCqaUUnmmmm");
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.eventPublisher});
        ((RootConfig)Mockito.verify((Object)this.rootConfig, (VerificationMode)Mockito.never())).saveConfig();
        ((RootConfig)Mockito.verify((Object)this.rootConfig, (VerificationMode)Mockito.never())).refreshLicenses();
    }

    @Test
    public void testNullLicenseIsDisabledLicense() throws Exception {
        Mockito.when((Object)this.licenseType.getFisheye()).thenReturn((Object)"Disabled");
        Mockito.when((Object)this.licenseType.getCrucible()).thenReturn((Object)"qMqRmLENIjGEKbtAQbwVtoXVqNopDBekhJgDJubIwKdUIJ\nmi2K2Bt6jt>dPQ0JYUoUcHMb2KXb<MWDz<WhaHUfybkCt0\nmqOOWwRNQMMPQMNoqQQWuQonQnpNRmmMNRVSstXsSXTxSP\nWvtoTTwwuPMmnonnnmUUqmvrqmsummmmmUUqmvrqmsummm\nmmUU1qiXppfXkWGqvWCqaUUnmmmm");
        Mockito.when((Object)this.licenseType.isSetCrucible()).thenReturn((Object)true);
        Mockito.when((Object)this.licenseType.isSetFisheye()).thenReturn((Object)true);
        this.licenseManager.updateLicenses(null, "qMqRmLENIjGEKbtAQbwVtoXVqNopDBekhJgDJubIwKdUIJ\nmi2K2Bt6jt>dPQ0JYUoUcHMb2KXb<MWDz<WhaHUfybkCt0\nmqOOWwRNQMMPQMNoqQQWuQonQnpNRmmMNRVSstXsSXTxSP\nWvtoTTwwuPMmnonnnmUUqmvrqmsummmmmUUqmvrqmsummm\nmmUU1qiXppfXkWGqvWCqaUUnmmmm");
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.eventPublisher});
        ((RootConfig)Mockito.verify((Object)this.rootConfig, (VerificationMode)Mockito.never())).saveConfig();
        ((RootConfig)Mockito.verify((Object)this.rootConfig, (VerificationMode)Mockito.never())).refreshLicenses();
    }

    @Test
    public void testWhenLicensesNotChangedNothingHappens() throws Exception {
        Mockito.when((Object)this.licenseType.getFisheye()).thenReturn((Object)"qpRopEjwRRsNNcldkLAJnDearOREObjJrOxwuRdaQHgsnkf\nmj2KhRwOjUSbPWZCt>0QzX3o2L05Ge<GJPJIAuLT8Oyt4Lz\nrrNoXXNqnrmrnNNMrmRTXPnPmqQRQnRPQqTxsVtVuVXXsOW\nVSrwssvXoNpqnnonmUUqmvrqmsummmmmUUqmvrqmsummmmm\nUU1qiXppfXkWGqvWCqaUUnmmmm");
        Mockito.when((Object)this.licenseType.getCrucible()).thenReturn((Object)"qMqRmLENIjGEKbtAQbwVtoXVqNopDBekhJgDJubIwKdUIJ\nmi2K2Bt6jt>dPQ0JYUoUcHMb2KXb<MWDz<WhaHUfybkCt0\nmqOOWwRNQMMPQMNoqQQWuQonQnpNRmmMNRVSstXsSXTxSP\nWvtoTTwwuPMmnonnnmUUqmvrqmsummmmmUUqmvrqmsummm\nmmUU1qiXppfXkWGqvWCqaUUnmmmm");
        Mockito.when((Object)this.licenseType.isSetCrucible()).thenReturn((Object)true);
        Mockito.when((Object)this.licenseType.isSetFisheye()).thenReturn((Object)true);
        this.licenseManager.updateLicenses("qpRopEjwRRsNNcldkLAJnDearOREObjJrOxwuRdaQHgsnkf\nmj2KhRwOjUSbPWZCt>0QzX3o2L05Ge<GJPJIAuLT8Oyt4Lz\nrrNoXXNqnrmrnNNMrmRTXPnPmqQRQnRPQqTxsVtVuVXXsOW\nVSrwssvXoNpqnnonmUUqmvrqmsummmmmUUqmvrqmsummmmm\nUU1qiXppfXkWGqvWCqaUUnmmmm", "qMqRmLENIjGEKbtAQbwVtoXVqNopDBekhJgDJubIwKdUIJ\nmi2K2Bt6jt>dPQ0JYUoUcHMb2KXb<MWDz<WhaHUfybkCt0\nmqOOWwRNQMMPQMNoqQQWuQonQnpNRmmMNRVSstXsSXTxSP\nWvtoTTwwuPMmnonnnmUUqmvrqmsummmmmUUqmvrqmsummm\nmmUU1qiXppfXkWGqvWCqaUUnmmmm");
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.eventPublisher});
        ((RootConfig)Mockito.verify((Object)this.rootConfig, (VerificationMode)Mockito.never())).saveConfig();
        ((RootConfig)Mockito.verify((Object)this.rootConfig, (VerificationMode)Mockito.never())).refreshLicenses();
    }

    @Test
    public void testWhenCruLicensesAreUpdated() throws Exception {
        Mockito.when((Object)this.licenseType.getFisheye()).thenReturn((Object)"");
        Mockito.when((Object)this.licenseType.getCrucible()).thenReturn((Object)"");
        Mockito.when((Object)this.licenseType.isSetCrucible()).thenReturn((Object)false);
        Mockito.when((Object)this.licenseType.isSetFisheye()).thenReturn((Object)true);
        this.licenseManager.updateLicenses("", "qMqRmLENIjGEKbtAQbwVtoXVqNopDBekhJgDJubIwKdUIJ\nmi2K2Bt6jt>dPQ0JYUoUcHMb2KXb<MWDz<WhaHUfybkCt0\nmqOOWwRNQMMPQMNoqQQWuQonQnpNRmmMNRVSstXsSXTxSP\nWvtoTTwwuPMmnonnnmUUqmvrqmsummmmmUUqmvrqmsummm\nmmUU1qiXppfXkWGqvWCqaUUnmmmm");
        ((LicenseType)Mockito.verify((Object)this.licenseType, (VerificationMode)Mockito.times((int)1))).setCrucible((String)Matchers.eq((Object)"qMqRmLENIjGEKbtAQbwVtoXVqNopDBekhJgDJubIwKdUIJ\nmi2K2Bt6jt>dPQ0JYUoUcHMb2KXb<MWDz<WhaHUfybkCt0\nmqOOWwRNQMMPQMNoqQQWuQonQnpNRmmMNRVSstXsSXTxSP\nWvtoTTwwuPMmnonnnmUUqmvrqmsummmmmUUqmvrqmsummm\nmmUU1qiXppfXkWGqvWCqaUUnmmmm"));
        ((EventPublisher)Mockito.verify((Object)this.eventPublisher, (VerificationMode)Mockito.times((int)1))).publish(Matchers.any(LicenseChangedEvent.class));
        ((RootConfig)Mockito.verify((Object)this.rootConfig, (VerificationMode)Mockito.times((int)1))).saveConfig();
        ((RootConfig)Mockito.verify((Object)this.rootConfig, (VerificationMode)Mockito.times((int)1))).refreshLicenses();
    }

    @Test
    public void testWhenFeLicensesAreUpdated() throws Exception {
        Mockito.when((Object)this.licenseType.getFisheye()).thenReturn((Object)"");
        Mockito.when((Object)this.licenseType.getCrucible()).thenReturn((Object)"");
        Mockito.when((Object)this.licenseType.isSetCrucible()).thenReturn((Object)true);
        Mockito.when((Object)this.licenseType.isSetFisheye()).thenReturn((Object)false);
        this.licenseManager.updateLicenses("qpRopEjwRRsNNcldkLAJnDearOREObjJrOxwuRdaQHgsnkf\nmj2KhRwOjUSbPWZCt>0QzX3o2L05Ge<GJPJIAuLT8Oyt4Lz\nrrNoXXNqnrmrnNNMrmRTXPnPmqQRQnRPQqTxsVtVuVXXsOW\nVSrwssvXoNpqnnonmUUqmvrqmsummmmmUUqmvrqmsummmmm\nUU1qiXppfXkWGqvWCqaUUnmmmm", "");
        ((LicenseType)Mockito.verify((Object)this.licenseType, (VerificationMode)Mockito.times((int)1))).setFisheye((String)Matchers.eq((Object)"qpRopEjwRRsNNcldkLAJnDearOREObjJrOxwuRdaQHgsnkf\nmj2KhRwOjUSbPWZCt>0QzX3o2L05Ge<GJPJIAuLT8Oyt4Lz\nrrNoXXNqnrmrnNNMrmRTXPnPmqQRQnRPQqTxsVtVuVXXsOW\nVSrwssvXoNpqnnonmUUqmvrqmsummmmmUUqmvrqmsummmmm\nUU1qiXppfXkWGqvWCqaUUnmmmm"));
        ((EventPublisher)Mockito.verify((Object)this.eventPublisher, (VerificationMode)Mockito.times((int)1))).publish(Matchers.any(LicenseChangedEvent.class));
        ((RootConfig)Mockito.verify((Object)this.rootConfig, (VerificationMode)Mockito.times((int)1))).saveConfig();
        ((RootConfig)Mockito.verify((Object)this.rootConfig, (VerificationMode)Mockito.times((int)1))).refreshLicenses();
    }

    @Test
    public void testWhenFeCruChangedLicensesAreUpdated() throws Exception {
        Mockito.when((Object)this.licenseType.getFisheye()).thenReturn((Object)"");
        Mockito.when((Object)this.licenseType.getCrucible()).thenReturn((Object)"");
        Mockito.when((Object)this.licenseType.isSetCrucible()).thenReturn((Object)true);
        Mockito.when((Object)this.licenseType.isSetFisheye()).thenReturn((Object)true);
        this.licenseManager.updateLicenses("qpRopEjwRRsNNcldkLAJnDearOREObjJrOxwuRdaQHgsnkf\nmj2KhRwOjUSbPWZCt>0QzX3o2L05Ge<GJPJIAuLT8Oyt4Lz\nrrNoXXNqnrmrnNNMrmRTXPnPmqQRQnRPQqTxsVtVuVXXsOW\nVSrwssvXoNpqnnonmUUqmvrqmsummmmmUUqmvrqmsummmmm\nUU1qiXppfXkWGqvWCqaUUnmmmm", "qMqRmLENIjGEKbtAQbwVtoXVqNopDBekhJgDJubIwKdUIJ\nmi2K2Bt6jt>dPQ0JYUoUcHMb2KXb<MWDz<WhaHUfybkCt0\nmqOOWwRNQMMPQMNoqQQWuQonQnpNRmmMNRVSstXsSXTxSP\nWvtoTTwwuPMmnonnnmUUqmvrqmsummmmmUUqmvrqmsummm\nmmUU1qiXppfXkWGqvWCqaUUnmmmm");
        ((LicenseType)Mockito.verify((Object)this.licenseType, (VerificationMode)Mockito.times((int)1))).setFisheye((String)Matchers.eq((Object)"qpRopEjwRRsNNcldkLAJnDearOREObjJrOxwuRdaQHgsnkf\nmj2KhRwOjUSbPWZCt>0QzX3o2L05Ge<GJPJIAuLT8Oyt4Lz\nrrNoXXNqnrmrnNNMrmRTXPnPmqQRQnRPQqTxsVtVuVXXsOW\nVSrwssvXoNpqnnonmUUqmvrqmsummmmmUUqmvrqmsummmmm\nUU1qiXppfXkWGqvWCqaUUnmmmm"));
        ((LicenseType)Mockito.verify((Object)this.licenseType, (VerificationMode)Mockito.times((int)1))).setCrucible((String)Matchers.eq((Object)"qMqRmLENIjGEKbtAQbwVtoXVqNopDBekhJgDJubIwKdUIJ\nmi2K2Bt6jt>dPQ0JYUoUcHMb2KXb<MWDz<WhaHUfybkCt0\nmqOOWwRNQMMPQMNoqQQWuQonQnpNRmmMNRVSstXsSXTxSP\nWvtoTTwwuPMmnonnnmUUqmvrqmsummmmmUUqmvrqmsummm\nmmUU1qiXppfXkWGqvWCqaUUnmmmm"));
        ((EventPublisher)Mockito.verify((Object)this.eventPublisher, (VerificationMode)Mockito.times((int)1))).publish(Matchers.any(LicenseChangedEvent.class));
        ((RootConfig)Mockito.verify((Object)this.rootConfig, (VerificationMode)Mockito.times((int)1))).saveConfig();
        ((RootConfig)Mockito.verify((Object)this.rootConfig, (VerificationMode)Mockito.times((int)1))).refreshLicenses();
    }

    @Test
    public void testWhenCruEnabledAndFeEvaluationLicenseGiven() throws Exception {
        Mockito.when((Object)this.licenseType.getFisheye()).thenReturn((Object)"");
        Mockito.when((Object)this.licenseType.getCrucible()).thenReturn((Object)"qMqRmLENIjGEKbtAQbwVtoXVqNopDBekhJgDJubIwKdUIJ\nmi2K2Bt6jt>dPQ0JYUoUcHMb2KXb<MWDz<WhaHUfybkCt0\nmqOOWwRNQMMPQMNoqQQWuQonQnpNRmmMNRVSstXsSXTxSP\nWvtoTTwwuPMmnonnnmUUqmvrqmsummmmmUUqmvrqmsummm\nmmUU1qiXppfXkWGqvWCqaUUnmmmm");
        Mockito.when((Object)this.licenseType.isSetCrucible()).thenReturn((Object)true);
        Mockito.when((Object)this.licenseType.isSetFisheye()).thenReturn((Object)true);
        this.licenseManager.updateLicenses("Evaluation", "AAAA9g0ODAoPeNptkN9LwzAQgN/zVwR8jrR1XbWQh5lELPaHbJ2D4UsWTg1ssVya4v57OzeYyh4Oj\nrvvvjvuqg1AZx3SJKbRbR6neXJHhWxpEsUpkeAN2q63n44LDMZutvCaUzXobdCHKhEIP4nUPfDDD\nIsmLImJOdHXpTXgPLT7Dmq9Ay6aqlJzUcxKctbwHgOQSlvXg9POgPrqLO5/SdM/0jrsNoDN29IDe\ns5i0uC7dtYfZQ8wglK9nHltejvAccsCcAAsJL9fT0smHpM5u1lGT0yoVUQWquZjsDKdplk2ycjp/\nBEvC3mpc/nS54DmQ3v4/5ZvQtB0MjAsAhRZu8BRmEf266R7FTlEOC7NuywfdAIUJ7TVba4TgWyOi\n95jkWCn9OYtzzI=X02co");
        ((LicenseType)Mockito.verify((Object)this.licenseType, (VerificationMode)Mockito.times((int)1))).setFisheye((String)Matchers.eq((Object)"Evaluation"));
        ((EventPublisher)Mockito.verify((Object)this.eventPublisher, (VerificationMode)Mockito.times((int)1))).publish(Matchers.any(LicenseChangedEvent.class));
        ((RootConfig)Mockito.verify((Object)this.rootConfig, (VerificationMode)Mockito.times((int)1))).saveConfig();
        ((RootConfig)Mockito.verify((Object)this.rootConfig, (VerificationMode)Mockito.times((int)1))).refreshLicenses();
    }

    @Test
    public void testWhenFeEnabledAndCruEvaluationLicenseGiven() throws Exception {
        Mockito.when((Object)this.licenseType.getFisheye()).thenReturn((Object)"AAAA+Q0ODAoPeNptkFtLxDAQhd/zKwI+R9pqWynkYU2yWOxF9qIgvsQw6wbcWCZNsf/e1vWG7MPAc\nOY7Z4Y52wSgiw5pEtPoqoizIsqpkBuaRHFKJHiDtuvtm+NL6/dqhKeCqkG/Bj2LRCB8NlL3wGcLi\ny5ZEpNfhPcYgOwmM4xwrk1vBzhqtbauB6edAfXeWRz/hKRzSIsv2ll/jFmCwSDVPVkDDoCl5NePW\ncXETbJiF9volgn1EJG1avhUrEqzNM/TjFTWgPMw4VUpT01Or/6+9wvajB00+gBctHWtVqJcVD9IE\nw7PgO1u6wE9ZzG5C2j22sP/n3wAydpynzAsAhQ0aE4ep9+7DWn9QHWPp9289eKKAgIUH8/2NO7cs\nOaDotJtd2PvijvoVt4=X02cs");
        Mockito.when((Object)this.licenseType.getCrucible()).thenReturn((Object)"Disabled");
        Mockito.when((Object)this.licenseType.isSetCrucible()).thenReturn((Object)true);
        Mockito.when((Object)this.licenseType.isSetFisheye()).thenReturn((Object)true);
        this.licenseManager.updateLicenses("AAAA+Q0ODAoPeNptkFtLxDAQhd/zKwI+R9pqWynkYU2yWOxF9qIgvsQw6wbcWCZNsf/e1vWG7MPAc\nOY7Z4Y52wSgiw5pEtPoqoizIsqpkBuaRHFKJHiDtuvtm+NL6/dqhKeCqkG/Bj2LRCB8NlL3wGcLi\ny5ZEpNfhPcYgOwmM4xwrk1vBzhqtbauB6edAfXeWRz/hKRzSIsv2ll/jFmCwSDVPVkDDoCl5NePW\ncXETbJiF9volgn1EJG1avhUrEqzNM/TjFTWgPMw4VUpT01Or/6+9wvajB00+gBctHWtVqJcVD9IE\nw7PgO1u6wE9ZzG5C2j22sP/n3wAydpynzAsAhQ0aE4ep9+7DWn9QHWPp9289eKKAgIUH8/2NO7cs\nOaDotJtd2PvijvoVt4=X02cs", "Evaluation");
        ((LicenseType)Mockito.verify((Object)this.licenseType, (VerificationMode)Mockito.times((int)1))).setCrucible((String)Matchers.eq((Object)"Evaluation"));
        ((EventPublisher)Mockito.verify((Object)this.eventPublisher, (VerificationMode)Mockito.times((int)1))).publish(Matchers.any(LicenseChangedEvent.class));
        ((RootConfig)Mockito.verify((Object)this.rootConfig, (VerificationMode)Mockito.times((int)1))).saveConfig();
        ((RootConfig)Mockito.verify((Object)this.rootConfig, (VerificationMode)Mockito.times((int)1))).refreshLicenses();
    }

    @Test
    public void testFishEyeUsersCount() throws Exception {
        int fisheyeUsers = 29;
        Mockito.when((Object)this.globalPermissionManager.countUsersWithPermission((GlobalPermissionType)Matchers.eq((Object)GlobalPermissionType.FISHEYE_USER))).thenReturn((Object)29);
        int result = this.licenseManager.getFishEyeUsersCount();
        Assert.assertEquals((String)"There should be 29 Fisheye users", (long)29L, (long)result);
    }

    @Test
    public void testCrucibleUsersCount() throws Exception {
        int crucibleUsers = 64;
        Mockito.when((Object)this.globalPermissionManager.countUsersWithPermission((GlobalPermissionType)Matchers.eq((Object)GlobalPermissionType.CRUCIBLE_USER))).thenReturn((Object)64);
        int result = this.licenseManager.getCrucibleUsersCount();
        Assert.assertEquals((String)"There should be 64 Crucible users", (long)64L, (long)result);
    }

    @Test
    public void testActiveUsersCount() throws Exception {
        int activeUsers = 24;
        Mockito.when((Object)this.globalPermissionManager.countUsersWithPermission((GlobalPermissionType)Matchers.eq((Object)GlobalPermissionType.FISHEYE_USER))).thenReturn((Object)24);
        int result = this.licenseManager.getLicensedUsersCount();
        Assert.assertEquals((String)"There should be 24 active users", (long)24L, (long)result);
    }

    @Test
    public void testExcessFeLicenseUsers() throws Exception {
        this.prepareRealConfigXML();
        Mockito.when((Object)this.globalPermissionManager.countUsersWithPermission((GlobalPermissionType)Matchers.eq((Object)GlobalPermissionType.FISHEYE_USER))).thenReturn((Object)34);
        Mockito.when((Object)this.globalPermissionManager.countUsersWithPermission((GlobalPermissionType)Matchers.eq((Object)GlobalPermissionType.CRUCIBLE_USER))).thenReturn((Object)24);
        this.licenseManager.updateLicenses("AAABqw0ODAoPeNp9kdFO2zAUhu/9FEfaXSWnSWGUVYo0SAxigqRqEyS2ceEmp63BsSPbacnbz7RBY2jiwldH53z///nLnVZwhSsII4iiWXg6C0+gLBKYhNEZWQu7xR6DW1Ghslj0LcYpu2e3+ZwtSNY1KzT5urRobDwJSaKV45XLeIPxRuKeq1rv7bP4zp3k1gqugko3ZN6Zasstptxh/Mqh4YSGEXlHOZz4Sxom7KUVpj+sdUqKRjis36Dsjgv5GfU/XT5Qlmh2aG7S+JJNGT1Nf07oWf5jSq9Pvp2T0WiU5QW9yhd0vsjTMilu8oyWS+YHcWLQh6ph1YPbIgwIYKrSNRpojX7CysGvrXPt79l4vNHBP+HG8rhB8bjxGECqQWkHtbDOiFXn0F8WFpyGqrNON155QHxn5VBxVb1345VOB6U+XLJgFwVL6eXDa9JPBA2pff9SPSu9V2TJstg/+jUMSW42XAnLndAqZi+8aSVCopuWq54c+vvBxx99c+7/R+wwdqZDkqKtjGgPdwq0DobusNbelOw2QkGNO5S69R0J23HZHalrLi2SP4/36xEwLAIUa9q1kHlHKjIiUQutMfCi0FJD6mgCFGFHbzIzBSrjzGj74EpxytZhUWWXX02kg", null);
        int feUsers = this.licenseManager.getExcessFEUsers();
        int cruUsers = this.licenseManager.getExcessCruUsers();
        Assert.assertEquals((long)14L, (long)feUsers);
        Assert.assertEquals((long)0L, (long)cruUsers);
    }

    @Test
    public void testExcessCruLicenseUsers() throws Exception {
        this.prepareRealConfigXML();
        Mockito.when((Object)this.globalPermissionManager.countUsersWithPermission((GlobalPermissionType)Matchers.eq((Object)GlobalPermissionType.FISHEYE_USER))).thenReturn((Object)34);
        Mockito.when((Object)this.globalPermissionManager.countUsersWithPermission((GlobalPermissionType)Matchers.eq((Object)GlobalPermissionType.CRUCIBLE_USER))).thenReturn((Object)24);
        this.licenseManager.updateLicenses(null, "AAABrA0ODAoPeNp9ks1u2zAQhO98igV6M0BZVtI4NSCgjcQUKRLJsKUC/TtQ1NpmQ5ECSdnx25exHdQNihx4Wu7M7Lf77sFouMUG4glM4tnF5SxJoK4ySOLJFSmGrkFbrmqH1qVJTDKjPRe+4B2ma4U7rluzc4/yI/eKOye5joTpyHywYsMd5txj+qxE44TGE3IvBWqH1b7Hg0TOvrL7cs4WLxX21Eu7P7QNWslOemxfTNkDl+ot1yXaLdq7PL1hU0Yv8+8JvSq/TOnniw/XRNhByEZhdJbhzP9/5VcRR6NRUVb0tlzQ+aLM66y6KwtaL1kopJnFELqFZg9+g3BSAaaFadFCb81vFB5+bLzvf87G47WJ/gk/VscOiseOXxHkBrTx0ErnrWwGj0FZOvAGxOC86cJKIhKYaI+aa3HOLiCfnpCHcNmCfapYTm++PSd9A+ApdSBY60dtdposWZGGR9/HMSntmmvpuJdGp+yJd71CyEzXc73/yy8sSm4x9XZAcoASfr8+gxydsLI/CFXoPJyGh5UJqNSwlhpa3KIyfRiSsC1Xw9F2xZVD8gdGsewoMC0CFQCBjnk6VZ6n/Lnm3inyAZEa42WCNgIUEO63dcba893s2jsoDuIIUZz2KyQ=X02kk");
        int feUsers = this.licenseManager.getExcessFEUsers();
        int cruUsers = this.licenseManager.getExcessCruUsers();
        Assert.assertEquals((long)0L, (long)feUsers);
        Assert.assertEquals((long)4L, (long)cruUsers);
    }

    @Test
    public void testExcessFeCruLicenseUsers() throws Exception {
        this.prepareRealConfigXML();
        Mockito.when((Object)this.globalPermissionManager.countUsersWithPermission((GlobalPermissionType)Matchers.eq((Object)GlobalPermissionType.FISHEYE_USER))).thenReturn((Object)34);
        Mockito.when((Object)this.globalPermissionManager.countUsersWithPermission((GlobalPermissionType)Matchers.eq((Object)GlobalPermissionType.CRUCIBLE_USER))).thenReturn((Object)24);
        this.licenseManager.updateLicenses("AAABqw0ODAoPeNp9kdFO2zAUhu/9FEfaXSWnSWGUVYo0SAxigqRqEyS2ceEmp63BsSPbacnbz7RBY2jiwldH53z///nLnVZwhSsII4iiWXg6C0+gLBKYhNEZWQu7xR6DW1Ghslj0LcYpu2e3+ZwtSNY1KzT5urRobDwJSaKV45XLeIPxRuKeq1rv7bP4zp3k1gqugko3ZN6Zasstptxh/Mqh4YSGEXlHOZz4Sxom7KUVpj+sdUqKRjis36Dsjgv5GfU/XT5Qlmh2aG7S+JJNGT1Nf07oWf5jSq9Pvp2T0WiU5QW9yhd0vsjTMilu8oyWS+YHcWLQh6ph1YPbIgwIYKrSNRpojX7CysGvrXPt79l4vNHBP+HG8rhB8bjxGECqQWkHtbDOiFXn0F8WFpyGqrNON155QHxn5VBxVb1345VOB6U+XLJgFwVL6eXDa9JPBA2pff9SPSu9V2TJstg/+jUMSW42XAnLndAqZi+8aSVCopuWq54c+vvBxx99c+7/R+wwdqZDkqKtjGgPdwq0DobusNbelOw2QkGNO5S69R0J23HZHalrLi2SP4/36xEwLAIUa9q1kHlHKjIiUQutMfCi0FJD6mgCFGFHbzIzBSrjzGj74EpxytZhUWWXX02kg", "AAABrA0ODAoPeNp9ks1u2zAQhO98igV6M0BZVtI4NSCgjcQUKRLJsKUC/TtQ1NpmQ5ECSdnx25exHdQNihx4Wu7M7Lf77sFouMUG4glM4tnF5SxJoK4ySOLJFSmGrkFbrmqH1qVJTDKjPRe+4B2ma4U7rluzc4/yI/eKOye5joTpyHywYsMd5txj+qxE44TGE3IvBWqH1b7Hg0TOvrL7cs4WLxX21Eu7P7QNWslOemxfTNkDl+ot1yXaLdq7PL1hU0Yv8+8JvSq/TOnniw/XRNhByEZhdJbhzP9/5VcRR6NRUVb0tlzQ+aLM66y6KwtaL1kopJnFELqFZg9+g3BSAaaFadFCb81vFB5+bLzvf87G47WJ/gk/VscOiseOXxHkBrTx0ErnrWwGj0FZOvAGxOC86cJKIhKYaI+aa3HOLiCfnpCHcNmCfapYTm++PSd9A+ApdSBY60dtdposWZGGR9/HMSntmmvpuJdGp+yJd71CyEzXc73/yy8sSm4x9XZAcoASfr8+gxydsLI/CFXoPJyGh5UJqNSwlhpa3KIyfRiSsC1Xw9F2xZVD8gdGsewoMC0CFQCBjnk6VZ6n/Lnm3inyAZEa42WCNgIUEO63dcba893s2jsoDuIIUZz2KyQ=X02kk");
        int feUsers = this.licenseManager.getExcessFEUsers();
        int cruUsers = this.licenseManager.getExcessCruUsers();
        Assert.assertEquals((long)14L, (long)feUsers);
        Assert.assertEquals((long)4L, (long)cruUsers);
    }

    private void prepareRealConfigXML() throws IOException, ConfigException {
        this.rootConfig = this.rootConfigRule.loadRootConfigFile(CONFIG_XML);
        this.licenseManager = new DefaultLicenseManager(this.rootConfig, this.eventPublisher, this.globalPermissionManager);
    }
}

