/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.iterators;

import com.atlassian.fecru.iterators.PrefetchIterator;
import com.atlassian.fecru.iterators.PrefetchIteratorValueProvider;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.managers.ReviewManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class PrefetchIteratorTest {
    private final List<Integer> ids20 = Arrays.asList(1, 10, 2, 20, 3, 30, 4, 40, 5, 50, 6, 60, 7, 70, 8, 80, 9, 90, 10, 100);
    private List<Review> reviews20;
    private PrefetchIterator<Integer, Review> reviewIterator;
    private PrefetchIteratorValueProvider<Integer, Review> reviewProvider;
    private ReviewManager reviewManagerMock;

    @Before
    public void setUp() throws Exception {
        this.reviewManagerMock = (ReviewManager)Mockito.mock(ReviewManager.class);
        this.reviewProvider = keys -> this.reviewManagerMock.getReviewsOrderedByIds(keys);
        this.reviews20 = new ArrayList<Review>();
        for (Integer id : this.ids20) {
            Review review = (Review)Mockito.mock(Review.class);
            Mockito.when((Object)review.getId()).thenReturn((Object)id);
            this.reviews20.add(review);
        }
    }

    @Test
    public void testHasNextEmptyListOfIds() throws Exception {
        this.reviewIterator = new PrefetchIterator((Collection)Collections.EMPTY_LIST, this.reviewProvider, 5);
        Assert.assertThat((Object)this.reviewIterator.hasNext(), (Matcher)org.hamcrest.Matchers.equalTo((Object)false));
    }

    @Test(expected=NoSuchElementException.class)
    public void testNextEmptyListOfIds() throws Exception {
        this.reviewIterator = new PrefetchIterator((Collection)Collections.EMPTY_LIST, this.reviewProvider, 5);
        this.reviewIterator.next();
    }

    @Test
    public void testHasNextReviewManagerReturnsNoReview() throws Exception {
        Mockito.when((Object)this.reviewManagerMock.getReviewsOrderedByIds(Matchers.anyList())).thenReturn((Object)Collections.EMPTY_LIST);
        this.reviewIterator = new PrefetchIterator(this.ids20, this.reviewProvider, 5);
        Assert.assertThat((Object)this.reviewIterator.hasNext(), (Matcher)org.hamcrest.Matchers.equalTo((Object)false));
    }

    @Test(expected=NoSuchElementException.class)
    public void testNextReviewManagerReturnsNoReview() throws Exception {
        Mockito.when((Object)this.reviewManagerMock.getReviewsOrderedByIds(Matchers.anyList())).thenReturn((Object)Collections.EMPTY_LIST);
        this.reviewIterator = new PrefetchIterator(this.ids20, this.reviewProvider, 5);
        this.reviewIterator.next();
    }

    @Test
    public void testTraversalWithOneReviewManagerQueryPrefetchSize50() throws Exception {
        Mockito.when((Object)this.reviewManagerMock.getReviewsOrderedByIds(this.ids20)).thenReturn(this.reviews20);
        this.reviewIterator = new PrefetchIterator(this.ids20, this.reviewProvider, 50);
        int counter = 0;
        while (this.reviewIterator.hasNext()) {
            this.reviewIterator.next();
            ++counter;
        }
        Assert.assertThat((Object)counter, (Matcher)org.hamcrest.Matchers.equalTo((Object)20));
        ((ReviewManager)Mockito.verify((Object)this.reviewManagerMock, (VerificationMode)Mockito.times((int)1))).getReviewsOrderedByIds(Matchers.anyList());
    }

    @Test
    public void testTraversalWithOneReviewManagerQueryPrefetchSize20() throws Exception {
        Mockito.when((Object)this.reviewManagerMock.getReviewsOrderedByIds(this.ids20)).thenReturn(this.reviews20);
        this.reviewIterator = new PrefetchIterator(this.ids20, this.reviewProvider, 20);
        int counter = 0;
        while (this.reviewIterator.hasNext()) {
            this.reviewIterator.next();
            ++counter;
        }
        Assert.assertThat((Object)counter, (Matcher)org.hamcrest.Matchers.equalTo((Object)20));
        ((ReviewManager)Mockito.verify((Object)this.reviewManagerMock, (VerificationMode)Mockito.times((int)1))).getReviewsOrderedByIds(Matchers.anyList());
    }

    @Test
    public void testTraversalWithTwoReviewManagerQueryPrefetchSize10() throws Exception {
        Mockito.when((Object)this.reviewManagerMock.getReviewsOrderedByIds(this.ids20.subList(0, 10))).thenReturn(this.reviews20.subList(0, 10));
        Mockito.when((Object)this.reviewManagerMock.getReviewsOrderedByIds(this.ids20.subList(10, 20))).thenReturn(this.reviews20.subList(10, 20));
        this.reviewIterator = new PrefetchIterator(this.ids20, this.reviewProvider, 10);
        int counter = 0;
        while (this.reviewIterator.hasNext()) {
            this.reviewIterator.next();
            ++counter;
        }
        Assert.assertThat((Object)counter, (Matcher)org.hamcrest.Matchers.equalTo((Object)20));
        ((ReviewManager)Mockito.verify((Object)this.reviewManagerMock, (VerificationMode)Mockito.times((int)2))).getReviewsOrderedByIds(Matchers.anyList());
    }

    @Test
    public void testTraversalWithFourReviewManagerQueryPrefetchSize5() throws Exception {
        Mockito.when((Object)this.reviewManagerMock.getReviewsOrderedByIds(this.ids20.subList(0, 5))).thenReturn(this.reviews20.subList(0, 5));
        Mockito.when((Object)this.reviewManagerMock.getReviewsOrderedByIds(this.ids20.subList(5, 10))).thenReturn(this.reviews20.subList(5, 10));
        Mockito.when((Object)this.reviewManagerMock.getReviewsOrderedByIds(this.ids20.subList(10, 15))).thenReturn(this.reviews20.subList(10, 15));
        Mockito.when((Object)this.reviewManagerMock.getReviewsOrderedByIds(this.ids20.subList(15, 20))).thenReturn(this.reviews20.subList(15, 20));
        this.reviewIterator = new PrefetchIterator(this.ids20, this.reviewProvider, 5);
        int counter = 0;
        while (this.reviewIterator.hasNext()) {
            this.reviewIterator.next();
            ++counter;
        }
        Assert.assertThat((Object)counter, (Matcher)org.hamcrest.Matchers.equalTo((Object)20));
        ((ReviewManager)Mockito.verify((Object)this.reviewManagerMock, (VerificationMode)Mockito.times((int)4))).getReviewsOrderedByIds(Matchers.anyList());
    }

    @Test
    public void testTraversalWithFourReviewManagerQueryPrefetchSizeNotEven() throws Exception {
        Mockito.when((Object)this.reviewManagerMock.getReviewsOrderedByIds(this.ids20.subList(0, 7))).thenReturn(this.reviews20.subList(0, 7));
        Mockito.when((Object)this.reviewManagerMock.getReviewsOrderedByIds(this.ids20.subList(7, 14))).thenReturn(this.reviews20.subList(7, 14));
        Mockito.when((Object)this.reviewManagerMock.getReviewsOrderedByIds(this.ids20.subList(14, 20))).thenReturn(this.reviews20.subList(14, 20));
        this.reviewIterator = new PrefetchIterator(this.ids20, this.reviewProvider, 7);
        int counter = 0;
        while (this.reviewIterator.hasNext()) {
            this.reviewIterator.next();
            ++counter;
        }
        Assert.assertThat((Object)counter, (Matcher)org.hamcrest.Matchers.equalTo((Object)20));
        ((ReviewManager)Mockito.verify((Object)this.reviewManagerMock, (VerificationMode)Mockito.times((int)3))).getReviewsOrderedByIds(Matchers.anyList());
    }

    @Test
    public void testTraversalCheckIfReturnedOrderSameAsReturnedFromReviewManager() throws Exception {
        Mockito.when((Object)this.reviewManagerMock.getReviewsOrderedByIds(this.ids20.subList(0, 10))).thenReturn(this.reviews20.subList(0, 10));
        Mockito.when((Object)this.reviewManagerMock.getReviewsOrderedByIds(this.ids20.subList(10, 20))).thenReturn(this.reviews20.subList(10, 20));
        this.reviewIterator = new PrefetchIterator(this.ids20, this.reviewProvider, 10);
        int counter = 0;
        while (this.reviewIterator.hasNext()) {
            Review review = (Review)this.reviewIterator.next();
            Assert.assertThat((Object)this.ids20.get(counter), (Matcher)org.hamcrest.Matchers.equalTo((Object)review.getId()));
            ++counter;
        }
        Assert.assertThat((Object)counter, (Matcher)org.hamcrest.Matchers.equalTo((Object)20));
    }

    @Test(expected=NoSuchElementException.class)
    public void testTraversalWhenCallingNextAfterLast() throws Exception {
        Mockito.when((Object)this.reviewManagerMock.getReviewsOrderedByIds(this.ids20)).thenReturn(this.reviews20);
        this.reviewIterator = new PrefetchIterator(this.ids20, this.reviewProvider, 10);
        while (this.reviewIterator.hasNext()) {
            this.reviewIterator.next();
        }
        this.reviewIterator.next();
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testRemove() throws Exception {
        Mockito.when((Object)this.reviewManagerMock.getReviewsOrderedByIds(this.ids20)).thenReturn(this.reviews20);
        this.reviewIterator = new PrefetchIterator(this.ids20, this.reviewProvider, 10);
        this.reviewIterator.remove();
    }

    @Test
    public void testSkip0WithEmptyCache() throws Exception {
        Mockito.when((Object)this.reviewManagerMock.getReviewsOrderedByIds(this.ids20.subList(0, 10))).thenReturn(this.reviews20.subList(0, 10));
        Mockito.when((Object)this.reviewManagerMock.getReviewsOrderedByIds(this.ids20.subList(10, 20))).thenReturn(this.reviews20.subList(10, 20));
        this.reviewIterator = new PrefetchIterator(this.ids20, this.reviewProvider, 10);
        int counter = 0;
        Assert.assertThat((Object)this.reviewIterator.skip(0), (Matcher)org.hamcrest.Matchers.equalTo((Object)0));
        while (this.reviewIterator.hasNext()) {
            this.reviewIterator.next();
            ++counter;
        }
        Assert.assertThat((Object)counter, (Matcher)org.hamcrest.Matchers.equalTo((Object)20));
    }

    @Test
    public void testSkip0WithNonEmptyCache() throws Exception {
        Mockito.when((Object)this.reviewManagerMock.getReviewsOrderedByIds(this.ids20.subList(0, 10))).thenReturn(this.reviews20.subList(0, 10));
        Mockito.when((Object)this.reviewManagerMock.getReviewsOrderedByIds(this.ids20.subList(10, 20))).thenReturn(this.reviews20.subList(10, 20));
        this.reviewIterator = new PrefetchIterator(this.ids20, this.reviewProvider, 10);
        int counter = 0;
        while (this.reviewIterator.hasNext()) {
            this.reviewIterator.next();
            Assert.assertThat((Object)this.reviewIterator.skip(0), (Matcher)org.hamcrest.Matchers.equalTo((Object)0));
            ++counter;
        }
        Assert.assertThat((Object)counter, (Matcher)org.hamcrest.Matchers.equalTo((Object)20));
    }

    @Test
    public void testSkip5WithEmptyCache() throws Exception {
        Mockito.when((Object)this.reviewManagerMock.getReviewsOrderedByIds(this.ids20.subList(5, 15))).thenReturn(this.reviews20.subList(5, 15));
        Mockito.when((Object)this.reviewManagerMock.getReviewsOrderedByIds(this.ids20.subList(15, 20))).thenReturn(this.reviews20.subList(15, 20));
        this.reviewIterator = new PrefetchIterator(this.ids20, this.reviewProvider, 10);
        Assert.assertThat((Object)this.reviewIterator.skip(5), (Matcher)org.hamcrest.Matchers.equalTo((Object)5));
        int counter = 0;
        List<Integer> expectedIds = this.ids20.subList(5, 20);
        while (this.reviewIterator.hasNext()) {
            Review review = (Review)this.reviewIterator.next();
            Assert.assertThat((Object)expectedIds.get(counter), (Matcher)org.hamcrest.Matchers.equalTo((Object)review.getId()));
            ++counter;
        }
        Assert.assertThat((Object)counter, (Matcher)org.hamcrest.Matchers.equalTo((Object)15));
    }

    @Test
    public void testSkip7WithEmptyCache() throws Exception {
        Mockito.when((Object)this.reviewManagerMock.getReviewsOrderedByIds(this.ids20.subList(7, 17))).thenReturn(this.reviews20.subList(7, 17));
        Mockito.when((Object)this.reviewManagerMock.getReviewsOrderedByIds(this.ids20.subList(17, 20))).thenReturn(this.reviews20.subList(17, 20));
        this.reviewIterator = new PrefetchIterator(this.ids20, this.reviewProvider, 10);
        Assert.assertThat((Object)this.reviewIterator.skip(7), (Matcher)org.hamcrest.Matchers.equalTo((Object)7));
        int counter = 0;
        List<Integer> expectedIds = this.ids20.subList(7, 20);
        while (this.reviewIterator.hasNext()) {
            Review review = (Review)this.reviewIterator.next();
            Assert.assertThat((Object)expectedIds.get(counter), (Matcher)org.hamcrest.Matchers.equalTo((Object)review.getId()));
            ++counter;
        }
        Assert.assertThat((Object)counter, (Matcher)org.hamcrest.Matchers.equalTo((Object)13));
    }

    @Test
    public void testSkip10WithEmptyCache() throws Exception {
        Mockito.when((Object)this.reviewManagerMock.getReviewsOrderedByIds(this.ids20.subList(0, 10))).thenReturn(this.reviews20.subList(0, 10));
        Mockito.when((Object)this.reviewManagerMock.getReviewsOrderedByIds(this.ids20.subList(10, 20))).thenReturn(this.reviews20.subList(10, 20));
        this.reviewIterator = new PrefetchIterator(this.ids20, this.reviewProvider, 10);
        Assert.assertThat((Object)this.reviewIterator.skip(10), (Matcher)org.hamcrest.Matchers.equalTo((Object)10));
        int counter = 0;
        List<Integer> expectedIds = this.ids20.subList(10, 20);
        while (this.reviewIterator.hasNext()) {
            Review review = (Review)this.reviewIterator.next();
            Assert.assertThat((Object)expectedIds.get(counter), (Matcher)org.hamcrest.Matchers.equalTo((Object)review.getId()));
            ++counter;
        }
        Assert.assertThat((Object)counter, (Matcher)org.hamcrest.Matchers.equalTo((Object)10));
    }

    @Test
    public void testSkip15WithEmptyCache() throws Exception {
        Mockito.when((Object)this.reviewManagerMock.getReviewsOrderedByIds(this.ids20.subList(15, 20))).thenReturn(this.reviews20.subList(15, 20));
        this.reviewIterator = new PrefetchIterator(this.ids20, this.reviewProvider, 10);
        Assert.assertThat((Object)this.reviewIterator.skip(15), (Matcher)org.hamcrest.Matchers.equalTo((Object)15));
        int counter = 0;
        List<Integer> expectedIds = this.ids20.subList(15, 20);
        while (this.reviewIterator.hasNext()) {
            Review review = (Review)this.reviewIterator.next();
            Assert.assertThat((Object)expectedIds.get(counter), (Matcher)org.hamcrest.Matchers.equalTo((Object)review.getId()));
            ++counter;
        }
        Assert.assertThat((Object)counter, (Matcher)org.hamcrest.Matchers.equalTo((Object)5));
    }

    @Test
    public void testSkip20WithEmptyCache() throws Exception {
        Mockito.when((Object)this.reviewManagerMock.getReviewsOrderedByIds(Matchers.anyList())).thenReturn((Object)Collections.EMPTY_LIST);
        this.reviewIterator = new PrefetchIterator(this.ids20, this.reviewProvider, 10);
        Assert.assertThat((Object)this.reviewIterator.skip(20), (Matcher)org.hamcrest.Matchers.equalTo((Object)20));
        int counter = 0;
        while (this.reviewIterator.hasNext()) {
            this.reviewIterator.next();
            ++counter;
        }
        Assert.assertThat((Object)counter, (Matcher)org.hamcrest.Matchers.equalTo((Object)0));
        ((ReviewManager)Mockito.verify((Object)this.reviewManagerMock, (VerificationMode)Mockito.times((int)0))).getReviewsOrderedByIds(Matchers.anyList());
    }

    @Test
    public void testSkip25WithEmptyCache() throws Exception {
        Mockito.when((Object)this.reviewManagerMock.getReviewsOrderedByIds(Matchers.anyList())).thenReturn((Object)Collections.EMPTY_LIST);
        this.reviewIterator = new PrefetchIterator(this.ids20, this.reviewProvider, 10);
        Assert.assertThat((Object)this.reviewIterator.skip(25), (Matcher)org.hamcrest.Matchers.equalTo((Object)20));
        int counter = 0;
        while (this.reviewIterator.hasNext()) {
            this.reviewIterator.next();
            ++counter;
        }
        Assert.assertThat((Object)counter, (Matcher)org.hamcrest.Matchers.equalTo((Object)0));
        ((ReviewManager)Mockito.verify((Object)this.reviewManagerMock, (VerificationMode)Mockito.times((int)0))).getReviewsOrderedByIds(Matchers.anyList());
    }

    @Test
    public void testSkip5CacheOnly() throws Exception {
        Mockito.when((Object)this.reviewManagerMock.getReviewsOrderedByIds(this.ids20.subList(0, 10))).thenReturn(this.reviews20.subList(0, 10));
        Mockito.when((Object)this.reviewManagerMock.getReviewsOrderedByIds(this.ids20.subList(10, 20))).thenReturn(this.reviews20.subList(10, 20));
        this.reviewIterator = new PrefetchIterator(this.ids20, this.reviewProvider, 10);
        int counter = 0;
        this.reviewIterator.next();
        ++counter;
        this.reviewIterator.next();
        ++counter;
        Assert.assertThat((Object)this.reviewIterator.skip(5), (Matcher)org.hamcrest.Matchers.equalTo((Object)5));
        List<Integer> expectedIds = this.ids20.subList(7, 20);
        int i = 0;
        while (this.reviewIterator.hasNext()) {
            Review review = (Review)this.reviewIterator.next();
            Assert.assertThat((Object)expectedIds.get(i++), (Matcher)org.hamcrest.Matchers.equalTo((Object)review.getId()));
            ++counter;
        }
        Assert.assertThat((Object)counter, (Matcher)org.hamcrest.Matchers.equalTo((Object)15));
        ((ReviewManager)Mockito.verify((Object)this.reviewManagerMock, (VerificationMode)Mockito.times((int)2))).getReviewsOrderedByIds(Matchers.anyList());
    }

    @Test
    public void testSkip10CacheAndIds() throws Exception {
        Mockito.when((Object)this.reviewManagerMock.getReviewsOrderedByIds(this.ids20.subList(0, 10))).thenReturn(this.reviews20.subList(0, 10));
        Mockito.when((Object)this.reviewManagerMock.getReviewsOrderedByIds(this.ids20.subList(12, 20))).thenReturn(this.reviews20.subList(12, 20));
        this.reviewIterator = new PrefetchIterator(this.ids20, this.reviewProvider, 10);
        int counter = 0;
        this.reviewIterator.next();
        ++counter;
        this.reviewIterator.next();
        ++counter;
        Assert.assertThat((Object)this.reviewIterator.skip(10), (Matcher)org.hamcrest.Matchers.equalTo((Object)10));
        List<Integer> expectedIds = this.ids20.subList(12, 20);
        int i = 0;
        while (this.reviewIterator.hasNext()) {
            Review review = (Review)this.reviewIterator.next();
            Assert.assertThat((Object)expectedIds.get(i++), (Matcher)org.hamcrest.Matchers.equalTo((Object)review.getId()));
            ++counter;
        }
        Assert.assertThat((Object)counter, (Matcher)org.hamcrest.Matchers.equalTo((Object)10));
        ((ReviewManager)Mockito.verify((Object)this.reviewManagerMock, (VerificationMode)Mockito.times((int)2))).getReviewsOrderedByIds(Matchers.anyList());
    }

    @Test
    public void testSkip20CacheAndIds() throws Exception {
        Mockito.when((Object)this.reviewManagerMock.getReviewsOrderedByIds(this.ids20.subList(0, 10))).thenReturn(this.reviews20.subList(0, 10));
        this.reviewIterator = new PrefetchIterator(this.ids20, this.reviewProvider, 10);
        int counter = 0;
        this.reviewIterator.next();
        ++counter;
        Assert.assertThat((Object)this.reviewIterator.skip(20), (Matcher)org.hamcrest.Matchers.equalTo((Object)19));
        while (this.reviewIterator.hasNext()) {
            this.reviewIterator.next();
            ++counter;
        }
        Assert.assertThat((Object)counter, (Matcher)org.hamcrest.Matchers.equalTo((Object)1));
        ((ReviewManager)Mockito.verify((Object)this.reviewManagerMock, (VerificationMode)Mockito.times((int)1))).getReviewsOrderedByIds(Matchers.anyList());
    }
}

